/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.utils;

import com.hm.achievement.category.Category;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.utils.PlayerAdvancedAchievementEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Singleton
public class StatisticIncreaseHandler
implements Reloadable {
    protected final YamlConfiguration mainConfig;
    protected final AchievementMap achievementMap;
    protected final CacheManager cacheManager;
    private boolean configRestrictCreative;
    private boolean configRestrictSpectator;
    private boolean configRestrictAdventure;
    private Set<String> configExcludedWorlds;

    @Inject
    public StatisticIncreaseHandler(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        this.mainConfig = yamlConfiguration;
        this.achievementMap = achievementMap;
        this.cacheManager = cacheManager;
    }

    @Override
    public void extractConfigurationParameters() {
        this.configRestrictCreative = this.mainConfig.getBoolean("RestrictCreative");
        this.configRestrictSpectator = this.mainConfig.getBoolean("RestrictSpectator");
        this.configRestrictAdventure = this.mainConfig.getBoolean("RestrictAdventure");
        this.configExcludedWorlds = new HashSet<String>(this.mainConfig.getStringList("ExcludedWorlds"));
    }

    public void checkThresholdsAndAchievements(Player player, Category category, long l) {
        this.checkThresholdsAndAchievements(player, this.achievementMap.getForCategory(category), l);
    }

    public void checkThresholdsAndAchievements(Player player, Category category, String string, long l) {
        this.checkThresholdsAndAchievements(player, this.achievementMap.getForCategoryAndSubcategory(category, string), l);
    }

    private void checkThresholdsAndAchievements(Player player, List<Achievement> list, long l) {
        for (Achievement achievement : list) {
            if (l < achievement.getThreshold()) {
                return;
            }
            if (this.cacheManager.hasPlayerAchievement(player.getUniqueId(), achievement.getName()) || !player.hasPermission("achievement." + achievement.getName())) continue;
            Bukkit.getPluginManager().callEvent((Event)new PlayerAdvancedAchievementEvent(player, achievement));
        }
    }

    protected boolean shouldIncreaseBeTakenIntoAccount(Player player, Category category) {
        GameMode gameMode = player.getGameMode();
        return !(player.hasMetadata("NPC") || !player.hasPermission(category.toPermName()) || this.configRestrictCreative && gameMode == GameMode.CREATIVE || this.configRestrictSpectator && gameMode == GameMode.SPECTATOR || this.configRestrictAdventure && gameMode == GameMode.ADVENTURE || this.configExcludedWorlds.contains(player.getWorld().getName()));
    }
}

