/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.lang3;

import com.hm.apache.commons.lang3.RandomUtils;
import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int n) {
        return RandomStringUtils.random(n, false, false);
    }

    public static String randomAscii(int n) {
        return RandomStringUtils.random(n, 32, 127, false, false);
    }

    public static String randomAscii(int n, int n2) {
        return RandomStringUtils.randomAscii(RandomUtils.nextInt(n, n2));
    }

    public static String randomAlphabetic(int n) {
        return RandomStringUtils.random(n, true, false);
    }

    public static String randomAlphabetic(int n, int n2) {
        return RandomStringUtils.randomAlphabetic(RandomUtils.nextInt(n, n2));
    }

    public static String randomAlphanumeric(int n) {
        return RandomStringUtils.random(n, true, true);
    }

    public static String randomAlphanumeric(int n, int n2) {
        return RandomStringUtils.randomAlphanumeric(RandomUtils.nextInt(n, n2));
    }

    public static String randomGraph(int n) {
        return RandomStringUtils.random(n, 33, 126, false, false);
    }

    public static String randomGraph(int n, int n2) {
        return RandomStringUtils.randomGraph(RandomUtils.nextInt(n, n2));
    }

    public static String randomNumeric(int n) {
        return RandomStringUtils.random(n, false, true);
    }

    public static String randomNumeric(int n, int n2) {
        return RandomStringUtils.randomNumeric(RandomUtils.nextInt(n, n2));
    }

    public static String randomPrint(int n) {
        return RandomStringUtils.random(n, 32, 126, false, false);
    }

    public static String randomPrint(int n, int n2) {
        return RandomStringUtils.randomPrint(RandomUtils.nextInt(n, n2));
    }

    public static String random(int n, boolean bl, boolean bl2) {
        return RandomStringUtils.random(n, 0, 0, bl, bl2);
    }

    public static String random(int n, int n2, int n3, boolean bl, boolean bl2) {
        return RandomStringUtils.random(n, n2, n3, bl, bl2, null, RANDOM);
    }

    public static String random(int n, int n2, int n3, boolean bl, boolean bl2, char ... cArray) {
        return RandomStringUtils.random(n, n2, n3, bl, bl2, cArray, RANDOM);
    }

    public static String random(int n, int n2, int n3, boolean bl, boolean bl2, char[] cArray, Random random) {
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw new IllegalArgumentException("Requested random string length " + n + " is less than 0.");
        }
        if (cArray != null && cArray.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (n2 == 0 && n3 == 0) {
            if (cArray != null) {
                n3 = cArray.length;
            } else if (!bl && !bl2) {
                n3 = 0x10FFFF;
            } else {
                n3 = 123;
                n2 = 32;
            }
        } else if (n3 <= n2) {
            throw new IllegalArgumentException("Parameter end (" + n3 + ") must be greater than start (" + n2 + ")");
        }
        int n4 = 48;
        int n5 = 65;
        if (cArray == null && (bl2 && n3 <= 48 || bl && n3 <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + n3 + ") must be greater then (" + 48 + ") for generating digits or greater then (" + 65 + ") for generating letters.");
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n6 = n3 - n2;
        block3: while (n-- != 0) {
            int n7;
            if (cArray == null) {
                n7 = random.nextInt(n6) + n2;
                switch (Character.getType(n7)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++n;
                        continue block3;
                    }
                }
            } else {
                n7 = cArray[random.nextInt(n6) + n2];
            }
            int n8 = Character.charCount(n7);
            if (n == 0 && n8 > 1) {
                ++n;
                continue;
            }
            if (bl && Character.isLetter(n7) || bl2 && Character.isDigit(n7) || !bl && !bl2) {
                stringBuilder.appendCodePoint(n7);
                if (n8 != 2) continue;
                --n;
                continue;
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String random(int n, String string) {
        if (string == null) {
            return RandomStringUtils.random(n, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n, string.toCharArray());
    }

    public static String random(int n, char ... cArray) {
        if (cArray == null) {
            return RandomStringUtils.random(n, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n, 0, cArray.length, false, false, cArray, RANDOM);
    }
}

