/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.lang3.tuple;

import com.hm.apache.commons.lang3.tuple.Pair;
import java.util.Map;

public final class ImmutablePair<L, R>
extends Pair<L, R> {
    public static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair NULL = ImmutablePair.of(null, null);
    private static final long serialVersionUID = 4954918890077093841L;
    public final L left;
    public final R right;

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> Pair<L, R> left(L l) {
        return ImmutablePair.of(l, null);
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    public static <L, R> ImmutablePair<L, R> of(L l, R r) {
        return new ImmutablePair<L, R>(l, r);
    }

    public static <L, R> ImmutablePair<L, R> of(Map.Entry<L, R> entry) {
        R r;
        L l;
        if (entry != null) {
            l = entry.getKey();
            r = entry.getValue();
        } else {
            l = null;
            r = null;
        }
        return new ImmutablePair<Object, Object>(l, r);
    }

    public static <L, R> Pair<L, R> right(R r) {
        return ImmutablePair.of(null, r);
    }

    public ImmutablePair(L l, R r) {
        this.left = l;
        this.right = r;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R r) {
        throw new UnsupportedOperationException();
    }
}

