/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text.translate;

import com.hm.apache.commons.lang3.Range;
import com.hm.apache.commons.text.translate.CodePointTranslator;
import java.io.Writer;

public class NumericEntityEscaper
extends CodePointTranslator {
    private final boolean between;
    private final Range<Integer> range;

    private NumericEntityEscaper(int n, int n2, boolean bl) {
        this.range = Range.between(n, n2);
        this.between = bl;
    }

    public NumericEntityEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    public static NumericEntityEscaper below(int n) {
        return NumericEntityEscaper.outsideOf(n, Integer.MAX_VALUE);
    }

    public static NumericEntityEscaper above(int n) {
        return NumericEntityEscaper.outsideOf(0, n);
    }

    public static NumericEntityEscaper between(int n, int n2) {
        return new NumericEntityEscaper(n, n2, true);
    }

    public static NumericEntityEscaper outsideOf(int n, int n2) {
        return new NumericEntityEscaper(n, n2, false);
    }

    @Override
    public boolean translate(int n, Writer writer) {
        if (this.between != this.range.contains(n)) {
            return false;
        }
        writer.write("&#");
        writer.write(Integer.toString(n, 10));
        writer.write(59);
        return true;
    }
}

