/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command.ddl;

import com.hm.h2.command.ddl.AlterTableAddConstraint;
import com.hm.h2.command.ddl.CreateIndex;
import com.hm.h2.command.ddl.DefineCommand;
import com.hm.h2.command.ddl.SchemaCommand;
import com.hm.h2.engine.Session;
import com.hm.h2.message.DbException;
import com.hm.h2.schema.Schema;
import com.hm.h2.schema.Sequence;
import com.hm.h2.table.Column;
import com.hm.h2.table.IndexColumn;
import java.util.ArrayList;

public abstract class CommandWithColumns
extends SchemaCommand {
    private ArrayList<DefineCommand> constraintCommands;
    private AlterTableAddConstraint primaryKey;

    protected CommandWithColumns(Session session, Schema schema) {
        super(session, schema);
    }

    public abstract void addColumn(Column var1);

    public void addConstraintCommand(DefineCommand defineCommand) {
        AlterTableAddConstraint alterTableAddConstraint;
        if (!(defineCommand instanceof CreateIndex) && (alterTableAddConstraint = (AlterTableAddConstraint)defineCommand).getType() == 6 && this.setPrimaryKey(alterTableAddConstraint)) {
            return;
        }
        this.getConstraintCommands().add(defineCommand);
    }

    protected void changePrimaryKeysToNotNull(ArrayList<Column> arrayList) {
        if (this.primaryKey != null) {
            IndexColumn[] indexColumnArray = this.primaryKey.getIndexColumns();
            for (Column column : arrayList) {
                for (IndexColumn indexColumn : indexColumnArray) {
                    if (!column.getName().equals(indexColumn.columnName)) continue;
                    column.setNullable(false);
                }
            }
        }
    }

    protected void createConstraints() {
        if (this.constraintCommands != null) {
            for (DefineCommand defineCommand : this.constraintCommands) {
                defineCommand.setTransactional(this.transactional);
                defineCommand.update();
            }
        }
    }

    protected ArrayList<Sequence> generateSequences(ArrayList<Column> arrayList, boolean bl) {
        ArrayList<Sequence> arrayList2 = new ArrayList<Sequence>(arrayList == null ? 0 : arrayList.size());
        if (arrayList != null) {
            for (Column column : arrayList) {
                Sequence sequence;
                if (column.isAutoIncrement()) {
                    int n = this.session.getDatabase().allocateObjectId();
                    column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, bl);
                    if (!"''".equals(this.session.getDatabase().getCluster())) {
                        throw DbException.getUnsupportedException("CLUSTERING && auto-increment columns");
                    }
                }
                if ((sequence = column.getSequence()) == null) continue;
                arrayList2.add(sequence);
            }
        }
        return arrayList2;
    }

    private ArrayList<DefineCommand> getConstraintCommands() {
        if (this.constraintCommands == null) {
            this.constraintCommands = new ArrayList();
        }
        return this.constraintCommands;
    }

    private boolean setPrimaryKey(AlterTableAddConstraint alterTableAddConstraint) {
        if (this.primaryKey != null) {
            IndexColumn[] indexColumnArray = this.primaryKey.getIndexColumns();
            IndexColumn[] indexColumnArray2 = alterTableAddConstraint.getIndexColumns();
            int n = indexColumnArray2.length;
            if (n != indexColumnArray.length) {
                throw DbException.get(90017);
            }
            for (int i = 0; i < n; ++i) {
                if (indexColumnArray2[i].columnName.equals(indexColumnArray[i].columnName)) continue;
                throw DbException.get(90017);
            }
            if (this.primaryKey.getConstraintName() != null) {
                return true;
            }
            this.constraintCommands.remove(this.primaryKey);
        }
        this.primaryKey = alterTableAddConstraint;
        return false;
    }

    public AlterTableAddConstraint getPrimaryKey() {
        return this.primaryKey;
    }
}

