/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command.ddl;

import com.hm.h2.command.ddl.SchemaCommand;
import com.hm.h2.engine.Database;
import com.hm.h2.engine.FunctionAlias;
import com.hm.h2.engine.Session;
import com.hm.h2.message.DbException;
import com.hm.h2.schema.Schema;
import com.hm.h2.util.StringUtils;

public class CreateFunctionAlias
extends SchemaCommand {
    private String aliasName;
    private String javaClassMethod;
    private boolean deterministic;
    private boolean ifNotExists;
    private boolean force;
    private String source;

    public CreateFunctionAlias(Session session, Schema schema) {
        super(session, schema);
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.getSchema().findFunction(this.aliasName) != null) {
            if (!this.ifNotExists) {
                throw DbException.get(90076, this.aliasName);
            }
        } else {
            int n = this.getObjectId();
            FunctionAlias functionAlias = this.javaClassMethod != null ? FunctionAlias.newInstance(this.getSchema(), n, this.aliasName, this.javaClassMethod, this.force) : FunctionAlias.newInstanceFromSource(this.getSchema(), n, this.aliasName, this.source, this.force);
            functionAlias.setDeterministic(this.deterministic);
            database.addSchemaObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = StringUtils.replaceAll(string, " ", "");
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public void setSource(String string) {
        this.source = string;
    }

    @Override
    public int getType() {
        return 24;
    }
}

