/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command.ddl;

import com.hm.h2.command.ddl.SchemaCommand;
import com.hm.h2.constraint.ConstraintActionType;
import com.hm.h2.engine.DbObject;
import com.hm.h2.engine.Session;
import com.hm.h2.message.DbException;
import com.hm.h2.schema.Schema;
import com.hm.h2.table.Table;
import com.hm.h2.table.TableType;
import com.hm.h2.table.TableView;
import java.util.ArrayList;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropView(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (TableType.VIEW != table.getTableType()) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkRight(table, 15);
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                for (DbObject object2 : table.getChildren()) {
                    if (!(object2 instanceof TableView)) continue;
                    throw DbException.get(90107, this.viewName, object2.getName());
                }
            }
            TableView tableView = (TableView)table;
            ArrayList<Table> arrayList = new ArrayList<Table>(tableView.getTables());
            table.lock(this.session, true, true);
            this.session.getDatabase().removeSchemaObject(this.session, table);
            for (Table table2 : arrayList) {
                TableView tableView2;
                if (TableType.VIEW != table2.getTableType() || !(tableView2 = (TableView)table2).isTableExpression() || tableView2.getName() == null) continue;
                this.session.getDatabase().removeSchemaObject(this.session, tableView2);
            }
            this.session.getDatabase().unlockMeta(this.session);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 48;
    }
}

