/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression;

import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ExpressionVisitor;
import com.hm.h2.expression.ValueExpression;
import com.hm.h2.message.DbException;
import com.hm.h2.table.ColumnResolver;
import com.hm.h2.table.TableFilter;
import com.hm.h2.util.DateTimeUtils;
import com.hm.h2.util.TimeZoneProvider;
import com.hm.h2.value.DataType;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueInterval;
import com.hm.h2.value.ValueNull;
import com.hm.h2.value.ValueTimeTimeZone;
import com.hm.h2.value.ValueTimestampTimeZone;

public class TimeZoneOperation
extends Expression {
    private Expression arg;
    private Expression timeZone;
    private TypeInfo type;

    public TimeZoneOperation(Expression expression) {
        this.arg = expression;
    }

    public TimeZoneOperation(Expression expression, Expression expression2) {
        this.arg = expression;
        this.timeZone = expression2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        this.arg.getSQL(stringBuilder.append('('), bl).append(" AT ");
        if (this.timeZone != null) {
            this.timeZone.getSQL(stringBuilder.append("TIME ZONE "), bl);
        } else {
            stringBuilder.append("LOCAL");
        }
        return stringBuilder.append(')');
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.arg.getValue(session).convertTo(this.type, session, false, null);
        int n = value.getValueType();
        if ((n == 24 || n == 41) && this.timeZone != null) {
            Value value2 = this.timeZone.getValue(session);
            if (value2 != ValueNull.INSTANCE) {
                if (n == 24) {
                    int n2;
                    ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                    long l = valueTimestampTimeZone.getDateValue();
                    long l2 = valueTimestampTimeZone.getTimeNanos();
                    int n3 = valueTimestampTimeZone.getTimeZoneOffsetSeconds();
                    if (n3 != (n2 = TimeZoneOperation.parseTimeZone(value2, l, l2, n3, true))) {
                        if ((l2 += (long)(n2 - n3) * 1000000000L) < 0L) {
                            l = DateTimeUtils.decrementDateValue(l);
                            if ((l2 += 86400000000000L) < 0L) {
                                l2 += 86400000000000L;
                                l = DateTimeUtils.decrementDateValue(l);
                            }
                        } else if (l2 >= 86400000000000L) {
                            l = DateTimeUtils.incrementDateValue(l);
                            if ((l2 -= 86400000000000L) >= 86400000000000L) {
                                l2 -= 86400000000000L;
                                l = DateTimeUtils.incrementDateValue(l);
                            }
                        }
                        value = ValueTimestampTimeZone.fromDateValueAndNanos(l, l2, n2);
                    }
                } else {
                    int n4;
                    ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
                    long l = valueTimeTimeZone.getNanos();
                    int n5 = valueTimeTimeZone.getTimeZoneOffsetSeconds();
                    if (n5 != (n4 = TimeZoneOperation.parseTimeZone(value2, 1008673L, l, n5, false))) {
                        value = ValueTimeTimeZone.fromNanos(DateTimeUtils.normalizeNanosOfDay(l += (long)(n4 - n5) * 1000000000L), n4);
                    }
                }
            } else {
                value = ValueNull.INSTANCE;
            }
        }
        return value;
    }

    private static int parseTimeZone(Value value, long l, long l2, int n, boolean bl) {
        int n2 = value.getValueType();
        if (DataType.isStringType(n2)) {
            char c;
            String string = value.getString();
            if (string.equals("Z") || string.equals("UTC") || string.equals("GMT")) {
                return 0;
            }
            if (!(string.isEmpty() || (c = string.charAt(0)) == '+' || c == '-' || c >= '0' && c <= '9')) {
                TimeZoneProvider timeZoneProvider;
                try {
                    timeZoneProvider = TimeZoneProvider.ofId(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DbException.getInvalidValueException("time zone", value.getSQL());
                }
                if (!bl && !timeZoneProvider.hasFixedOffset()) {
                    throw DbException.getInvalidValueException("time zone", value.getSQL());
                }
                return timeZoneProvider.getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(l, l2, n));
            }
        }
        return TimeZoneOperation.parseInterval(value);
    }

    private static int parseInterval(Value value) {
        ValueInterval valueInterval = (ValueInterval)value.convertTo(37);
        long l = valueInterval.getLeading();
        long l2 = valueInterval.getRemaining();
        if (l > 18L || l == 18L && l2 != 0L || l2 % 1000000000L != 0L) {
            throw DbException.getInvalidValueException("time zone", valueInterval.getSQL());
        }
        int n = (int)(l * 3600L + l2 / 1000000000L);
        if (valueInterval.isNegative()) {
            n = -n;
        }
        return n;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.arg.mapColumns(columnResolver, n, n2);
        if (this.timeZone != null) {
            this.timeZone.mapColumns(columnResolver, n, n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.arg = this.arg.optimize(session);
        if (this.timeZone != null) {
            this.timeZone = this.timeZone.optimize(session);
        }
        TypeInfo typeInfo = this.arg.getType();
        int n = 24;
        int n2 = 9;
        switch (typeInfo.getValueType()) {
            case 11: 
            case 24: {
                n2 = typeInfo.getScale();
                break;
            }
            case 9: 
            case 41: {
                n = 41;
                n2 = typeInfo.getScale();
                break;
            }
            default: {
                StringBuilder stringBuilder = this.arg.getSQL(new StringBuilder(), false);
                int n3 = stringBuilder.length();
                stringBuilder.append(" AT ");
                if (this.timeZone != null) {
                    this.timeZone.getSQL(stringBuilder.append("TIME ZONE "), false);
                } else {
                    stringBuilder.append("LOCAL");
                }
                throw DbException.getSyntaxError(stringBuilder.toString(), n3, "time, timestamp");
            }
        }
        this.type = TypeInfo.getTypeInfo(n, -1L, n2, null);
        if (this.arg.isConstant() && (this.timeZone == null || this.timeZone.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.arg.setEvaluatable(tableFilter, bl);
        if (this.timeZone != null) {
            this.timeZone.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.arg.updateAggregate(session, n);
        if (this.timeZone != null) {
            this.timeZone.updateAggregate(session, n);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.arg.isEverything(expressionVisitor) && (this.timeZone == null || this.timeZone.isEverything(expressionVisitor));
    }

    @Override
    public int getCost() {
        int n = this.arg.getCost() + 1;
        if (this.timeZone != null) {
            n += this.timeZone.getCost();
        }
        return n;
    }

    @Override
    public int getSubexpressionCount() {
        return this.timeZone != null ? 2 : 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.arg;
        }
        if (n == 1 && this.timeZone != null) {
            return this.timeZone;
        }
        throw new IndexOutOfBoundsException();
    }
}

