/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression;

import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ExpressionColumn;
import com.hm.h2.expression.ExpressionVisitor;
import com.hm.h2.message.DbException;
import com.hm.h2.table.Column;
import com.hm.h2.table.ColumnResolver;
import com.hm.h2.table.TableFilter;
import com.hm.h2.util.StringUtils;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import java.util.ArrayList;
import java.util.HashMap;

public class Wildcard
extends Expression {
    private final String schema;
    private final String table;
    private ArrayList<ExpressionColumn> exceptColumns;

    public Wildcard(String string, String string2) {
        this.schema = string;
        this.table = string2;
    }

    public ArrayList<ExpressionColumn> getExceptColumns() {
        return this.exceptColumns;
    }

    public void setExceptColumns(ArrayList<ExpressionColumn> arrayList) {
        this.exceptColumns = arrayList;
    }

    public HashMap<Column, ExpressionColumn> mapExceptColumns() {
        HashMap<Column, ExpressionColumn> hashMap = new HashMap<Column, ExpressionColumn>();
        for (ExpressionColumn expressionColumn : this.exceptColumns) {
            Column column = expressionColumn.getColumn();
            if (column == null) {
                throw expressionColumn.getColumnException(42122);
            }
            if (hashMap.put(column, expressionColumn) == null) continue;
            throw expressionColumn.getColumnException(42121);
        }
        return hashMap;
    }

    @Override
    public Value getValue(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public TypeInfo getType() {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        if (this.exceptColumns != null) {
            for (ExpressionColumn expressionColumn : this.exceptColumns) {
                expressionColumn.mapColumns(columnResolver, n, n2);
            }
        }
    }

    @Override
    public Expression optimize(Session session) {
        throw DbException.get(42000, this.table);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public String getTableAlias() {
        return this.table;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.table != null) {
            StringUtils.quoteIdentifier(stringBuilder, this.table).append('.');
        }
        stringBuilder.append('*');
        if (this.exceptColumns != null) {
            stringBuilder.append(" EXCEPT (");
            Wildcard.writeExpressions(stringBuilder, this.exceptColumns, bl);
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 8) {
            return true;
        }
        throw DbException.throwInternalError(Integer.toString(expressionVisitor.getType()));
    }

    @Override
    public int getCost() {
        throw DbException.throwInternalError(this.toString());
    }
}

