/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression.analysis;

import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.analysis.WindowFrameBoundType;
import com.hm.h2.table.ColumnResolver;

public class WindowFrameBound {
    private final WindowFrameBoundType type;
    private Expression value;
    private boolean isVariable;
    private int expressionIndex = -1;

    public WindowFrameBound(WindowFrameBoundType windowFrameBoundType, Expression expression) {
        this.type = windowFrameBoundType;
        this.value = windowFrameBoundType == WindowFrameBoundType.PRECEDING || windowFrameBoundType == WindowFrameBoundType.FOLLOWING ? expression : null;
    }

    public WindowFrameBoundType getType() {
        return this.type;
    }

    public Expression getValue() {
        return this.value;
    }

    public boolean isParameterized() {
        return this.type == WindowFrameBoundType.PRECEDING || this.type == WindowFrameBoundType.FOLLOWING;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    public int getExpressionIndex() {
        return this.expressionIndex;
    }

    void setExpressionIndex(int n) {
        this.expressionIndex = n;
    }

    void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        if (this.value != null) {
            this.value.mapColumns(columnResolver, n, n2);
        }
    }

    void optimize(Session session) {
        if (this.value != null) {
            this.value = this.value.optimize(session);
            if (!this.value.isConstant()) {
                this.isVariable = true;
            }
        }
    }

    void updateAggregate(Session session, int n) {
        if (this.value != null) {
            this.value.updateAggregate(session, n);
        }
    }

    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        if (this.type == WindowFrameBoundType.PRECEDING || this.type == WindowFrameBoundType.FOLLOWING) {
            this.value.getSQL(stringBuilder, bl2).append(' ');
        }
        return stringBuilder.append(this.type.getSQL());
    }
}

