/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression.condition;

import com.hm.h2.command.dml.Query;
import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ValueExpression;
import com.hm.h2.expression.condition.PredicateWithSubquery;
import com.hm.h2.result.LocalResult;
import com.hm.h2.result.ResultTarget;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueBoolean;
import com.hm.h2.value.ValueNull;
import java.util.Arrays;

public class UniquePredicate
extends PredicateWithSubquery {
    public UniquePredicate(Query query) {
        super(query);
    }

    @Override
    public Expression optimize(Session session) {
        super.optimize(session);
        if (this.query.isStandardDistinct()) {
            return ValueExpression.getBoolean(true);
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        int n = this.query.getColumnCount();
        LocalResult localResult = session.getDatabase().getResultFactory().create(session, this.query.getExpressions().toArray(new Expression[0]), n, n);
        localResult.setDistinct();
        Target target = new Target(n, localResult);
        this.query.query(Integer.MAX_VALUE, target);
        localResult.close();
        return ValueBoolean.get(!target.hasDuplicates);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return super.getSQL(stringBuilder.append("UNIQUE"), bl);
    }

    private final class Target
    implements ResultTarget {
        private final int columnCount;
        private final LocalResult result;
        boolean hasDuplicates;

        Target(int n, LocalResult localResult) {
            this.columnCount = n;
            this.result = localResult;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public void addRow(Value ... valueArray) {
            int n;
            if (this.hasDuplicates) {
                return;
            }
            for (n = 0; n < this.columnCount; ++n) {
                if (valueArray[n] != ValueNull.INSTANCE) continue;
                return;
            }
            if (valueArray.length != this.columnCount) {
                valueArray = Arrays.copyOf(valueArray, this.columnCount);
            }
            n = this.result.getRowCount() + 1;
            this.result.addRow(valueArray);
            if (n != this.result.getRowCount()) {
                this.hasDuplicates = true;
                this.result.close();
            }
        }
    }
}

