/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.index;

import com.hm.h2.command.dml.AllColumnsForPlan;
import com.hm.h2.engine.Session;
import com.hm.h2.index.Cursor;
import com.hm.h2.index.RangeCursor;
import com.hm.h2.index.VirtualTableIndex;
import com.hm.h2.message.DbException;
import com.hm.h2.result.SearchRow;
import com.hm.h2.result.SortOrder;
import com.hm.h2.table.IndexColumn;
import com.hm.h2.table.RangeTable;
import com.hm.h2.table.TableFilter;

public class RangeIndex
extends VirtualTableIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        super(rangeTable, "RANGE_INDEX", indexColumnArray);
        this.rangeTable = rangeTable;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = this.rangeTable.getMin(session);
        long l3 = this.rangeTable.getMax(session);
        long l4 = this.rangeTable.getStep(session);
        if (searchRow != null) {
            try {
                l = searchRow.getValue(0).getLong();
                if (l4 > 0L) {
                    if (l > l2) {
                        l2 += (l - l2 + l4 - 1L) / l4 * l4;
                    }
                } else if (l > l3) {
                    l3 = l;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        if (searchRow2 != null) {
            try {
                l = searchRow2.getValue(0).getLong();
                if (l4 > 0L) {
                    if (l < l3) {
                        l3 = l;
                    }
                } else if (l < l2) {
                    l2 -= (l2 - l - l4 - 1L) / l4 * l4;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return new RangeCursor(session, l2, l3, l4);
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        long l = bl ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(session, l, l);
    }

    @Override
    public String getPlanSQL() {
        return "range index";
    }
}

