/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.index;

import com.hm.h2.command.dml.AllColumnsForPlan;
import com.hm.h2.engine.Session;
import com.hm.h2.index.Cursor;
import com.hm.h2.index.VirtualTableCursor;
import com.hm.h2.index.VirtualTableIndex;
import com.hm.h2.message.DbException;
import com.hm.h2.result.SearchRow;
import com.hm.h2.result.SortOrder;
import com.hm.h2.table.FunctionTable;
import com.hm.h2.table.IndexColumn;
import com.hm.h2.table.TableFilter;
import com.hm.h2.table.VirtualConstructedTable;

public class VirtualConstructedTableIndex
extends VirtualTableIndex {
    private final VirtualConstructedTable table;

    public VirtualConstructedTableIndex(VirtualConstructedTable virtualConstructedTable, IndexColumn[] indexColumnArray) {
        super(virtualConstructedTable, null, indexColumnArray);
        this.table = virtualConstructedTable;
    }

    @Override
    public boolean isFindUsingFullTableScan() {
        return true;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return new VirtualTableCursor(this, searchRow, searchRow2, session, this.table.getResult(session));
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        if (nArray != null) {
            throw DbException.getUnsupportedException("Virtual table");
        }
        long l = this.table.canGetRowCount() ? this.table.getRowCountApproximation() : (long)this.database.getSettings().estimatedFunctionTableRows;
        return l * 10L;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public String getPlanSQL() {
        return this.table instanceof FunctionTable ? "function" : "table scan";
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

