/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.mvstore.db;

import com.hm.h2.engine.Database;
import com.hm.h2.expression.Expression;
import com.hm.h2.message.DbException;
import com.hm.h2.mvstore.Cursor;
import com.hm.h2.mvstore.MVMap;
import com.hm.h2.mvstore.db.MVTempResult;
import com.hm.h2.mvstore.db.ValueDataType;
import com.hm.h2.result.ResultExternal;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueRow;

class MVPlainTempResult
extends MVTempResult {
    private final MVMap<Long, ValueRow> map;
    private long counter;
    private Cursor<Long, ValueRow> cursor;

    private MVPlainTempResult(MVPlainTempResult mVPlainTempResult) {
        super(mVPlainTempResult);
        this.map = mVPlainTempResult.map;
    }

    MVPlainTempResult(Database database, Expression[] expressionArray, int n, int n2) {
        super(database, expressionArray, n, n2);
        ValueDataType valueDataType = new ValueDataType(database, new int[n2]);
        MVMap.Builder builder = ((MVMap.Builder)new MVMap.Builder().valueType(valueDataType)).singleWriter();
        this.map = this.store.openMap("tmp", builder);
    }

    @Override
    public int addRow(Value[] valueArray) {
        assert (this.parent == null);
        this.map.append(this.counter++, ValueRow.get(valueArray));
        return ++this.rowCount;
    }

    @Override
    public boolean contains(Value[] valueArray) {
        throw DbException.getUnsupportedException("contains()");
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new MVPlainTempResult(this);
    }

    @Override
    public Value[] next() {
        if (this.cursor == null) {
            this.cursor = this.map.cursor(null);
        }
        if (!this.cursor.hasNext()) {
            return null;
        }
        this.cursor.next();
        Value[] valueArray = this.cursor.getValue().getList();
        if (this.hasEnum) {
            this.fixEnum(valueArray);
        }
        return valueArray;
    }

    @Override
    public int removeRow(Value[] valueArray) {
        throw DbException.getUnsupportedException("removeRow()");
    }

    @Override
    public void reset() {
        this.cursor = null;
    }
}

