/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.mvstore.rtree;

import com.hm.h2.mvstore.CursorPos;
import com.hm.h2.mvstore.DataUtils;
import com.hm.h2.mvstore.MVMap;
import com.hm.h2.mvstore.Page;
import com.hm.h2.mvstore.RootReference;
import com.hm.h2.mvstore.rtree.SpatialDataType;
import com.hm.h2.mvstore.rtree.SpatialKey;
import com.hm.h2.mvstore.type.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class MVRTreeMap<V>
extends MVMap<SpatialKey, V> {
    final SpatialDataType keyType;
    private boolean quadraticSplit;

    public MVRTreeMap(Map<String, Object> map) {
        super(map);
        this.keyType = (SpatialDataType)map.get("key");
        this.quadraticSplit = Boolean.valueOf(String.valueOf(map.get("quadraticSplit")));
    }

    private MVRTreeMap(MVRTreeMap<V> mVRTreeMap) {
        super(mVRTreeMap);
        this.keyType = mVRTreeMap.keyType;
        this.quadraticSplit = mVRTreeMap.quadraticSplit;
    }

    public MVRTreeMap<V> cloneIt() {
        return new MVRTreeMap<V>(this);
    }

    public RTreeCursor findIntersectingKeys(SpatialKey spatialKey) {
        return new RTreeCursor(this.getRootPage(), spatialKey){

            @Override
            protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
                return MVRTreeMap.this.keyType.isOverlap(spatialKey, spatialKey2);
            }
        };
    }

    public RTreeCursor findContainedKeys(SpatialKey spatialKey) {
        return new RTreeCursor(this.getRootPage(), spatialKey){

            @Override
            protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
                if (bl) {
                    return MVRTreeMap.this.keyType.isInside(spatialKey, spatialKey2);
                }
                return MVRTreeMap.this.keyType.isOverlap(spatialKey, spatialKey2);
            }
        };
    }

    private boolean contains(Page page, int n, Object object) {
        return this.keyType.contains(page.getKey(n), object);
    }

    @Override
    public V get(Page page, Object object) {
        int n = page.getKeyCount();
        if (!page.isLeaf()) {
            for (int i = 0; i < n; ++i) {
                V v;
                if (!this.contains(page, i, object) || (v = this.get(page.getChildPage(i), object)) == null) continue;
                return v;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!this.keyType.equals(page.getKey(i), object)) continue;
                return (V)page.getValue(i);
            }
        }
        return null;
    }

    @Override
    public V remove(Object object) {
        return (V)this.operate((SpatialKey)object, (V)null, (MVMap.DecisionMaker<? super V>)MVMap.DecisionMaker.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V operate(SpatialKey spatialKey, V v, MVMap.DecisionMaker<? super V> decisionMaker) {
        int n = 0;
        ArrayList<Page> arrayList = this.isPersistent() ? new ArrayList<Page>() : null;
        while (true) {
            RootReference rootReference = this.flushAndGetRoot();
            if (n++ == 0 && !rootReference.isLockedByCurrentThread()) {
                this.beforeWrite();
            }
            Page page = rootReference.root;
            if (arrayList != null && page.getTotalCount() > 0L) {
                arrayList.add(page);
            }
            page = page.copy();
            V v2 = this.operate(page, spatialKey, v, decisionMaker, arrayList);
            if (!page.isLeaf() && page.getTotalCount() == 0L) {
                if (arrayList != null) {
                    arrayList.add(page);
                }
                page = this.createEmptyLeaf();
            } else if (page.getKeyCount() > this.store.getKeysPerPage() || (long)page.getMemory() > this.store.getMaxPageSize() && page.getKeyCount() > 3) {
                long l = page.getTotalCount();
                Page page2 = this.split(page);
                Object object = this.getBounds(page);
                Iterator iterator = this.getBounds(page2);
                Object[] object2 = new Object[]{object, iterator};
                Page.PageReference[] pageReferenceArray = new Page.PageReference[]{new Page.PageReference(page), new Page.PageReference(page2), Page.PageReference.EMPTY};
                page = Page.createNode(this, object2, pageReferenceArray, l, 0);
                if (this.isPersistent()) {
                    this.store.registerUnsavedMemory(page.getMemory());
                }
            }
            if (arrayList == null) {
                if (MVRTreeMap.updateRoot(rootReference, page, n)) {
                    return v2;
                }
            } else {
                RootReference rootReference2 = this.tryLock(rootReference, n);
                if (rootReference2 != null) {
                    try {
                        long l = rootReference2.version;
                        int n2 = 0;
                        for (Page page2 : arrayList) {
                            if (page2.isRemoved()) continue;
                            n2 += page2.removePage(l);
                        }
                        this.store.registerUnsavedMemory(n2);
                    }
                    finally {
                        this.unlockRoot(page);
                    }
                    return v2;
                }
                arrayList.clear();
            }
            decisionMaker.reset();
        }
    }

    private V operate(Page page, Object object, V object2, MVMap.DecisionMaker<? super V> decisionMaker, Collection<Page> collection) {
        Object object3 = null;
        if (page.isLeaf()) {
            int n = -1;
            int n2 = page.getKeyCount();
            for (int i = 0; i < n2; ++i) {
                if (!this.keyType.equals(page.getKey(i), object)) continue;
                n = i;
            }
            object3 = n < 0 ? null : page.getValue(n);
            MVMap.Decision decision = decisionMaker.decide(object3, object2);
            switch (decision) {
                case REPEAT: {
                    break;
                }
                case ABORT: {
                    break;
                }
                case REMOVE: {
                    if (n < 0) break;
                    page.remove(n);
                    break;
                }
                case PUT: {
                    object2 = decisionMaker.selectValue(object3, object2);
                    if (n < 0) {
                        page.insertLeaf(page.getKeyCount(), object, object2);
                        break;
                    }
                    page.setKey(n, object);
                    page.setValue(n, object2);
                }
            }
            return (V)object3;
        }
        if (object2 == null) {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                if (!this.contains(page, i, object)) continue;
                Page page2 = page.getChildPage(i);
                if (collection != null) {
                    collection.add(page2);
                }
                Page page3 = page2.copy();
                long l = page3.getTotalCount();
                object3 = this.operate(page3, object, object2, decisionMaker, collection);
                page.setChild(i, page3);
                if (l == page3.getTotalCount()) {
                    decisionMaker.reset();
                    continue;
                }
                if (page3.getTotalCount() == 0L) {
                    page.remove(i);
                    if (collection != null) {
                        collection.add(page);
                    }
                } else {
                    Object object4 = page.getKey(i);
                    if (!this.keyType.isInside(object, object4)) {
                        page.setKey(i, this.getBounds(page3));
                    }
                }
                break;
            }
        } else {
            int n = -1;
            for (int i = 0; i < page.getKeyCount(); ++i) {
                if (!this.contains(page, i, object)) continue;
                Page page4 = page.getChildPage(i);
                if (this.get(page4, object) != null) {
                    n = i;
                    break;
                }
                if (n >= 0) continue;
                n = i;
            }
            if (n < 0) {
                float f = Float.MAX_VALUE;
                for (int i = 0; i < page.getKeyCount(); ++i) {
                    Object object5 = page.getKey(i);
                    float f2 = this.keyType.getAreaIncrease(object5, object);
                    if (!(f2 < f)) continue;
                    n = i;
                    f = f2;
                }
            }
            Page page5 = page.getChildPage(n);
            if (collection != null) {
                collection.add(page5);
            }
            if ((page5 = page5.copy()).getKeyCount() > this.store.getKeysPerPage() || (long)page5.getMemory() > this.store.getMaxPageSize() && page5.getKeyCount() > 4) {
                Page page6 = this.split(page5);
                page.setKey(n, this.getBounds(page5));
                page.setChild(n, page5);
                page.insertNode(n, this.getBounds(page6), page6);
                object3 = this.operate(page, object, object2, decisionMaker, collection);
            } else {
                object3 = this.operate(page5, object, object2, decisionMaker, collection);
                Object object6 = page.getKey(n);
                if (!this.keyType.contains(object6, object)) {
                    object6 = this.keyType.createBoundingBox(object6);
                    this.keyType.increaseBounds(object6, object);
                    page.setKey(n, object6);
                }
                page.setChild(n, page5);
            }
        }
        return (V)object3;
    }

    private Object getBounds(Page page) {
        Object object = this.keyType.createBoundingBox(page.getKey(0));
        int n = page.getKeyCount();
        for (int i = 1; i < n; ++i) {
            this.keyType.increaseBounds(object, page.getKey(i));
        }
        return object;
    }

    @Override
    public V put(SpatialKey spatialKey, V v) {
        return (V)this.operate(spatialKey, v, MVMap.DecisionMaker.PUT);
    }

    public void add(SpatialKey spatialKey, V v) {
        this.operate(spatialKey, v, MVMap.DecisionMaker.PUT);
    }

    private Page split(Page page) {
        return this.quadraticSplit ? this.splitQuadratic(page) : this.splitLinear(page);
    }

    private Page splitLinear(Page page) {
        int n = page.getKeyCount();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(page.getKey(i));
        }
        int[] nArray = this.keyType.getExtremes(arrayList);
        if (nArray == null) {
            return this.splitQuadratic(page);
        }
        Page page2 = this.newPage(page.isLeaf());
        Page page3 = this.newPage(page.isLeaf());
        MVRTreeMap.move(page, page2, nArray[0]);
        if (nArray[1] > nArray[0]) {
            nArray[1] = nArray[1] - 1;
        }
        MVRTreeMap.move(page, page3, nArray[1]);
        Object object = this.keyType.createBoundingBox(page2.getKey(0));
        Object object2 = this.keyType.createBoundingBox(page3.getKey(0));
        while (page.getKeyCount() > 0) {
            float f;
            Object object3 = page.getKey(0);
            float f2 = this.keyType.getAreaIncrease(object, object3);
            if (f2 < (f = this.keyType.getAreaIncrease(object2, object3))) {
                this.keyType.increaseBounds(object, object3);
                MVRTreeMap.move(page, page2, 0);
                continue;
            }
            this.keyType.increaseBounds(object2, object3);
            MVRTreeMap.move(page, page3, 0);
        }
        while (page3.getKeyCount() > 0) {
            MVRTreeMap.move(page3, page, 0);
        }
        return page2;
    }

    private Page splitQuadratic(Page page) {
        float f;
        Object object;
        Page page2 = this.newPage(page.isLeaf());
        Page page3 = this.newPage(page.isLeaf());
        float f2 = Float.MIN_VALUE;
        int n = 0;
        int n2 = 0;
        int n3 = page.getKeyCount();
        for (int i = 0; i < n3; ++i) {
            object = page.getKey(i);
            for (int j = 0; j < n3; ++j) {
                Object object2;
                if (i == j || !((f = this.keyType.getCombinedArea(object, object2 = page.getKey(j))) > f2)) continue;
                f2 = f;
                n = i;
                n2 = j;
            }
        }
        MVRTreeMap.move(page, page2, n);
        if (n < n2) {
            --n2;
        }
        MVRTreeMap.move(page, page3, n2);
        Object object3 = this.keyType.createBoundingBox(page2.getKey(0));
        object = this.keyType.createBoundingBox(page3.getKey(0));
        while (page.getKeyCount() > 0) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            f = 0.0f;
            int n4 = 0;
            n3 = page.getKeyCount();
            for (int i = 0; i < n3; ++i) {
                float f5;
                Object object4 = page.getKey(i);
                float f6 = this.keyType.getAreaIncrease(object3, object4);
                float f7 = Math.abs(f6 - (f5 = this.keyType.getAreaIncrease(object, object4)));
                if (!(f7 > f3)) continue;
                f3 = f7;
                f4 = f6;
                f = f5;
                n4 = i;
            }
            if (f4 < f) {
                this.keyType.increaseBounds(object3, page.getKey(n4));
                MVRTreeMap.move(page, page2, n4);
                continue;
            }
            this.keyType.increaseBounds(object, page.getKey(n4));
            MVRTreeMap.move(page, page3, n4);
        }
        while (page3.getKeyCount() > 0) {
            MVRTreeMap.move(page3, page, 0);
        }
        return page2;
    }

    private Page newPage(boolean bl) {
        Page page;
        Page page2 = page = bl ? this.createEmptyLeaf() : this.createEmptyNode();
        if (this.isPersistent()) {
            this.store.registerUnsavedMemory(page.getMemory());
        }
        return page;
    }

    private static void move(Page page, Page page2, int n) {
        Object object = page.getKey(n);
        if (page.isLeaf()) {
            Object object2 = page.getValue(n);
            page2.insertLeaf(0, object, object2);
        } else {
            Page page3 = page.getChildPage(n);
            page2.insertNode(0, object, page3);
        }
        page.remove(n);
    }

    public void addNodeKeys(ArrayList<SpatialKey> arrayList, Page page) {
        if (page != null && !page.isLeaf()) {
            int n = page.getKeyCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add((SpatialKey)page.getKey(i));
                this.addNodeKeys(arrayList, page.getChildPage(i));
            }
        }
    }

    public boolean isQuadraticSplit() {
        return this.quadraticSplit;
    }

    public void setQuadraticSplit(boolean bl) {
        this.quadraticSplit = bl;
    }

    @Override
    protected int getChildPageCount(Page page) {
        return page.getRawChildPageCount() - 1;
    }

    @Override
    public String getType() {
        return "rtree";
    }

    public static class Builder<V>
    extends MVMap.BasicBuilder<MVRTreeMap<V>, SpatialKey, V> {
        private int dimensions = 2;

        public Builder() {
            this.setKeyType(new SpatialDataType(this.dimensions));
        }

        public Builder<V> dimensions(int n) {
            this.dimensions = n;
            this.setKeyType(new SpatialDataType(n));
            return this;
        }

        public Builder<V> valueType(DataType dataType) {
            this.setValueType(dataType);
            return this;
        }

        @Override
        public MVRTreeMap<V> create(Map<String, Object> map) {
            return new MVRTreeMap(map);
        }
    }

    public static class RTreeCursor
    implements Iterator<SpatialKey> {
        private final SpatialKey filter;
        private CursorPos pos;
        private SpatialKey current;
        private final Page root;
        private boolean initialized;

        protected RTreeCursor(Page page, SpatialKey spatialKey) {
            this.root = page;
            this.filter = spatialKey;
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.pos = new CursorPos(this.root, 0, null);
                this.fetchNext();
                this.initialized = true;
            }
            return this.current != null;
        }

        public void skip(long l) {
            while (this.hasNext() && l-- > 0L) {
                this.fetchNext();
            }
        }

        @Override
        public SpatialKey next() {
            if (!this.hasNext()) {
                return null;
            }
            SpatialKey spatialKey = this.current;
            this.fetchNext();
            return spatialKey;
        }

        @Override
        public void remove() {
            throw DataUtils.newUnsupportedOperationException("Removing is not supported");
        }

        protected void fetchNext() {
            while (this.pos != null) {
                Page page = this.pos.page;
                if (page.isLeaf()) {
                    while (this.pos.index < page.getKeyCount()) {
                        SpatialKey spatialKey = (SpatialKey)page.getKey(this.pos.index++);
                        if (this.filter != null && !this.check(true, spatialKey, this.filter)) continue;
                        this.current = spatialKey;
                        return;
                    }
                } else {
                    boolean bl = false;
                    while (this.pos.index < page.getKeyCount()) {
                        int n;
                        ++this.pos.index;
                        SpatialKey spatialKey = (SpatialKey)page.getKey(n);
                        if (this.filter != null && !this.check(false, spatialKey, this.filter)) continue;
                        Page page2 = this.pos.page.getChildPage(n);
                        this.pos = new CursorPos(page2, 0, this.pos);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                this.pos = this.pos.parent;
            }
            this.current = null;
        }

        protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
            return true;
        }
    }
}

