/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.mvstore.tx;

import com.hm.h2.mvstore.MVMap;
import com.hm.h2.mvstore.tx.Transaction;
import com.hm.h2.mvstore.tx.TransactionStore;
import com.hm.h2.mvstore.tx.VersionedValueCommitted;
import com.hm.h2.mvstore.tx.VersionedValueUncommitted;
import com.hm.h2.value.VersionedValue;

class TxDecisionMaker
extends MVMap.DecisionMaker<VersionedValue> {
    private final int mapId;
    private final Object key;
    private final Object value;
    private final Transaction transaction;
    private long undoKey;
    private long lastOperationId;
    private Transaction blockingTransaction;
    private MVMap.Decision decision;
    private Object lastCommittedValue;

    TxDecisionMaker(int n, Object object, Object object2, Transaction transaction) {
        this.mapId = n;
        this.key = object;
        this.value = object2;
        this.transaction = transaction;
    }

    @Override
    public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
        int n;
        long l;
        assert (this.decision == null);
        if (versionedValue == null || (l = versionedValue.getOperationId()) == 0L || this.isThisTransaction(n = TransactionStore.getTransactionId(l))) {
            this.logAndDecideToPut(versionedValue, versionedValue == null ? null : versionedValue.getCommittedValue());
        } else if (this.isCommitted(n)) {
            Object object = versionedValue.getCurrentValue();
            this.logAndDecideToPut(object == null ? null : VersionedValueCommitted.getInstance(object), object);
        } else if (this.getBlockingTransaction() != null) {
            this.decision = MVMap.Decision.ABORT;
        } else if (this.isRepeatedOperation(l)) {
            Object object = versionedValue.getCommittedValue();
            this.logAndDecideToPut(object == null ? null : VersionedValueCommitted.getInstance(object), object);
        } else {
            this.decision = MVMap.Decision.REPEAT;
        }
        return this.decision;
    }

    @Override
    public final void reset() {
        if (this.decision != MVMap.Decision.REPEAT) {
            this.lastOperationId = 0L;
            if (this.decision == MVMap.Decision.PUT) {
                this.transaction.logUndo();
            }
        }
        this.blockingTransaction = null;
        this.decision = null;
    }

    @Override
    public final VersionedValue selectValue(VersionedValue versionedValue, VersionedValue versionedValue2) {
        return VersionedValueUncommitted.getInstance(this.undoKey, this.getNewValue(versionedValue), this.lastCommittedValue);
    }

    Object getNewValue(VersionedValue versionedValue) {
        return this.value;
    }

    final MVMap.Decision logAndDecideToPut(VersionedValue versionedValue, Object object) {
        this.undoKey = this.transaction.log(this.mapId, this.key, versionedValue);
        this.lastCommittedValue = object;
        return this.setDecision(MVMap.Decision.PUT);
    }

    final MVMap.Decision getDecision() {
        return this.decision;
    }

    final Transaction getBlockingTransaction() {
        return this.blockingTransaction;
    }

    final boolean isThisTransaction(int n) {
        return n == this.transaction.transactionId;
    }

    final boolean isCommitted(int n) {
        boolean bl;
        Transaction transaction;
        TransactionStore transactionStore = this.transaction.store;
        do {
            transaction = transactionStore.getTransaction(n);
            bl = transactionStore.committingTransactions.get().get(n);
        } while (transaction != transactionStore.getTransaction(n));
        if (!bl) {
            this.blockingTransaction = transaction;
        }
        return bl;
    }

    final boolean isRepeatedOperation(long l) {
        if (l == this.lastOperationId) {
            return true;
        }
        this.lastOperationId = l;
        return false;
    }

    final MVMap.Decision setDecision(MVMap.Decision decision) {
        this.decision = decision;
        return this.decision;
    }

    public final String toString() {
        return "txdm " + this.transaction.transactionId;
    }

    public static final class LockDecisionMaker
    extends TxDecisionMaker {
        LockDecisionMaker(int n, Object object, Transaction transaction) {
            super(n, object, null, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
            MVMap.Decision decision = super.decide(versionedValue, versionedValue2);
            if (versionedValue == null) {
                assert (decision == MVMap.Decision.PUT);
                decision = this.setDecision(MVMap.Decision.REMOVE);
            }
            return decision;
        }

        @Override
        Object getNewValue(VersionedValue versionedValue) {
            return versionedValue == null ? null : versionedValue.getCurrentValue();
        }
    }

    public static final class PutIfAbsentDecisionMaker
    extends TxDecisionMaker {
        PutIfAbsentDecisionMaker(int n, Object object, Object object2, Transaction transaction) {
            super(n, object, object2, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
            int n;
            assert (this.getDecision() == null);
            if (versionedValue == null) {
                return this.logAndDecideToPut(null, null);
            }
            long l = versionedValue.getOperationId();
            if (l == 0L || this.isThisTransaction(n = TransactionStore.getTransactionId(l))) {
                if (versionedValue.getCurrentValue() != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                return this.logAndDecideToPut(versionedValue, versionedValue.getCommittedValue());
            }
            if (this.isCommitted(n)) {
                if (versionedValue.getCurrentValue() != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                return this.logAndDecideToPut(null, null);
            }
            if (this.getBlockingTransaction() != null) {
                return this.setDecision(MVMap.Decision.ABORT);
            }
            if (this.isRepeatedOperation(l)) {
                Object object = versionedValue.getCommittedValue();
                if (object != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                return this.logAndDecideToPut(null, null);
            }
            return this.setDecision(MVMap.Decision.REPEAT);
        }
    }
}

