/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.result;

import com.hm.h2.engine.Database;
import com.hm.h2.engine.Session;
import com.hm.h2.result.Row;
import com.hm.h2.store.Data;
import com.hm.h2.store.DataHandler;
import com.hm.h2.store.FileStore;
import com.hm.h2.util.Utils;
import com.hm.h2.value.DataType;
import com.hm.h2.value.Value;
import java.util.ArrayList;

public class RowList
implements AutoCloseable {
    private final Session session;
    private final ArrayList<Row> list = Utils.newSmallArrayList();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private Data rowBuff;
    private ArrayList<Value> lobs;
    private final int maxMemory;
    private int memory;
    private boolean written;

    public RowList(Session session) {
        this.session = session;
        this.maxMemory = session.getDatabase().isPersistent() ? session.getDatabase().getMaxOperationMemory() : 0;
    }

    private void writeRow(Data data, Row row) {
        data.checkCapacity(22);
        data.writeByte((byte)1);
        data.writeInt(row.getMemory());
        int n = row.getColumnCount();
        data.writeInt(n);
        data.writeLong(row.getKey());
        data.writeByte(row.isDeleted() ? (byte)1 : 0);
        for (int i = 0; i < n; ++i) {
            Value value = row.getValue(i);
            data.checkCapacity(1);
            if (value == null) {
                data.writeByte((byte)0);
                continue;
            }
            data.writeByte((byte)1);
            if (DataType.isLargeObject(value.getValueType()) && value.getSmall() == null && value.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = Utils.newSmallArrayList();
                }
                value = value.copyToTemp();
                this.lobs.add(value);
            }
            data.checkCapacity(data.getValueLen(value));
            data.writeValue(value);
        }
    }

    private void writeAllRows() {
        Object object;
        if (this.file == null) {
            object = this.session.getDatabase();
            String string = ((Database)object).createTempFile();
            this.file = ((Database)object).openFile(string, "rw", false);
            this.file.setCheckedWriting(false);
            this.file.seek(48L);
            this.rowBuff = Data.create((DataHandler)object, 4096, true);
            this.file.seek(48L);
        }
        object = this.rowBuff;
        RowList.initBuffer((Data)object);
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0 && ((Data)object).length() > 4096) {
                this.flushBuffer((Data)object);
                RowList.initBuffer((Data)object);
            }
            Row row = this.list.get(i);
            this.writeRow((Data)object, row);
        }
        this.flushBuffer((Data)object);
        this.list.clear();
        this.memory = 0;
    }

    private static void initBuffer(Data data) {
        data.reset();
        data.writeInt(0);
    }

    private void flushBuffer(Data data) {
        data.checkCapacity(1);
        data.writeByte((byte)0);
        data.fillAligned();
        data.setInt(0, data.length() / 16);
        this.file.write(data.getBytes(), 0, data.length());
    }

    public void add(Row row) {
        this.list.add(row);
        this.memory += row.getMemory() + 8;
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(Data data) {
        if (data.readByte() == 0) {
            return null;
        }
        int n = data.readInt();
        int n2 = data.readInt();
        long l = data.readLong();
        boolean bl = data.readByte() != 0;
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            Value value;
            if (data.readByte() == 0) {
                value = null;
            } else {
                value = data.readValue();
                if (value.isLinkedToTable() && value.getTableId() == 0) {
                    this.session.removeAtCommit(value);
                }
            }
            valueArray[i] = value;
        }
        Row row = this.session.createRow(valueArray, n);
        row.setKey(l);
        row.setDeleted(bl);
        return row;
    }

    public Row next() {
        Row row;
        if (this.file == null) {
            row = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                Data data = this.rowBuff;
                data.reset();
                int n = 16;
                this.file.readFully(data.getBytes(), 0, n);
                int n2 = data.readInt() * 16;
                data.checkCapacity(n2);
                if (n2 - n > 0) {
                    this.file.readFully(data.getBytes(), n, n2 - n);
                }
                while ((row = this.readRow(data)) != null) {
                    this.list.add(row);
                }
            }
            ++this.index;
            row = this.list.get(this.listIndex++);
        }
        return row;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

