/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.schema;

import com.hm.h2.command.ddl.SequenceOptions;
import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.engine.Session;
import com.hm.h2.message.DbException;
import com.hm.h2.schema.Schema;
import com.hm.h2.schema.SchemaObjectBase;
import com.hm.h2.table.Table;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueDecimal;
import com.hm.h2.value.ValueLong;
import java.math.BigDecimal;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value;
    private long valueWithMargin;
    private long increment;
    private long cacheSize;
    private long minValue;
    private long maxValue;
    private boolean cycle;
    private boolean belongsToTable;
    private boolean writeWithMargin;

    public Sequence(Session session, Schema schema, int n, String string, SequenceOptions sequenceOptions, boolean bl) {
        super(schema, n, string, 9);
        long l;
        long l2;
        Long l3 = sequenceOptions.getIncrement(session);
        long l4 = l3 != null ? l3 : 1L;
        Long l5 = sequenceOptions.getStartValue(session);
        Long l6 = sequenceOptions.getMinValue(null, session);
        Long l7 = sequenceOptions.getMaxValue(null, session);
        long l8 = l6 != null ? l6 : Sequence.getDefaultMinValue(l5, l4);
        long l9 = l2 = l7 != null ? l7 : Sequence.getDefaultMaxValue(l5, l4);
        long l10 = l5 != null ? l5 : (l = l4 >= 0L ? l8 : l2);
        if (!Sequence.isValid(l, l8, l2, l4)) {
            throw DbException.get(90009, string, Long.toString(l), Long.toString(l8), Long.toString(l2), Long.toString(l4));
        }
        this.valueWithMargin = this.value = l;
        this.increment = l4;
        l3 = sequenceOptions.getCacheSize(session);
        this.cacheSize = l3 != null ? Math.max(1L, l3) : 32L;
        this.minValue = l8;
        this.maxValue = l2;
        this.cycle = Boolean.TRUE.equals(sequenceOptions.getCycle());
        this.belongsToTable = bl;
    }

    public synchronized void modify(Long l, Long l2, Long l3, Long l4) {
        if (l == null) {
            l = this.value;
        }
        if (l2 == null) {
            l2 = this.minValue;
        }
        if (l3 == null) {
            l3 = this.maxValue;
        }
        if (l4 == null) {
            l4 = this.increment;
        }
        if (!Sequence.isValid(l, l2, l3, l4)) {
            throw DbException.get(90009, this.getName(), String.valueOf(l), String.valueOf(l2), String.valueOf(l3), String.valueOf(l4));
        }
        this.value = l;
        this.valueWithMargin = l;
        this.minValue = l2;
        this.maxValue = l3;
        this.increment = l4;
    }

    private static boolean isValid(long l, long l2, long l3, long l4) {
        return l2 <= l && l3 >= l && l3 > l2 && l4 != 0L && Math.abs(l4) + Long.MIN_VALUE <= l3 - l2 + Long.MIN_VALUE;
    }

    public static long getDefaultMinValue(Long l, long l2) {
        long l3;
        long l4 = l3 = l2 >= 0L ? 1L : Long.MIN_VALUE;
        if (l != null && l2 >= 0L && l < l3) {
            l3 = l;
        }
        return l3;
    }

    public static long getDefaultMaxValue(Long l, long l2) {
        long l3;
        long l4 = l3 = l2 >= 0L ? Long.MAX_VALUE : -1L;
        if (l != null && l2 < 0L && l > l3) {
            l3 = l;
        }
        return l3;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("DROP SEQUENCE IF EXISTS ");
        return this.getSQL(stringBuilder, true).toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public synchronized String getCreateSQL() {
        long l = this.writeWithMargin ? this.valueWithMargin : this.value;
        StringBuilder stringBuilder = new StringBuilder("CREATE SEQUENCE ");
        this.getSQL(stringBuilder, true).append(" START WITH ").append(l);
        if (this.increment != 1L) {
            stringBuilder.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.minValue != Sequence.getDefaultMinValue(l, this.increment)) {
            stringBuilder.append(" MINVALUE ").append(this.minValue);
        }
        if (this.maxValue != Sequence.getDefaultMaxValue(l, this.increment)) {
            stringBuilder.append(" MAXVALUE ").append(this.maxValue);
        }
        if (this.cycle) {
            stringBuilder.append(" CYCLE");
        }
        if (this.cacheSize != 32L) {
            if (this.cacheSize == 1L) {
                stringBuilder.append(" NO CACHE");
            } else {
                stringBuilder.append(" CACHE ").append(this.cacheSize);
            }
        }
        if (this.belongsToTable) {
            stringBuilder.append(" BELONGS_TO_TABLE");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getNext(Session session) {
        long l;
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
                this.valueWithMargin += this.increment * this.cacheSize;
                bl = true;
            }
            if (this.increment > 0L && this.value > this.maxValue || this.increment < 0L && this.value < this.minValue) {
                if (this.cycle) {
                    this.value = this.increment > 0L ? this.minValue : this.maxValue;
                    this.valueWithMargin = this.value + this.increment * this.cacheSize;
                    bl = true;
                } else {
                    throw DbException.get(90006, this.getName());
                }
            }
            l = this.value;
            this.value += this.increment;
        }
        if (bl) {
            this.flush(session);
        }
        object = this.database.getMode().decimalSequences ? ValueDecimal.get(BigDecimal.valueOf(l)) : ValueLong.get(l);
        if (session != null) {
            session.setCurrentValueFor(this, (Value)object);
        }
        return object;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Session session) {
        if (this.isTemporary()) {
            return;
        }
        if (session == null || !this.database.isSysTableLockedBy(session)) {
            Session session2 = this.database.getSystemSession();
            CastDataProvider castDataProvider = this.database.isMVStore() ? session2 : this.database;
            synchronized (castDataProvider) {
                this.flushInternal(session2);
                session2.commit(false);
            }
        }
        CastDataProvider castDataProvider = this.database.isMVStore() ? session : this.database;
        synchronized (castDataProvider) {
            this.flushInternal(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(Session session) {
        boolean bl = this.database.lockMeta(session);
        try {
            this.writeWithMargin = true;
            this.database.updateMeta(session, this);
        }
        finally {
            this.writeWithMargin = false;
            if (!bl) {
                this.database.unlockMeta(session);
            }
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(long l) {
        this.cacheSize = Math.max(1L, l);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

