/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.store.fs;

import com.hm.h2.engine.SysProperties;
import com.hm.h2.store.fs.FileBase;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;

class FileDisk
extends FileBase {
    private final RandomAccessFile file;
    private final String name;
    private final boolean readOnly;

    FileDisk(String string, String string2) {
        this.file = new RandomAccessFile(string, string2);
        this.name = string;
        this.readOnly = string2.equals("r");
    }

    @Override
    public void force(boolean bl) {
        String string = SysProperties.SYNC_METHOD;
        if (!"".equals(string)) {
            if ("sync".equals(string)) {
                this.file.getFD().sync();
            } else if ("force".equals(string)) {
                this.file.getChannel().force(true);
            } else if ("forceFalse".equals(string)) {
                this.file.getChannel().force(false);
            } else {
                this.file.getFD().sync();
            }
        }
    }

    @Override
    public FileChannel truncate(long l) {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        this.file.getChannel().truncate(l);
        return this;
    }

    @Override
    public synchronized FileLock tryLock(long l, long l2, boolean bl) {
        return this.file.getChannel().tryLock(l, l2, bl);
    }

    @Override
    public void implCloseChannel() {
        this.file.close();
    }

    @Override
    public long position() {
        return this.file.getFilePointer();
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        int n = this.file.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        if (n > 0) {
            byteBuffer.position(byteBuffer.position() + n);
        }
        return n;
    }

    @Override
    public FileChannel position(long l) {
        this.file.seek(l);
        return this;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.file.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    public String toString() {
        return this.name;
    }
}

