/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.tools;

import com.hm.h2.api.JavaObjectSerializer;
import com.hm.h2.compress.CompressLZF;
import com.hm.h2.engine.MetaRecord;
import com.hm.h2.jdbc.JdbcConnection;
import com.hm.h2.message.DbException;
import com.hm.h2.mvstore.MVMap;
import com.hm.h2.mvstore.MVStore;
import com.hm.h2.mvstore.MVStoreTool;
import com.hm.h2.mvstore.StreamStore;
import com.hm.h2.mvstore.db.LobStorageMap;
import com.hm.h2.mvstore.db.ValueDataType;
import com.hm.h2.mvstore.tx.TransactionMap;
import com.hm.h2.mvstore.tx.TransactionStore;
import com.hm.h2.pagestore.PageFreeList;
import com.hm.h2.pagestore.PageLog;
import com.hm.h2.pagestore.PageStore;
import com.hm.h2.pagestore.db.LobStorageBackend;
import com.hm.h2.result.Row;
import com.hm.h2.result.RowFactory;
import com.hm.h2.result.SearchRow;
import com.hm.h2.result.SimpleRow;
import com.hm.h2.security.SHA256;
import com.hm.h2.store.Data;
import com.hm.h2.store.DataHandler;
import com.hm.h2.store.DataReader;
import com.hm.h2.store.FileLister;
import com.hm.h2.store.FileStore;
import com.hm.h2.store.FileStoreInputStream;
import com.hm.h2.store.fs.FileUtils;
import com.hm.h2.util.IOUtils;
import com.hm.h2.util.IntArray;
import com.hm.h2.util.MathUtils;
import com.hm.h2.util.SmallLRUCache;
import com.hm.h2.util.StringUtils;
import com.hm.h2.util.TempFileDeleter;
import com.hm.h2.util.Tool;
import com.hm.h2.util.Utils;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueArray;
import com.hm.h2.value.ValueLob;
import com.hm.h2.value.ValueLobDb;
import com.hm.h2.value.ValueLong;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;

public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean transactionLog;
    private ArrayList<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private HashMap<String, String> columnTypeMap;
    private boolean remove;
    private int pageSize;
    private FileStore store;
    private int[] parents;
    private Stats stat;
    private boolean lobMaps;

    public static void main(String ... stringArray) {
        new Recover().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) {
        String string = ".";
        String string2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if ("-transactionLog".equals(string3)) {
                this.transactionLog = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string3);
        }
        this.process(string, string2);
    }

    public static Reader readClob(String string) {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string), StandardCharsets.UTF_8));
    }

    public static InputStream readBlob(String string) {
        return new BufferedInputStream(FileUtils.newInputStream(string));
    }

    public static ValueLobDb readBlobDb(Connection connection, long l, long l2) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        Recover.verifyPageStore(dataHandler);
        ValueLobDb valueLobDb = ValueLobDb.create(15, dataHandler, -2, l, null, l2);
        valueLobDb.setRecoveryReference(true);
        return valueLobDb;
    }

    private static void verifyPageStore(DataHandler dataHandler) {
        if (dataHandler.getLobStorage() instanceof LobStorageMap) {
            throw DbException.get(50100, "Restore page store recovery SQL script can only be restored to a PageStore file");
        }
    }

    public static ValueLobDb readClobDb(Connection connection, long l, long l2) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        Recover.verifyPageStore(dataHandler);
        ValueLobDb valueLobDb = ValueLobDb.create(16, dataHandler, -2, l, null, l2);
        valueLobDb.setRecoveryReference(true);
        return valueLobDb;
    }

    public static InputStream readBlobMap(Connection connection, long l, long l2) {
        final PreparedStatement preparedStatement = connection.prepareStatement("SELECT DATA FROM INFORMATION_SCHEMA.LOB_BLOCKS WHERE LOB_ID = ? AND SEQ = ? AND ? > 0");
        preparedStatement.setLong(1, l);
        preparedStatement.setLong(3, l2);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private int seq;
            private byte[] data = this.fetch();

            private byte[] fetch() {
                try {
                    preparedStatement.setInt(2, this.seq++);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        return resultSet.getBytes(1);
                    }
                    return null;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.data != null;
            }

            @Override
            public InputStream nextElement() {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
                this.data = this.fetch();
                return byteArrayInputStream;
            }
        });
    }

    public static Reader readClobMap(Connection connection, long l, long l2) {
        InputStream inputStream = Recover.readBlobMap(connection, l, l2);
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    public static void execute(String string, String string2) {
        try {
            new Recover().process(string, string2);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private void process(String string, String string2) {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.isEmpty()) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (String string3 : arrayList) {
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (string3.endsWith(".lob.db")) {
                this.dumpLob(string3, false);
                continue;
            }
            if (!string3.endsWith(".mv.db")) continue;
            String string4 = string3.substring(0, string3.length() - ".h2.db".length());
            try (PrintWriter printWriter = this.getWriter(string3, ".txt");){
                MVStoreTool.dump(string3, printWriter, true);
                MVStoreTool.info(string3, printWriter);
            }
            printWriter = this.getWriter(string4 + ".h2.db", ".sql");
            var8_8 = null;
            try {
                this.dumpMVStoreFile(printWriter, string3);
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (printWriter == null) continue;
                if (var8_8 != null) {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                    continue;
                }
                printWriter.close();
            }
        }
    }

    private PrintWriter getWriter(String string, String string2) {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        try {
            return new PrintWriter(IOUtils.getBufferedWriter(FileUtils.newOutputStream(string3, false)));
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray) {
        int n;
        printWriter.println("-- ERROR: " + string + " storageId: " + this.storageId + " recordLength: " + this.recordLength + " valueId: " + this.valueId);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            n = by & 0xFF;
            if (n >= 32 && n < 128) {
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append('?');
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            n = by & 0xFF;
            stringBuilder.append(' ');
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        long l = 0L;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        FileStoreInputStream fileStoreInputStream = null;
        try {
            outputStream = FileUtils.newOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            fileStoreInputStream = new FileStoreInputStream(fileStore, this, bl, false);
            l = IOUtils.copy(fileStoreInputStream, outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(outputStream);
            IOUtils.closeSilently(fileStoreInputStream);
            Recover.closeSilently(fileStore);
            catch (Throwable throwable2) {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(fileStoreInputStream);
                Recover.closeSilently(fileStore);
                throw throwable2;
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(fileStoreInputStream);
        Recover.closeSilently(fileStore);
        if (l == 0L) {
            try {
                FileUtils.delete(string2);
            }
            catch (Exception exception) {
                this.traceError(string2, exception);
            }
        }
    }

    private void getSQL(StringBuilder stringBuilder, String string, Value value) {
        ValueLobDb valueLobDb;
        byte[] byArray;
        if (value instanceof ValueLob) {
            ValueLob valueLob = (ValueLob)value;
            byte[] byArray2 = valueLob.getSmall();
            if (byArray2 == null) {
                String string2;
                String string3 = valueLob.getFileName();
                String string4 = string2 = valueLob.getValueType() == 15 ? "BLOB" : "CLOB";
                if (valueLob.isCompressed()) {
                    this.dumpLob(string3, true);
                    string3 = string3 + ".comp";
                }
                stringBuilder.append("READ_").append(string2).append("('").append(string3).append(".txt')");
                return;
            }
        } else if (value instanceof ValueLobDb && (byArray = (valueLobDb = (ValueLobDb)value).getSmall()) == null) {
            String string5;
            int n = valueLobDb.getValueType();
            long l = valueLobDb.getLobId();
            long l2 = valueLobDb.getType().getPrecision();
            if (n == 15) {
                string5 = "BLOB";
                stringBuilder.append("READ_BLOB");
            } else {
                string5 = "CLOB";
                stringBuilder.append("READ_CLOB");
            }
            if (this.lobMaps) {
                stringBuilder.append("_MAP");
            } else {
                stringBuilder.append("_DB");
            }
            this.columnTypeMap.put(string, string5);
            stringBuilder.append('(').append(l).append(", ").append(l2).append(')');
            return;
        }
        value.getSQL(stringBuilder);
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        PrintWriter printWriter = null;
        this.stat = new Stats();
        try {
            int n;
            int n2;
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
            this.resetSchema();
            this.store = FileStore.open(null, string, this.remove ? "rw" : "r");
            long l = this.store.length();
            try {
                this.store.init();
            }
            catch (Exception exception) {
                this.writeError(printWriter, exception);
            }
            Data data = Data.create((DataHandler)this, 128, false);
            this.seek(0L);
            this.store.readFully(data.getBytes(), 0, 128);
            data.setPos(48);
            this.pageSize = data.readInt();
            byte by = data.readByte();
            byte by2 = data.readByte();
            printWriter.println("-- pageSize: " + this.pageSize + " writeVersion: " + by + " readVersion: " + by2);
            if (this.pageSize < 64 || this.pageSize > 32768) {
                this.pageSize = 4096;
                printWriter.println("-- ERROR: page size; using " + this.pageSize);
            }
            long l2 = l / (long)this.pageSize;
            this.parents = new int[(int)l2];
            data = Data.create((DataHandler)this, this.pageSize, false);
            for (long i = 3L; i < l2; ++i) {
                data.reset();
                this.seek(i);
                this.store.readFully(data.getBytes(), 0, 32);
                data.readByte();
                data.readShortInt();
                this.parents[(int)i] = data.readInt();
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            data = Data.create((DataHandler)this, this.pageSize, false);
            for (long i = 1L; i != 3L; ++i) {
                data.reset();
                this.seek(i);
                this.store.readFully(data.getBytes(), 0, this.pageSize);
                CRC32 cRC32 = new CRC32();
                cRC32.update(data.getBytes(), 4, this.pageSize - 4);
                n2 = (int)cRC32.getValue();
                n = data.readInt();
                long l3 = data.readLong();
                int n6 = data.readInt();
                int n7 = data.readInt();
                int n8 = data.readInt();
                if (n2 == n) {
                    n3 = n6;
                    n4 = n7;
                    n5 = n8;
                }
                printWriter.println("-- head " + i + ": writeCounter: " + l3 + " log " + n6 + ":" + n7 + "/" + n8 + " crc " + n + " (" + (n2 == n ? "ok" : "expected: " + n2) + ")");
            }
            printWriter.println("-- log " + n3 + ":" + n4 + "/" + n5);
            PrintWriter printWriter2 = new PrintWriter(new OutputStream(){

                @Override
                public void write(int n) {
                }
            });
            this.dumpPageStore(printWriter2, l2);
            this.stat = new Stats();
            this.schema.clear();
            this.objectIdSet = new HashSet();
            this.dumpPageStore(printWriter, l2);
            this.writeSchemaSET(printWriter);
            this.writeSchema(printWriter);
            try {
                this.dumpPageLogStream(printWriter, n3, n4, n5, l2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            printWriter.println("---- Statistics ----");
            printWriter.println("-- page count: " + l2 + ", free: " + this.stat.free);
            long l4 = Math.max(1L, this.stat.pageDataRows + this.stat.pageDataEmpty + this.stat.pageDataHead);
            printWriter.println("-- page data bytes: head " + this.stat.pageDataHead + ", empty " + this.stat.pageDataEmpty + ", rows " + this.stat.pageDataRows + " (" + (100L - 100L * this.stat.pageDataEmpty / l4) + "% full)");
            for (n2 = 0; n2 < this.stat.pageTypeCount.length; ++n2) {
                n = this.stat.pageTypeCount[n2];
                if (n <= 0) continue;
                printWriter.println("-- " + Recover.getPageType(n2) + " " + (long)(100 * n) / l2 + "%, " + n + " page(s)");
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                Recover.closeSilently(this.store);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            Recover.closeSilently(this.store);
        }
        IOUtils.closeSilently(printWriter);
        Recover.closeSilently(this.store);
    }

    private void dumpMVStoreFile(PrintWriter printWriter, String string) {
        printWriter.println("-- MVStore");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_MAP FOR \"" + this.getClass().getName() + ".readBlobMap\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_MAP FOR \"" + this.getClass().getName() + ".readClobMap\";");
        this.resetSchema();
        this.setDatabaseName(string.substring(0, string.length() - ".mv.db".length()));
        try (MVStore mVStore = new MVStore.Builder().fileName(string).recoveryMode().readOnly().open();){
            String string2;
            Comparable<MetaRecord> comparable;
            Value[] valueArray;
            Object object;
            Iterator<Object> iterator;
            TransactionMap transactionMap;
            String string3;
            this.dumpLobMaps(printWriter, mVStore);
            printWriter.println("-- Meta");
            Recover.dumpMeta(printWriter, mVStore);
            printWriter.println("-- Tables");
            TransactionStore transactionStore = new TransactionStore(mVStore);
            try {
                transactionStore.init();
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
            ValueDataType valueDataType = new ValueDataType();
            for (String string4 : mVStore.getMapNames()) {
                if (!string4.startsWith("table.") || Integer.parseInt(string3 = string4.substring("table.".length())) != 0) continue;
                transactionMap = transactionStore.begin().openMap(string4, valueDataType, valueDataType);
                iterator = transactionMap.keyIterator(null);
                while (iterator.hasNext()) {
                    Value value = iterator.next();
                    object = ((ValueArray)transactionMap.get(value)).getList();
                    try {
                        valueArray = new SimpleRow((Value[])object);
                        comparable = new MetaRecord((SearchRow)valueArray);
                        this.schema.add((MetaRecord)comparable);
                        if (((MetaRecord)comparable).getObjectType() != 0) continue;
                        string2 = object[3].getString();
                        String string5 = Recover.extractTableOrViewName(string2);
                        this.tableMap.put(((MetaRecord)comparable).getId(), string5);
                    }
                    catch (Throwable throwable) {
                        this.writeError(printWriter, throwable);
                    }
                }
            }
            this.writeSchemaSET(printWriter);
            printWriter.println("---- Table Data ----");
            for (String string4 : mVStore.getMapNames()) {
                if (!string4.startsWith("table.") || Integer.parseInt(string3 = string4.substring("table.".length())) == 0) continue;
                transactionMap = transactionStore.begin().openMap(string4, valueDataType, valueDataType);
                iterator = transactionMap.keyIterator(null);
                boolean bl = false;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    valueArray = ((ValueArray)transactionMap.get(object)).getList();
                    this.recordLength = valueArray.length;
                    if (!bl) {
                        this.setStorage(Integer.parseInt(string3));
                        comparable = new StringBuilder();
                        this.valueId = 0;
                        while (this.valueId < this.recordLength) {
                            string2 = this.storageName + "." + this.valueId;
                            ((StringBuilder)comparable).setLength(0);
                            this.getSQL((StringBuilder)comparable, string2, valueArray[this.valueId]);
                            ++this.valueId;
                        }
                        this.createTemporaryTable(printWriter);
                        bl = true;
                    }
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("INSERT INTO O_").append(string3).append(" VALUES(");
                    this.valueId = 0;
                    while (this.valueId < this.recordLength) {
                        if (this.valueId > 0) {
                            ((StringBuilder)comparable).append(", ");
                        }
                        string2 = this.storageName + "." + this.valueId;
                        this.getSQL((StringBuilder)comparable, string2, valueArray[this.valueId]);
                        ++this.valueId;
                    }
                    ((StringBuilder)comparable).append(");");
                    printWriter.println(((StringBuilder)comparable).toString());
                }
            }
            this.writeSchema(printWriter);
            printWriter.println("DROP ALIAS READ_BLOB_MAP;");
            printWriter.println("DROP ALIAS READ_CLOB_MAP;");
            printWriter.println("DROP TABLE IF EXISTS INFORMATION_SCHEMA.LOB_BLOCKS;");
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
    }

    private static void dumpMeta(PrintWriter printWriter, MVStore mVStore) {
        MVMap<String, String> mVMap = mVStore.getMetaMap();
        for (Map.Entry<String, String> entry : mVMap.entrySet()) {
            printWriter.println("-- " + entry.getKey() + " = " + entry.getValue());
        }
    }

    private void dumpLobMaps(PrintWriter printWriter, MVStore mVStore) {
        this.lobMaps = mVStore.hasMap("lobData");
        if (!this.lobMaps) {
            return;
        }
        MVMap<Long, byte[]> mVMap = mVStore.openMap("lobData");
        StreamStore streamStore = new StreamStore(mVMap);
        MVMap mVMap2 = mVStore.openMap("lobMap");
        printWriter.println("-- LOB");
        printWriter.println("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_BLOCKS(LOB_ID BIGINT, SEQ INT, DATA BINARY, PRIMARY KEY(LOB_ID, SEQ));");
        boolean bl = false;
        block2: for (Map.Entry object : mVMap2.entrySet()) {
            long l = (Long)object.getKey();
            Object[] objectArray = (Object[])object.getValue();
            byte[] byArray = (byte[])objectArray[0];
            InputStream inputStream = streamStore.get(byArray);
            int n = 8192;
            byte[] byArray2 = new byte[n];
            try {
                int n2 = 0;
                while (true) {
                    int n3;
                    if ((n3 = IOUtils.readFully(inputStream, byArray2, byArray2.length)) > 0) {
                        printWriter.print("INSERT INTO INFORMATION_SCHEMA.LOB_BLOCKS VALUES(" + l + ", " + n2 + ", '");
                        printWriter.print(StringUtils.convertBytesToHex(byArray2, n3));
                        printWriter.println("');");
                    }
                    if (n3 != n) continue block2;
                    ++n2;
                }
            }
            catch (IOException iOException) {
                this.writeError(printWriter, iOException);
                bl = true;
            }
        }
        printWriter.println("-- lobMap.size: " + mVMap2.sizeAsLong());
        printWriter.println("-- lobData.size: " + mVMap.sizeAsLong());
        if (bl) {
            printWriter.println("-- lobMap");
            for (Long l : mVMap2.keyList()) {
                Object[] objectArray = (Object[])mVMap2.get(l);
                byte[] byArray = (byte[])objectArray[0];
                printWriter.println("--     " + l + " " + StreamStore.toString(byArray));
            }
            printWriter.println("-- lobData");
            for (Long l : mVMap.keyList()) {
                printWriter.println("--     " + l + " len " + mVMap.get(l).length);
            }
        }
    }

    private static String getPageType(int n) {
        switch (n) {
            case 0: {
                return "free";
            }
            case 1: {
                return "data leaf";
            }
            case 2: {
                return "data node";
            }
            case 3: {
                return "data overflow";
            }
            case 4: {
                return "btree leaf";
            }
            case 5: {
                return "btree node";
            }
            case 6: {
                return "free list";
            }
            case 7: {
                return "stream trunk";
            }
            case 8: {
                return "stream data";
            }
        }
        return "[" + n + "]";
    }

    private void dumpPageStore(PrintWriter printWriter, long l) {
        Data data = Data.create((DataHandler)this, this.pageSize, false);
        for (long i = 3L; i < l; ++i) {
            data = Data.create((DataHandler)this, this.pageSize, false);
            this.seek(i);
            this.store.readFully(data.getBytes(), 0, this.pageSize);
            this.dumpPage(printWriter, data, i, l);
        }
    }

    private void dumpPage(PrintWriter printWriter, Data data, long l, long l2) {
        try {
            int n = data.readByte();
            switch (n) {
                case 0: {
                    int n2 = n;
                    this.stat.pageTypeCount[n2] = this.stat.pageTypeCount[n2] + 1;
                    return;
                }
            }
            boolean bl = (n & 0x10) != 0;
            n &= 0xFFFFFFEF;
            if (!PageStore.checksumTest(data.getBytes(), (int)l, this.pageSize)) {
                this.writeDataError(printWriter, "checksum mismatch type: " + n, data.getBytes());
            }
            data.readShortInt();
            switch (n) {
                case 1: {
                    int n3 = n;
                    this.stat.pageTypeCount[n3] = this.stat.pageTypeCount[n3] + 1;
                    int n4 = data.readInt();
                    this.setStorage(data.readVarInt());
                    int n5 = data.readVarInt();
                    short s = data.readShortInt();
                    printWriter.println("-- page " + l + ": data leaf " + (bl ? "(last) " : "") + "parent: " + n4 + " table: " + this.storageId + " entries: " + s + " columns: " + n5);
                    this.dumpPageDataLeaf(printWriter, data, bl, l, n5, s);
                    break;
                }
                case 2: {
                    int n6 = n;
                    this.stat.pageTypeCount[n6] = this.stat.pageTypeCount[n6] + 1;
                    int n7 = data.readInt();
                    this.setStorage(data.readVarInt());
                    int n8 = data.readInt();
                    short s = data.readShortInt();
                    printWriter.println("-- page " + l + ": data node " + (bl ? "(last) " : "") + "parent: " + n7 + " table: " + this.storageId + " entries: " + s + " rowCount: " + n8);
                    this.dumpPageDataNode(printWriter, data, l, s);
                    break;
                }
                case 3: {
                    int n9 = n;
                    this.stat.pageTypeCount[n9] = this.stat.pageTypeCount[n9] + 1;
                    printWriter.println("-- page " + l + ": data overflow " + (bl ? "(last) " : ""));
                    break;
                }
                case 4: {
                    int n10 = n;
                    this.stat.pageTypeCount[n10] = this.stat.pageTypeCount[n10] + 1;
                    int n11 = data.readInt();
                    this.setStorage(data.readVarInt());
                    short s = data.readShortInt();
                    printWriter.println("-- page " + l + ": b-tree leaf " + (bl ? "(last) " : "") + "parent: " + n11 + " index: " + this.storageId + " entries: " + s);
                    if (this.trace) {
                        this.dumpPageBtreeLeaf(printWriter, data, s, !bl);
                    }
                    break;
                }
                case 5: {
                    int n12 = n;
                    this.stat.pageTypeCount[n12] = this.stat.pageTypeCount[n12] + 1;
                    int n13 = data.readInt();
                    this.setStorage(data.readVarInt());
                    printWriter.println("-- page " + l + ": b-tree node " + (bl ? "(last) " : "") + "parent: " + n13 + " index: " + this.storageId);
                    this.dumpPageBtreeNode(printWriter, data, l, !bl);
                    break;
                }
                case 6: {
                    int n14 = n;
                    this.stat.pageTypeCount[n14] = this.stat.pageTypeCount[n14] + 1;
                    printWriter.println("-- page " + l + ": free list " + (bl ? "(last)" : ""));
                    this.stat.free += this.dumpPageFreeList(printWriter, data, l, l2);
                    break;
                }
                case 7: {
                    int n15 = n;
                    this.stat.pageTypeCount[n15] = this.stat.pageTypeCount[n15] + 1;
                    printWriter.println("-- page " + l + ": log trunk");
                    break;
                }
                case 8: {
                    int n16 = n;
                    this.stat.pageTypeCount[n16] = this.stat.pageTypeCount[n16] + 1;
                    printWriter.println("-- page " + l + ": log data");
                    break;
                }
                default: {
                    printWriter.println("-- ERROR page " + l + " unknown type " + n);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.writeError(printWriter, exception);
        }
    }

    private void dumpPageLogStream(PrintWriter printWriter, int n, int n2, int n3, long l) {
        byte by;
        Data data = Data.create((DataHandler)this, this.pageSize, false);
        DataReader dataReader = new DataReader(new PageInputStream(printWriter, this, this.store, n, n2, n3, this.pageSize));
        printWriter.println("---- Transaction log ----");
        CompressLZF compressLZF = new CompressLZF();
        while ((by = dataReader.readByte()) >= 0) {
            Object object;
            int n4;
            if (by == 0) continue;
            if (by == 1) {
                Object object2;
                n4 = dataReader.readVarInt();
                int n5 = dataReader.readVarInt();
                object = new byte[this.pageSize];
                if (n5 == 0) {
                    dataReader.readFully((byte[])object, this.pageSize);
                } else if (n5 != 1) {
                    object2 = new byte[n5];
                    dataReader.readFully((byte[])object2, n5);
                    try {
                        compressLZF.expand((byte[])object2, 0, n5, (byte[])object, 0, this.pageSize);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw DbException.convertToIOException(arrayIndexOutOfBoundsException);
                    }
                }
                object2 = "";
                int n6 = object[0];
                boolean bl = (n6 & 0x10) != 0;
                switch (n6 &= 0xFFFFFFEF) {
                    case 0: {
                        object2 = "empty";
                        break;
                    }
                    case 1: {
                        object2 = "data leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 2: {
                        object2 = "data node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 3: {
                        object2 = "data overflow " + (bl ? "(last)" : "");
                        break;
                    }
                    case 4: {
                        object2 = "b-tree leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 5: {
                        object2 = "b-tree node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 6: {
                        object2 = "free list " + (bl ? "(last)" : "");
                        break;
                    }
                    case 7: {
                        object2 = "log trunk";
                        break;
                    }
                    case 8: {
                        object2 = "log data";
                        break;
                    }
                    default: {
                        object2 = "ERROR: unknown type " + n6;
                    }
                }
                printWriter.println("-- undo page " + n4 + " " + (String)object2);
                if (!this.trace) continue;
                Data data2 = Data.create(null, object, false);
                this.dumpPage(printWriter, data2, n4, l);
                continue;
            }
            if (by == 5) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                Row row = PageLog.readRow(RowFactory.DEFAULT, dataReader, data);
                printWriter.println("-- session " + n4 + " table " + this.storageId + " + " + row.toString());
                if (!this.transactionLog) continue;
                if (this.storageId == 0 && row.getColumnCount() >= 4) {
                    int n7 = (int)row.getKey();
                    String string = row.getValue(3).getString();
                    String string2 = Recover.extractTableOrViewName(string);
                    if (row.getValue(2).getInt() == 0) {
                        this.tableMap.put(n7, string2);
                    }
                    printWriter.println(string + ";");
                    continue;
                }
                object = this.tableMap.get(this.storageId);
                if (object == null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("INSERT INTO ").append((String)object).append(" VALUES(");
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    row.getValue(i).getSQL(stringBuilder);
                }
                stringBuilder.append(");");
                printWriter.println(stringBuilder.toString());
                continue;
            }
            if (by == 6) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                long l2 = dataReader.readVarLong();
                printWriter.println("-- session " + n4 + " table " + this.storageId + " - " + l2);
                if (!this.transactionLog) continue;
                if (this.storageId == 0) {
                    int n8 = (int)l2;
                    String string = this.tableMap.get(n8);
                    if (string == null) continue;
                    printWriter.println("DROP TABLE IF EXISTS " + string + ";");
                    continue;
                }
                String string = this.tableMap.get(this.storageId);
                if (string == null) continue;
                String string3 = "DELETE FROM " + string + " WHERE _ROWID_ = " + l2 + ";";
                printWriter.println(string3);
                continue;
            }
            if (by == 7) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                printWriter.println("-- session " + n4 + " table " + this.storageId + " truncate");
                if (!this.transactionLog) continue;
                printWriter.println("TRUNCATE TABLE " + this.storageId);
                continue;
            }
            if (by == 2) {
                n4 = dataReader.readVarInt();
                printWriter.println("-- commit " + n4);
                continue;
            }
            if (by == 4) {
                n4 = dataReader.readVarInt();
                printWriter.println("-- rollback " + n4);
                continue;
            }
            if (by == 3) {
                n4 = dataReader.readVarInt();
                String string = dataReader.readString();
                printWriter.println("-- prepare commit " + n4 + " " + string);
                continue;
            }
            if (by == 0) continue;
            if (by == 8) {
                printWriter.println("-- checkpoint");
                continue;
            }
            if (by == 9) {
                n4 = dataReader.readVarInt();
                StringBuilder stringBuilder = new StringBuilder("-- free");
                for (int i = 0; i < n4; ++i) {
                    stringBuilder.append(' ').append(dataReader.readVarInt());
                }
                printWriter.println(stringBuilder);
                continue;
            }
            printWriter.println("-- ERROR: unknown operation " + by);
            break;
        }
    }

    private String setStorage(int n) {
        this.storageId = n;
        this.storageName = "O_" + Integer.toString(n).replace('-', 'M');
        return this.storageName;
    }

    private void dumpPageBtreeNode(PrintWriter printWriter, Data data, long l, boolean bl) {
        int n;
        int n2;
        int n3 = data.readInt();
        int n4 = data.readShortInt();
        int[] nArray = new int[n4 + 1];
        int[] nArray2 = new int[n4];
        nArray[n4] = data.readInt();
        this.checkParent(printWriter, l, nArray, n4);
        int n5 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = data.readInt();
            this.checkParent(printWriter, l, nArray, n2);
            n = data.readShortInt();
            n5 = Math.min(n, n5);
            nArray2[n2] = n;
        }
        n5 -= data.length();
        if (!this.trace) {
            return;
        }
        printWriter.println("--   empty: " + n5);
        for (n2 = 0; n2 < n4; ++n2) {
            Value value;
            n = nArray2[n2];
            data.setPos(n);
            long l2 = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l2);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n2 + "] child: " + nArray[n2] + " key: " + l2 + " data: " + value);
        }
        printWriter.println("-- [" + n4 + "] child: " + nArray[n4] + " rowCount: " + n3);
    }

    private int dumpPageFreeList(PrintWriter printWriter, Data data, long l, long l2) {
        int n = PageFreeList.getPagesAddressed(this.pageSize);
        int n2 = n >> 3;
        byte[] byArray = new byte[n2];
        data.read(byArray, 0, n2);
        BitSet bitSet = BitSet.valueOf(byArray);
        int n3 = 0;
        long l3 = 0L;
        for (long i = l; l3 < (long)n && i < l2; ++l3, ++i) {
            if (l3 == 0L || i % 100L == 0L) {
                if (l3 > 0L) {
                    printWriter.println();
                }
                printWriter.print("-- " + i + " ");
            } else if (i % 20L == 0L) {
                printWriter.print(" - ");
            } else if (i % 10L == 0L) {
                printWriter.print(' ');
            }
            printWriter.print(bitSet.get((int)l3) ? (char)'1' : '0');
            if (bitSet.get((int)l3)) continue;
            ++n3;
        }
        printWriter.println();
        return n3;
    }

    private void dumpPageBtreeLeaf(PrintWriter printWriter, Data data, int n, boolean bl) {
        int n2;
        int n3;
        int[] nArray = new int[n];
        int n4 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = data.readShortInt();
            n4 = Math.min(n2, n4);
            nArray[n3] = n2;
        }
        printWriter.println("--   empty: " + (n4 -= data.length()));
        for (n3 = 0; n3 < n; ++n3) {
            Value value;
            n2 = nArray[n3];
            data.setPos(n2);
            long l = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] key: " + l + " data: " + value);
        }
    }

    private void checkParent(PrintWriter printWriter, long l, int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 < 0 || n2 >= this.parents.length) {
            printWriter.println("-- ERROR [" + l + "] child[" + n + "]: " + n2 + " >= page count: " + this.parents.length);
        } else if ((long)this.parents[n2] != l) {
            printWriter.println("-- ERROR [" + l + "] child[" + n + "]: " + n2 + " parent: " + this.parents[n2]);
        }
    }

    private void dumpPageDataNode(PrintWriter printWriter, Data data, long l, int n) {
        int n2;
        int[] nArray = new int[n + 1];
        long[] lArray = new long[n];
        nArray[n] = data.readInt();
        this.checkParent(printWriter, l, nArray, n);
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = data.readInt();
            this.checkParent(printWriter, l, nArray, n2);
            lArray[n2] = data.readVarLong();
        }
        if (!this.trace) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.println("-- [" + n2 + "] child: " + nArray[n2] + " key: " + lArray[n2]);
        }
        printWriter.println("-- [" + n + "] child: " + nArray[n]);
    }

    private void dumpPageDataLeaf(PrintWriter printWriter, Data data, boolean bl, long l, int n, int n2) {
        int n3;
        int n4;
        int[] nArray;
        long[] lArray;
        block12: {
            lArray = new long[n2];
            nArray = new int[n2];
            long l2 = 0L;
            if (!bl) {
                l2 = data.readInt();
                printWriter.println("--   next: " + l2);
            }
            int n5 = this.pageSize;
            for (n4 = 0; n4 < n2; ++n4) {
                lArray[n4] = data.readVarLong();
                short s = data.readShortInt();
                n5 = Math.min(s, n5);
                nArray[n4] = s;
            }
            this.stat.pageDataRows += (long)(this.pageSize - n5);
            this.stat.pageDataHead += (long)data.length();
            this.stat.pageDataEmpty += (long)(n5 -= data.length());
            if (this.trace) {
                printWriter.println("--   empty: " + n5);
            }
            if (!bl) {
                Data data2 = Data.create((DataHandler)this, this.pageSize, false);
                data.setPos(this.pageSize);
                long l3 = l;
                while (true) {
                    int n6;
                    this.checkParent(printWriter, l3, new int[]{(int)l2}, 0);
                    l3 = l2;
                    this.seek(l2);
                    this.store.readFully(data2.getBytes(), 0, this.pageSize);
                    data2.reset();
                    n3 = data2.readByte();
                    data2.readShortInt();
                    data2.readInt();
                    if (n3 == 19) {
                        n6 = data2.readShortInt();
                        printWriter.println("-- chain: " + l2 + " type: " + n3 + " size: " + n6);
                        data.checkCapacity(n6);
                        data.write(data2.getBytes(), data2.length(), n6);
                        break block12;
                    }
                    if (n3 != 3) break;
                    l2 = data2.readInt();
                    if (l2 == 0L) {
                        this.writeDataError(printWriter, "next:0", data2.getBytes());
                        break block12;
                    }
                    n6 = this.pageSize - data2.length();
                    printWriter.println("-- chain: " + l2 + " type: " + n3 + " size: " + n6 + " next: " + l2);
                    data.checkCapacity(n6);
                    data.write(data2.getBytes(), data2.length(), n6);
                }
                this.writeDataError(printWriter, "type: " + n3, data2.getBytes());
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n7;
            String string;
            long l4 = lArray[n4];
            n3 = nArray[n4];
            if (this.trace) {
                printWriter.println("-- [" + n4 + "] storage: " + this.storageId + " key: " + l4 + " off: " + n3);
            }
            data.setPos(n3);
            Value[] valueArray = this.createRecord(printWriter, data, n);
            if (valueArray == null) continue;
            this.createTemporaryTable(printWriter);
            this.writeRow(printWriter, data, valueArray);
            if (!this.remove || this.storageId != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n7 = Utils.indexOf(data.getBytes(), "SALT ".getBytes(), n3)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("IF NOT EXISTS ")) {
                string2 = string2.substring("IF NOT EXISTS ".length());
            }
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            byte[] byArray = SHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = MathUtils.secureRandomBytes(8);
            byte[] byArray3 = SHA256.getHashWithSalt(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder().append("SALT '");
            StringUtils.convertBytesToHex(stringBuilder, byArray2).append("' HASH '");
            StringUtils.convertBytesToHex(stringBuilder, byArray3).append('\'');
            byte[] byArray4 = stringBuilder.toString().getBytes();
            System.arraycopy(byArray4, 0, data.getBytes(), n7, byArray4.length);
            this.seek(l);
            this.store.write(data.getBytes(), 0, this.pageSize);
            if (this.trace) {
                this.out.println("User: " + string2);
            }
            this.remove = false;
        }
    }

    private void seek(long l) {
        this.store.seek(l * (long)this.pageSize);
    }

    private Value[] createRecord(PrintWriter printWriter, Data data, int n) {
        Value[] valueArray;
        this.recordLength = n;
        if (n <= 0) {
            this.writeDataError(printWriter, "columnCount<0", data.getBytes());
            return null;
        }
        try {
            valueArray = new Value[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", data.getBytes());
            return null;
        }
        return valueArray;
    }

    private void writeRow(PrintWriter printWriter, Data data, Value[] valueArray) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ").append(this.storageName).append(" VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                object2 = data.readValue();
                valueArray[this.valueId] = object2;
                if (this.valueId > 0) {
                    stringBuilder.append(", ");
                }
                object = this.storageName + "." + this.valueId;
                this.getSQL(stringBuilder, (String)object, (Value)object2);
            }
            catch (Exception exception) {
                this.writeDataError(printWriter, "exception " + exception, data.getBytes());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", data.getBytes());
            }
            ++this.valueId;
        }
        stringBuilder.append(");");
        printWriter.println(stringBuilder.toString());
        if (this.storageId == 0) {
            try {
                object2 = new SimpleRow(valueArray);
                object = new MetaRecord((SearchRow)object2);
                this.schema.add((MetaRecord)object);
                if (((MetaRecord)object).getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = Recover.extractTableOrViewName(string);
                    this.tableMap.put(((MetaRecord)object).getId(), string2);
                }
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
        }
    }

    private void resetSchema() {
        this.schema = new ArrayList();
        this.objectIdSet = new HashSet();
        this.tableMap = new HashMap();
        this.columnTypeMap = new HashMap();
    }

    private void writeSchemaSET(PrintWriter printWriter) {
        printWriter.println("---- Schema SET ----");
        for (MetaRecord metaRecord : this.schema) {
            if (metaRecord.getObjectType() != 6) continue;
            String string = metaRecord.getSQL();
            printWriter.println(string + ";");
        }
    }

    private void writeSchema(PrintWriter printWriter) {
        String string;
        Object object;
        printWriter.println("---- Schema ----");
        Collections.sort(this.schema);
        for (MetaRecord object2 : this.schema) {
            if (object2.getObjectType() == 6 || Recover.isSchemaObjectTypeDelayed(object2)) continue;
            String string2 = object2.getSQL();
            printWriter.println(string2 + ";");
        }
        boolean bl = false;
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            object = entry.getKey();
            string = entry.getValue();
            if (!this.objectIdSet.contains(object) || !Recover.isLobTable(string)) continue;
            this.setStorage((Integer)object);
            printWriter.println("DELETE FROM " + string + ";");
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
            if (!string.equals("INFORMATION_SCHEMA.LOBS") && !string.equalsIgnoreCase("\"INFORMATION_SCHEMA\".\"LOBS\"")) continue;
            printWriter.println("UPDATE " + string + " SET `TABLE` = " + -2 + ";");
            bl = true;
        }
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            object = entry.getKey();
            string = entry.getValue();
            if (!this.objectIdSet.contains(object)) continue;
            this.setStorage((Integer)object);
            if (Recover.isLobTable(string)) continue;
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer n : this.objectIdSet) {
            this.setStorage(n);
            printWriter.println("DROP TABLE " + this.storageName + ";");
        }
        printWriter.println("DROP ALIAS READ_BLOB;");
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB_DB;");
        printWriter.println("DROP ALIAS READ_CLOB_DB;");
        if (bl) {
            printWriter.println("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE `TABLE` = -2;");
        }
        for (MetaRecord metaRecord : this.schema) {
            if (!Recover.isSchemaObjectTypeDelayed(metaRecord)) continue;
            object = metaRecord.getSQL();
            printWriter.println((String)object + ";");
        }
    }

    private static boolean isLobTable(String string) {
        return string.startsWith("INFORMATION_SCHEMA.LOB") || string.startsWith("\"INFORMATION_SCHEMA\".\"LOB") || string.startsWith("\"information_schema\".\"lob");
    }

    private static boolean isSchemaObjectTypeDelayed(MetaRecord metaRecord) {
        switch (metaRecord.getObjectType()) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            printWriter.write("CREATE TABLE ");
            printWriter.write(this.storageName);
            printWriter.write(40);
            for (int i = 0; i < this.recordLength; ++i) {
                if (i > 0) {
                    printWriter.print(", ");
                }
                printWriter.write(67);
                printWriter.print(i);
                printWriter.write(32);
                String string = this.columnTypeMap.get(this.storageName + "." + i);
                printWriter.write(string == null ? "VARCHAR" : string);
            }
            printWriter.println(");");
            printWriter.flush();
        }
    }

    private static String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        if (string.startsWith("IF NOT EXISTS ")) {
            string = string.substring("IF NOT EXISTS ".length());
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private static void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        return FileStore.open(this, string, "rw");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw DbException.throwInternalError();
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorageBackend getLobStorage() {
        return null;
    }

    @Override
    public int readLob(long l, byte[] byArray, long l2, byte[] byArray2, int n, int n2) {
        throw DbException.throwInternalError();
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        return null;
    }

    @Override
    public CompareMode getCompareMode() {
        return CompareMode.getInstance(null, 0);
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final FileStore store;
        private final Data page;
        private final int pageSize;
        private long trunkPage;
        private long nextTrunkPage;
        private long dataPage;
        private final IntArray dataPages = new IntArray();
        private boolean endOfFile;
        private int remaining;
        private int logKey;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n, long l, long l2, int n2) {
            this.writer = printWriter;
            this.store = fileStore;
            this.pageSize = n2;
            this.logKey = n - 1;
            this.nextTrunkPage = l;
            this.dataPage = l2;
            this.page = Data.create(dataHandler, n2, false);
        }

        @Override
        public int read() {
            byte[] byArray = new byte[]{0};
            int n = this.read(byArray);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
                n4 += n3;
                n += n3;
                n2 -= n3;
            }
            return n4 == 0 ? -1 : n4;
        }

        private int readBlock(byte[] byArray, int n, int n2) {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.page.read(byArray, n, n3);
            this.remaining -= n3;
            return n3;
        }

        private void fillBuffer() {
            int n;
            int n2;
            int n3;
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            while (this.dataPages.size() == 0) {
                if (this.nextTrunkPage == 0L) {
                    this.endOfFile = true;
                    return;
                }
                this.trunkPage = this.nextTrunkPage;
                this.store.seek(this.trunkPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                if (!PageStore.checksumTest(this.page.getBytes(), (int)this.trunkPage, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + this.trunkPage);
                    this.endOfFile = true;
                    return;
                }
                byte by = this.page.readByte();
                this.page.readShortInt();
                if (by != 7) {
                    this.writer.println("-- log eof " + this.trunkPage + " type: " + by + " expected type: " + 7);
                    this.endOfFile = true;
                    return;
                }
                this.page.readInt();
                int n4 = this.page.readInt();
                ++this.logKey;
                if (n4 != this.logKey) {
                    this.writer.println("-- log eof " + this.trunkPage + " type: " + by + " expected key: " + this.logKey + " got: " + n4);
                }
                this.nextTrunkPage = this.page.readInt();
                this.writer.println("-- log " + n4 + ":" + this.trunkPage + " next: " + this.nextTrunkPage);
                n3 = this.page.readShortInt();
                for (n2 = 0; n2 < n3; ++n2) {
                    n = this.page.readInt();
                    if (this.dataPage != 0L) {
                        if ((long)n != this.dataPage) continue;
                        this.dataPage = 0L;
                    }
                    this.dataPages.add(n);
                }
            }
            if (this.dataPages.size() > 0) {
                this.page.reset();
                long l = this.dataPages.get(0);
                this.dataPages.remove(0);
                this.store.seek(l * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                n3 = this.page.readByte();
                if (n3 != 0 && !PageStore.checksumTest(this.page.getBytes(), (int)l, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + l);
                    this.endOfFile = true;
                    return;
                }
                this.page.readShortInt();
                n2 = this.page.readInt();
                n = this.page.readInt();
                this.writer.println("-- log " + n + ":" + this.trunkPage + "/" + l);
                if (n3 != 8) {
                    this.writer.println("-- log eof " + l + " type: " + n3 + " parent: " + n2 + " expected type: " + 8);
                    this.endOfFile = true;
                    return;
                }
                if (n != this.logKey) {
                    this.writer.println("-- log eof " + l + " type: " + n3 + " parent: " + n2 + " expected key: " + this.logKey + " got: " + n);
                    this.endOfFile = true;
                    return;
                }
                this.remaining = this.pageSize - this.page.length();
            }
        }
    }

    static class Stats {
        long pageDataEmpty;
        long pageDataRows;
        long pageDataHead;
        final int[] pageTypeCount = new int[10];
        int free;

        Stats() {
        }
    }
}

