/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.message.DbException;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import java.math.BigDecimal;
import java.sql.PreparedStatement;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    public static final long ZERO_BITS = 0L;
    public static final ValueDouble ZERO = new ValueDouble(0.0);
    public static final ValueDouble ONE = new ValueDouble(1.0);
    private static final ValueDouble NAN = new ValueDouble(Double.NaN);
    private final double value;

    private ValueDouble(double d) {
        this.value = d;
    }

    @Override
    public Value add(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value + valueDouble.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value - valueDouble.value);
    }

    @Override
    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value * valueDouble.value);
    }

    @Override
    public Value divide(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        if (valueDouble.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value / valueDouble.value);
    }

    @Override
    public ValueDouble modulus(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        if (valueDouble.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value % valueDouble.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        if (this.value == Double.POSITIVE_INFINITY) {
            stringBuilder.append("POWER(0, -1)");
        } else if (this.value == Double.NEGATIVE_INFINITY) {
            stringBuilder.append("(-POWER(0, -1))");
        } else if (Double.isNaN(this.value)) {
            stringBuilder.append("SQRT(-1)");
        } else {
            stringBuilder.append(this.value);
        }
        return stringBuilder;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_DOUBLE;
    }

    @Override
    public int getValueType() {
        return 7;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Double.compare(this.value, ((ValueDouble)value).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0 ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Math.abs(this.value) <= Double.MAX_VALUE) {
            return BigDecimal.valueOf(this.value);
        }
        throw DbException.get(22018, Double.toString(this.value));
    }

    @Override
    public String getString() {
        return Double.toString(this.value);
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToRawLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        preparedStatement.setDouble(n, this.value);
    }

    public static ValueDouble get(double d) {
        if (d == 1.0) {
            return ONE;
        }
        if (d == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(d)) {
            return NAN;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueDouble)) {
            return false;
        }
        return this.compareTypeSafe((ValueDouble)object, null, null) == 0;
    }
}

