/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.message.DbException;
import com.hm.h2.util.Bits;
import com.hm.h2.util.StringUtils;
import com.hm.h2.util.Utils;
import com.hm.h2.util.json.JSONByteArrayTarget;
import com.hm.h2.util.json.JSONBytesSource;
import com.hm.h2.util.json.JSONItemType;
import com.hm.h2.util.json.JSONStringSource;
import com.hm.h2.util.json.JSONStringTarget;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.util.Arrays;

public class ValueJson
extends Value {
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TRUE_BYTES = "true".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] FALSE_BYTES = "false".getBytes(StandardCharsets.ISO_8859_1);
    public static final ValueJson NULL = new ValueJson(NULL_BYTES);
    public static final ValueJson TRUE = new ValueJson(TRUE_BYTES);
    public static final ValueJson FALSE = new ValueJson(FALSE_BYTES);
    public static final ValueJson ZERO = new ValueJson(new byte[]{48});
    private final byte[] value;
    private int hash;

    private ValueJson(byte[] byArray) {
        this.value = byArray;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        String string = JSONBytesSource.parse(this.value, new JSONStringTarget(true));
        return stringBuilder.append("JSON '").append(string).append('\'');
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_JSON;
    }

    @Override
    public int getValueType() {
        return 40;
    }

    @Override
    public String getString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.value.clone();
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    public JSONItemType getItemType() {
        switch (this.value[0]) {
            case 91: {
                return JSONItemType.ARRAY;
            }
            case 123: {
                return JSONItemType.OBJECT;
            }
        }
        return JSONItemType.SCALAR;
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        preparedStatement.setBytes(n, this.value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Utils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueJson && Arrays.equals(this.value, ((ValueJson)object).value);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Bits.compareNotNullUnsigned(this.value, ((ValueJson)value).value);
    }

    public static ValueJson fromJson(String string) {
        byte[] byArray;
        try {
            byArray = JSONStringSource.normalize(string);
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(22018, string);
        }
        return ValueJson.getInternal(byArray);
    }

    public static ValueJson fromJson(byte[] byArray) {
        try {
            byArray = JSONBytesSource.normalize(byArray);
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(byArray));
        }
        return ValueJson.getInternal(byArray);
    }

    public static ValueJson get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static ValueJson get(int n) {
        return n != 0 ? ValueJson.getNumber(Integer.toString(n)) : ZERO;
    }

    public static ValueJson get(long l) {
        return l != 0L ? ValueJson.getNumber(Long.toString(l)) : ZERO;
    }

    public static ValueJson get(BigDecimal bigDecimal) {
        if (bigDecimal.signum() == 0 && bigDecimal.scale() == 0) {
            return ZERO;
        }
        String string = bigDecimal.toString();
        int n = string.indexOf(69);
        if (n >= 0 && string.charAt(++n) == '+') {
            int n2 = string.length();
            string = new StringBuilder(n2 - 1).append(string, 0, n).append(string, n + 1, n2).toString();
        }
        return ValueJson.getNumber(string);
    }

    public static ValueJson get(String string) {
        return new ValueJson(JSONByteArrayTarget.encodeString(new ByteArrayOutputStream(string.length() + 2), string).toByteArray());
    }

    public static ValueJson getInternal(byte[] byArray) {
        int n = byArray.length;
        switch (n) {
            case 1: {
                if (byArray[0] != 48) break;
                return ZERO;
            }
            case 4: {
                if (Arrays.equals(TRUE_BYTES, byArray)) {
                    return TRUE;
                }
                if (!Arrays.equals(NULL_BYTES, byArray)) break;
                return NULL;
            }
            case 5: {
                if (!Arrays.equals(FALSE_BYTES, byArray)) break;
                return FALSE;
            }
        }
        return new ValueJson(byArray);
    }

    private static ValueJson getNumber(String string) {
        return new ValueJson(string.getBytes(StandardCharsets.ISO_8859_1));
    }
}

