/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.jdbc.PgConnection;
import com.hm.postgresql.util.ExpressionProperties;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.HostSpec;
import com.hm.postgresql.util.LogWriterHandler;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.SharedTimer;
import com.hm.postgresql.util.URLCoder;
import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Driver
implements java.sql.Driver {
    private static @Nullable Driver registeredDriver;
    private static final Logger PARENT_LOGGER;
    private static final Logger LOGGER;
    private static final SharedTimer SHARED_TIMER;
    private static final String DEFAULT_PORT = "5432";
    private @Nullable Properties defaultProperties;
    private static @Nullable String loggerHandlerFile;

    private synchronized Properties getDefaultProperties() {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() {
        Properties properties = new Properties();
        try {
            PGProperty.USER.set(properties, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader");
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return properties;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", classLoader);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration<URL> enumeration = classLoader.getResources("com/hm/postgresql/driverconfig.properties");
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            URL uRL = (URL)arrayList.get(i);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", uRL);
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
        }
        return properties;
    }

    @Override
    public @Nullable Connection connect(String string, @Nullable Properties properties) {
        Object object;
        Properties properties2;
        if (string == null) {
            throw new SQLException("url is null");
        }
        if (!string.startsWith("jdbc:postgresql:")) {
            return null;
        }
        try {
            properties2 = this.getDefaultProperties();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        Properties properties3 = new Properties(properties2);
        if (properties != null) {
            Set<String> set = properties.stringPropertyNames();
            for (String object2 : set) {
                object = properties.getProperty(object2);
                if (object == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + object2, PSQLState.UNEXPECTED_ERROR);
                }
                properties3.setProperty(object2, (String)object);
            }
        }
        if ((properties3 = Driver.parseURL(string, properties3)) == null) {
            return null;
        }
        try {
            this.setupLoggerFromProperties(properties3);
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", string);
            long l = Driver.timeout(properties3);
            if (l <= 0L) {
                return Driver.makeConnection(string, properties3);
            }
            ConnectThread connectThread = new ConnectThread(string, properties3);
            object = new Thread((Runnable)connectThread, "PostgreSQL JDBC driver connection thread");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            return connectThread.getResult(l);
        }
        catch (PSQLException pSQLException) {
            LOGGER.log(Level.FINE, "Connection error: ", pSQLException);
            throw pSQLException;
        }
        catch (AccessControlException accessControlException) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)accessControlException);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", exception);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)exception);
        }
    }

    private void setupLoggerFromProperties(Properties properties) {
        String string = PGProperty.LOGGER_LEVEL.get(properties);
        if (string == null) {
            return;
        }
        if ("OFF".equalsIgnoreCase(string)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return;
        }
        if ("DEBUG".equalsIgnoreCase(string)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(string)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        }
        ExpressionProperties expressionProperties = new ExpressionProperties(properties, System.getProperties());
        String string2 = PGProperty.LOGGER_FILE.get(expressionProperties);
        if (string2 != null && string2.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handler : PARENT_LOGGER.getHandlers()) {
            handler.close();
            PARENT_LOGGER.removeHandler(handler);
            loggerHandlerFile = null;
        }
        Object object = null;
        if (string2 != null) {
            try {
                object = new FileHandler(string2);
                loggerHandlerFile = string2;
            }
            catch (Exception exception) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        if (object == null) {
            object = DriverManager.getLogWriter() != null ? new LogWriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), simpleFormatter) : new ConsoleHandler());
        } else {
            ((Handler)object).setFormatter(simpleFormatter);
        }
        Level level = PARENT_LOGGER.getLevel();
        if (level != null) {
            ((Handler)object).setLevel(level);
        }
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler((Handler)object);
    }

    private static Connection makeConnection(String string, Properties properties) {
        return new PgConnection(Driver.hostSpecs(properties), Driver.user(properties), Driver.database(properties), properties, string);
    }

    @Override
    public boolean acceptsURL(String string) {
        return Driver.parseURL(string, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        Properties properties2 = new Properties(properties);
        Properties properties3 = Driver.parseURL(string, properties2);
        if (properties3 != null) {
            properties2 = properties3;
        }
        PGProperty[] pGPropertyArray = PGProperty.values();
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[pGPropertyArray.length];
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            driverPropertyInfoArray[i] = pGPropertyArray[i].toDriverPropertyInfo(properties2);
        }
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Deprecated
    public static String getVersion() {
        return "PostgreSQL JDBC Driver 42.3.1";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static @Nullable Properties parseURL(String string, @Nullable Properties properties) {
        String[] stringArray;
        Properties properties2 = new Properties(properties);
        String string2 = string;
        String string3 = "";
        int n = string.indexOf(63);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (!string2.startsWith("jdbc:postgresql:")) {
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:postgresql:\" but was: {0}", string);
            return null;
        }
        if ((string2 = string2.substring("jdbc:postgresql:".length())).startsWith("//")) {
            int n2 = (string2 = string2.substring(2)).indexOf(47);
            if (n2 == -1) {
                LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", string);
                return null;
            }
            properties2.setProperty("PGDBNAME", URLCoder.decode(string2.substring(n2 + 1)));
            String[] stringArray2 = string2.substring(0, n2).split(",");
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string4 : stringArray2) {
                int n3 = string4.lastIndexOf(58);
                if (n3 != -1 && string4.lastIndexOf(93) < n3) {
                    String string5 = string4.substring(n3 + 1);
                    try {
                        int n4 = Integer.parseInt(string5);
                        if (n4 < 1 || n4 > 65535) {
                            LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", string5);
                            return null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", string5);
                        return null;
                    }
                    stringBuilder2.append(string5);
                    stringBuilder.append(string4.subSequence(0, n3));
                } else {
                    stringBuilder2.append(DEFAULT_PORT);
                    stringBuilder.append(string4);
                }
                stringBuilder2.append(',');
                stringBuilder.append(',');
            }
            stringBuilder2.setLength(stringBuilder2.length() - 1);
            stringBuilder.setLength(stringBuilder.length() - 1);
            properties2.setProperty("PGPORT", stringBuilder2.toString());
            properties2.setProperty("PGHOST", stringBuilder.toString());
        } else {
            if (properties == null || !properties.containsKey("PGPORT")) {
                properties2.setProperty("PGPORT", DEFAULT_PORT);
            }
            if (properties == null || !properties.containsKey("PGHOST")) {
                properties2.setProperty("PGHOST", "localhost");
            }
            if (properties == null || !properties.containsKey("PGDBNAME")) {
                properties2.setProperty("PGDBNAME", URLCoder.decode(string2));
            }
        }
        for (String string6 : stringArray = string3.split("&")) {
            if (string6.isEmpty()) continue;
            int n5 = string6.indexOf(61);
            if (n5 == -1) {
                properties2.setProperty(string6, "");
                continue;
            }
            properties2.setProperty(string6.substring(0, n5), URLCoder.decode(string6.substring(n5 + 1)));
        }
        return properties2;
    }

    private static HostSpec[] hostSpecs(Properties properties) {
        String[] stringArray = Nullness.castNonNull(properties.getProperty("PGHOST")).split(",");
        String[] stringArray2 = Nullness.castNonNull(properties.getProperty("PGPORT")).split(",");
        String string = properties.getProperty("localSocketAddress");
        HostSpec[] hostSpecArray = new HostSpec[stringArray.length];
        for (int i = 0; i < hostSpecArray.length; ++i) {
            hostSpecArray[i] = new HostSpec(stringArray[i], Integer.parseInt(stringArray2[i]), string);
        }
        return hostSpecArray;
    }

    private static String user(Properties properties) {
        return properties.getProperty("user", "");
    }

    private static String database(Properties properties) {
        return properties.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties properties) {
        String string = PGProperty.LOGIN_TIMEOUT.get(properties);
        if (string != null) {
            try {
                return (long)(Float.parseFloat(string) * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", string);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> clazz, String string) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", clazz.getName() + "." + string), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static SharedTimer getSharedTimer() {
        return SHARED_TIMER;
    }

    public static void register() {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver driver = new Driver();
        DriverManager.registerDriver(driver);
        registeredDriver = driver;
    }

    public static void deregister() {
        if (registeredDriver == null) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        PARENT_LOGGER = Logger.getLogger("com.hm.postgresql");
        LOGGER = Logger.getLogger("com.hm.postgresql.Driver");
        SHARED_TIMER = new SharedTimer();
        try {
            Driver.register();
        }
        catch (SQLException sQLException) {
            throw new ExceptionInInitializerError(sQLException);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private @Nullable Connection result;
        private @Nullable Throwable resultException;
        private boolean abandoned;

        ConnectThread(String string, Properties properties) {
            this.url = string;
            this.props = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable throwable;
            Connection connection;
            try {
                connection = Driver.makeConnection(this.url, this.props);
                throwable = null;
            }
            catch (Throwable throwable2) {
                connection = null;
                throwable = throwable2;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = connection;
                    this.resultException = throwable;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long l) {
            long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + l;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long l3 = l2 - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (l3 <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

