/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.copy;

import com.hm.postgresql.copy.CopyDual;
import com.hm.postgresql.copy.CopyIn;
import com.hm.postgresql.copy.CopyOperation;
import com.hm.postgresql.copy.CopyOut;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.util.ByteStreamWriter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;

public class CopyManager {
    static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Encoding encoding;
    private final QueryExecutor queryExecutor;
    private final BaseConnection connection;

    public CopyManager(BaseConnection baseConnection) {
        this.encoding = baseConnection.getEncoding();
        this.queryExecutor = baseConnection.getQueryExecutor();
        this.connection = baseConnection;
    }

    public CopyIn copyIn(String string) {
        CopyOperation copyOperation = this.queryExecutor.startCopy(string, this.connection.getAutoCommit());
        if (copyOperation == null || copyOperation instanceof CopyIn) {
            return (CopyIn)copyOperation;
        }
        copyOperation.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyIn but got {0}", copyOperation.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public CopyOut copyOut(String string) {
        CopyOperation copyOperation = this.queryExecutor.startCopy(string, this.connection.getAutoCommit());
        if (copyOperation == null || copyOperation instanceof CopyOut) {
            return (CopyOut)copyOperation;
        }
        copyOperation.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyOut but got {0}", copyOperation.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public CopyDual copyDual(String string) {
        CopyOperation copyOperation = this.queryExecutor.startCopy(string, this.connection.getAutoCommit());
        if (copyOperation == null || copyOperation instanceof CopyDual) {
            return (CopyDual)copyOperation;
        }
        copyOperation.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyDual but got {0}", copyOperation.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public long copyOut(String string, Writer writer) {
        CopyOut copyOut = this.copyOut(string);
        try {
            byte[] byArray;
            while ((byArray = copyOut.readFromCopy()) != null) {
                writer.write(this.encoding.decode(byArray));
            }
            long l = copyOut.getHandledRowCount();
            return l;
        }
        catch (IOException iOException) {
            if (copyOut.isActive()) {
                copyOut.cancelCopy();
            }
            try {
                byte[] byArray;
                while ((byArray = copyOut.readFromCopy()) != null) {
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw iOException;
        }
        finally {
            if (copyOut.isActive()) {
                copyOut.cancelCopy();
            }
        }
    }

    public long copyOut(String string, OutputStream outputStream) {
        CopyOut copyOut = this.copyOut(string);
        try {
            byte[] byArray;
            while ((byArray = copyOut.readFromCopy()) != null) {
                outputStream.write(byArray);
            }
            long l = copyOut.getHandledRowCount();
            return l;
        }
        catch (IOException iOException) {
            if (copyOut.isActive()) {
                copyOut.cancelCopy();
            }
            try {
                byte[] byArray;
                while ((byArray = copyOut.readFromCopy()) != null) {
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw iOException;
        }
        finally {
            if (copyOut.isActive()) {
                copyOut.cancelCopy();
            }
        }
    }

    public long copyIn(String string, Reader reader) {
        return this.copyIn(string, reader, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String string, Reader reader, int n) {
        char[] cArray = new char[n];
        CopyIn copyIn = this.copyIn(string);
        try {
            int n2;
            while ((n2 = reader.read(cArray)) >= 0) {
                if (n2 <= 0) continue;
                byte[] byArray = this.encoding.encode(new String(cArray, 0, n2));
                copyIn.writeToCopy(byArray, 0, byArray.length);
            }
            long l = copyIn.endCopy();
            return l;
        }
        finally {
            if (copyIn.isActive()) {
                copyIn.cancelCopy();
            }
        }
    }

    public long copyIn(String string, InputStream inputStream) {
        return this.copyIn(string, inputStream, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String string, InputStream inputStream, int n) {
        byte[] byArray = new byte[n];
        CopyIn copyIn = this.copyIn(string);
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 <= 0) continue;
                copyIn.writeToCopy(byArray, 0, n2);
            }
            long l = copyIn.endCopy();
            return l;
        }
        finally {
            if (copyIn.isActive()) {
                copyIn.cancelCopy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String string, ByteStreamWriter byteStreamWriter) {
        CopyIn copyIn = this.copyIn(string);
        try {
            copyIn.writeToCopy(byteStreamWriter);
            long l = copyIn.endCopy();
            return l;
        }
        finally {
            if (copyIn.isActive()) {
                copyIn.cancelCopy();
            }
        }
    }
}

