/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.util.internal.Nullness;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AsciiStringInterner {
    final ConcurrentMap<BaseKey, SoftReference<String>> cache = new ConcurrentHashMap<BaseKey, SoftReference<String>>(128);
    final ReferenceQueue<String> refQueue = new ReferenceQueue();

    AsciiStringInterner() {
    }

    public boolean putString(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n = AsciiStringInterner.hashKey(byArray, 0, byArray.length);
        if (n == 0) {
            return false;
        }
        Key key = new Key(byArray, n);
        this.cache.put(key, new SoftReference<String>(string));
        return true;
    }

    public String getString(byte[] byArray, int n, int n2, Encoding encoding) {
        Object object;
        if (n2 == 0) {
            return "";
        }
        int n3 = AsciiStringInterner.hashKey(byArray, n, n2);
        if (n3 == 0) {
            return encoding.decode(byArray, n, n2);
        }
        this.cleanQueue();
        TempKey tempKey = new TempKey(n3, byArray, n, n2);
        SoftReference softReference2 = (SoftReference)this.cache.get(tempKey);
        if (softReference2 != null && (object = (String)softReference2.get()) != null) {
            return object;
        }
        object = Arrays.copyOfRange(byArray, n, n + n2);
        Key key = new Key((byte[])object, n3);
        String string = new String((byte[])object, StandardCharsets.US_ASCII);
        softReference2 = this.cache.compute(key, (baseKey, softReference) -> {
            if (softReference == null) {
                return new StringReference(key, string);
            }
            String string2 = (String)softReference.get();
            return string2 != null ? softReference : new StringReference(key, string);
        });
        return (String)Nullness.castNonNull(softReference2.get());
    }

    public String getStringIfPresent(byte[] byArray, int n, int n2, Encoding encoding) {
        String string;
        if (n2 == 0) {
            return "";
        }
        int n3 = AsciiStringInterner.hashKey(byArray, n, n2);
        if (n3 == 0) {
            return encoding.decode(byArray, n, n2);
        }
        this.cleanQueue();
        TempKey tempKey = new TempKey(n3, byArray, n, n2);
        SoftReference softReference = (SoftReference)this.cache.get(tempKey);
        if (softReference != null && (string = (String)softReference.get()) != null) {
            return string;
        }
        return new String(byArray, n, n2, StandardCharsets.US_ASCII);
    }

    private void cleanQueue() {
        Reference<String> reference;
        while ((reference = this.refQueue.poll()) != null) {
            ((StringReference)reference).dispose();
        }
    }

    private static int hashKey(byte[] byArray, int n, int n2) {
        int n3 = 1;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            byte by = byArray[i];
            if (by < 0) {
                return 0;
            }
            n3 = 31 * n3 + by;
        }
        return n3;
    }

    static boolean arrayEquals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + 8 * this.cache.size());
        stringBuilder.append("AsciiStringInterner [");
        this.cache.forEach((baseKey, softReference) -> {
            stringBuilder.append('\'');
            baseKey.appendString(stringBuilder);
            stringBuilder.append("', ");
        });
        int n = stringBuilder.length();
        if (n > 21) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private final class StringReference
    extends SoftReference<String> {
        private final BaseKey key;

        StringReference(BaseKey baseKey, String string) {
            super(string, AsciiStringInterner.this.refQueue);
            this.key = baseKey;
        }

        void dispose() {
            AsciiStringInterner.this.cache.remove(this.key, this);
        }
    }

    private static final class Key
    extends BaseKey {
        final byte[] key;

        Key(byte[] byArray, int n) {
            super(n);
            this.key = byArray;
        }

        @Override
        boolean equalsBytes(BaseKey baseKey) {
            return baseKey.equals(this.key, 0, this.key.length);
        }

        @Override
        public boolean equals(byte[] byArray, int n, int n2) {
            return AsciiStringInterner.arrayEquals(this.key, 0, this.key.length, byArray, n, n2);
        }

        @Override
        void appendString(StringBuilder stringBuilder) {
            for (int i = 0; i < this.key.length; ++i) {
                stringBuilder.append((char)this.key[i]);
            }
        }
    }

    private static class TempKey
    extends BaseKey {
        final byte[] bytes;
        final int offset;
        final int length;

        TempKey(int n, byte[] byArray, int n2, int n3) {
            super(n);
            this.bytes = byArray;
            this.offset = n2;
            this.length = n3;
        }

        @Override
        boolean equalsBytes(BaseKey baseKey) {
            return baseKey.equals(this.bytes, this.offset, this.length);
        }

        @Override
        public boolean equals(byte[] byArray, int n, int n2) {
            return AsciiStringInterner.arrayEquals(this.bytes, this.offset, this.length, byArray, n, n2);
        }

        @Override
        void appendString(StringBuilder stringBuilder) {
            int n = this.offset + this.length;
            for (int i = this.offset; i < n; ++i) {
                stringBuilder.append((char)this.bytes[i]);
            }
        }
    }

    private static abstract class BaseKey {
        private final int hash;

        BaseKey(int n) {
            this.hash = n;
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof BaseKey)) {
                return false;
            }
            BaseKey baseKey = (BaseKey)object;
            return this.equalsBytes(baseKey);
        }

        abstract boolean equalsBytes(BaseKey var1);

        abstract boolean equals(byte[] var1, int var2, int var3);

        abstract void appendString(StringBuilder var1);
    }
}

