/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.util.CanEstimateSize;
import org.checkerframework.checker.nullness.qual.Nullable;

class BaseQueryKey
implements CanEstimateSize {
    public final String sql;
    public final boolean isParameterized;
    public final boolean escapeProcessing;

    BaseQueryKey(String string, boolean bl, boolean bl2) {
        this.sql = string;
        this.isParameterized = bl;
        this.escapeProcessing = bl2;
    }

    public String toString() {
        return "BaseQueryKey{sql='" + this.sql + '\'' + ", isParameterized=" + this.isParameterized + ", escapeProcessing=" + this.escapeProcessing + '}';
    }

    @Override
    public long getSize() {
        if (this.sql == null) {
            return 16L;
        }
        return 16L + (long)this.sql.length() * 2L;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BaseQueryKey baseQueryKey = (BaseQueryKey)object;
        if (this.isParameterized != baseQueryKey.isParameterized) {
            return false;
        }
        if (this.escapeProcessing != baseQueryKey.escapeProcessing) {
            return false;
        }
        return this.sql != null ? this.sql.equals(baseQueryKey.sql) : baseQueryKey.sql == null;
    }

    public int hashCode() {
        int n = this.sql != null ? this.sql.hashCode() : 0;
        n = 31 * n + (this.isParameterized ? 1 : 0);
        n = 31 * n + (this.escapeProcessing ? 1 : 0);
        return n;
    }
}

