/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Query;
import com.hm.postgresql.util.CanEstimateSize;

public class CachedQuery
implements CanEstimateSize {
    public final Object key;
    public final Query query;
    public final boolean isFunction;
    private int executeCount;

    public CachedQuery(Object object, Query query, boolean bl) {
        assert (object instanceof String || object instanceof CanEstimateSize) : "CachedQuery.key should either be String or implement CanEstimateSize. Actual class is " + object.getClass();
        this.key = object;
        this.query = query;
        this.isFunction = bl;
    }

    public void increaseExecuteCount() {
        if (this.executeCount < Integer.MAX_VALUE) {
            ++this.executeCount;
        }
    }

    public void increaseExecuteCount(int n) {
        int n2 = this.executeCount + n;
        if (n2 > 0) {
            this.executeCount = n2;
        }
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    @Override
    public long getSize() {
        long l = this.key instanceof String ? (long)((String)this.key).length() * 2L : ((CanEstimateSize)this.key).getSize();
        return l * 2L + 100L;
    }

    public String toString() {
        return "CachedQuery{executeCount=" + this.executeCount + ", query=" + this.query + ", isFunction=" + this.isFunction + '}';
    }
}

