/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Parser;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandCompleteParser {
    private long oid;
    private long rows;

    public long getOid() {
        return this.oid;
    }

    public long getRows() {
        return this.rows;
    }

    void set(long l, long l2) {
        this.oid = l;
        this.rows = l2;
    }

    public void parse(String string) {
        if (!Parser.isDigitAt(string, string.length() - 1)) {
            this.set(0L, 0L);
            return;
        }
        long l = 0L;
        long l2 = 0L;
        try {
            int n = string.lastIndexOf(32);
            if (Parser.isDigitAt(string, n + 1)) {
                int n2;
                l2 = Parser.parseLong(string, n + 1, string.length());
                if (Parser.isDigitAt(string, n - 1) && Parser.isDigitAt(string, (n2 = string.lastIndexOf(32, n - 1)) + 1)) {
                    l = Parser.parseLong(string, n2 + 1, n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Unable to parse the count in command completion tag: {0}.", string), PSQLState.CONNECTION_FAILURE, (Throwable)numberFormatException);
        }
        this.set(l, l2);
    }

    public String toString() {
        return "CommandStatus{oid=" + this.oid + ", rows=" + this.rows + '}';
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CommandCompleteParser commandCompleteParser = (CommandCompleteParser)object;
        if (this.oid != commandCompleteParser.oid) {
            return false;
        }
        return this.rows == commandCompleteParser.rows;
    }

    public int hashCode() {
        int n = (int)(this.oid ^ this.oid >>> 32);
        n = 31 * n + (int)(this.rows ^ this.rows >>> 32);
        return n;
    }
}

