/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Encoding;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EncodingPredictor {
    private static final Translation[] FATAL_TRANSLATIONS = new Translation[]{new Translation("\u0412\u0410\u0416\u041d\u041e", null, "ru", "WIN", "ALT", "KOI8"), new Translation("\u81f4\u547d\u9519\u8bef", null, "zh_CN", "EUC_CN", "GBK", "BIG5"), new Translation("KATASTROFALNY", null, "pl", "LATIN2"), new Translation("FATALE", null, "it", "LATIN1", "LATIN9"), new Translation("FATAL", new String[]{"\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", "\u30ed\u30fc\u30eb", "\u30e6\u30fc\u30b6"}, "ja", "EUC_JP", "SJIS"), new Translation(null, null, "fr/de/es/pt_BR", "LATIN1", "LATIN3", "LATIN4", "LATIN5", "LATIN7", "LATIN9")};

    public static @Nullable DecodeResult decode(byte[] byArray, int n, int n2) {
        Encoding encoding = Encoding.defaultEncoding();
        for (Translation translation : FATAL_TRANSLATIONS) {
            for (String string : translation.encodings) {
                Object object;
                Encoding encoding2 = Encoding.getDatabaseEncoding(string);
                if (encoding2 == encoding) continue;
                if (translation.fatalText != null) {
                    try {
                        byte[] iOException = encoding2.encode(translation.fatalText);
                        object = new byte[iOException.length + 2];
                        object[0] = 83;
                        object[((Object)object).length - 1] = false;
                        System.arraycopy(iOException, 0, object, 1, iOException.length);
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    if (!EncodingPredictor.arrayContains(byArray, n, n2, (byte[])object, 0, ((Object)object).length)) continue;
                }
                if (translation.texts != null) {
                    boolean bl = false;
                    for (String string2 : translation.texts) {
                        try {
                            byte[] byArray2 = encoding2.encode(string2);
                            if (!EncodingPredictor.arrayContains(byArray, n, n2, byArray2, 0, byArray2.length)) continue;
                            bl = true;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl) continue;
                }
                try {
                    object = encoding2.decode(byArray, n, n2);
                    if (((String)object).indexOf(65533) != -1) continue;
                    return new DecodeResult((String)object, encoding2.name());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static boolean arrayContains(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 < n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            int n5;
            while (i < n2 && byArray[n + i] != byArray2[n3]) {
                ++i;
            }
            for (n5 = 1; n5 < n4 && byArray[n + i + n5] == byArray2[n3 + n5]; ++n5) {
            }
            if (n5 != n4) continue;
            return true;
        }
        return false;
    }

    static class Translation {
        public final @Nullable String fatalText;
        private final String @Nullable [] texts;
        public final String language;
        public final String[] encodings;

        Translation(@Nullable String string, String @Nullable [] stringArray, String string2, String ... stringArray2) {
            this.fatalText = string;
            this.texts = stringArray;
            this.language = string2;
            this.encodings = stringArray2;
        }
    }

    public static class DecodeResult {
        public final String result;
        public final @Nullable String encoding;

        DecodeResult(String string, @Nullable String string2) {
            this.result = string;
            this.encoding = string2;
        }
    }
}

