/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.SqlCommand;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NativeQuery {
    private static final String[] BIND_NAMES = new String[1280];
    private static final int[] NO_BINDS = new int[0];
    public final String nativeSql;
    public final int[] bindPositions;
    public final SqlCommand command;
    public final boolean multiStatement;

    public NativeQuery(String string, SqlCommand sqlCommand) {
        this(string, NO_BINDS, true, sqlCommand);
    }

    public NativeQuery(String string, int[] nArray, boolean bl, SqlCommand sqlCommand) {
        this.nativeSql = string;
        this.bindPositions = nArray == null || nArray.length == 0 ? NO_BINDS : nArray;
        this.multiStatement = bl;
        this.command = sqlCommand;
    }

    public String toString(@Nullable ParameterList parameterList) {
        if (this.bindPositions.length == 0) {
            return this.nativeSql;
        }
        int n = this.nativeSql.length();
        String[] stringArray = new String[this.bindPositions.length];
        for (int i = 1; i <= this.bindPositions.length; ++i) {
            String string;
            stringArray[i - 1] = string = parameterList == null ? "?" : parameterList.toString(i, true);
            n += string.length() - NativeQuery.bindName(i).length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(this.nativeSql, 0, this.bindPositions[0]);
        for (int i = 1; i <= this.bindPositions.length; ++i) {
            stringBuilder.append(stringArray[i - 1]);
            int n2 = i < this.bindPositions.length ? this.bindPositions[i] : this.nativeSql.length();
            stringBuilder.append(this.nativeSql, this.bindPositions[i - 1] + NativeQuery.bindName(i).length(), n2);
        }
        return stringBuilder.toString();
    }

    public static String bindName(int n) {
        return n < BIND_NAMES.length ? BIND_NAMES[n] : "$" + n;
    }

    public static StringBuilder appendBindName(StringBuilder stringBuilder, int n) {
        if (n < BIND_NAMES.length) {
            return stringBuilder.append(NativeQuery.bindName(n));
        }
        stringBuilder.append('$');
        stringBuilder.append(n);
        return stringBuilder;
    }

    public static int calculateBindLength(int n) {
        int n2 = 0;
        int n3 = 2;
        int n4 = 9;
        while (n > 0) {
            int n5 = Math.min(n4, n);
            n -= n5;
            n2 += n3 * n5;
            ++n3;
            n4 *= 10;
        }
        return n2;
    }

    public SqlCommand getCommand() {
        return this.command;
    }

    static {
        for (int i = 1; i < BIND_NAMES.length; ++i) {
            NativeQuery.BIND_NAMES[i] = "$" + i;
        }
    }
}

