/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.core.EncodingPredictor;
import com.hm.postgresql.core.FixedLengthOutputStream;
import com.hm.postgresql.core.PGBindException;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.core.VisibleBufferedInputStream;
import com.hm.postgresql.gss.GSSInputStream;
import com.hm.postgresql.gss.GSSOutputStream;
import com.hm.postgresql.util.ByteStreamWriter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.HostSpec;
import com.hm.postgresql.util.PGPropertyMaxResultBufferParser;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.SocketFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.MessageProp;

public class PGStream
implements Closeable,
Flushable {
    private final SocketFactory socketFactory;
    private final HostSpec hostSpec;
    private final byte[] int4Buf;
    private final byte[] int2Buf;
    private Socket connection;
    private VisibleBufferedInputStream pgInput;
    private OutputStream pgOutput;
    private byte @Nullable [] streamBuffer;
    boolean gssEncrypted = false;
    private long nextStreamAvailableCheckTime;
    private int minStreamAvailableCheckDelay = 1000;
    private Encoding encoding;
    private Writer encodingWriter;
    private long maxResultBuffer = -1L;
    private long resultBufferByteCount = 0L;
    private int maxRowSizeBytes = -1;

    public boolean isGssEncrypted() {
        return this.gssEncrypted;
    }

    public void setSecContext(GSSContext gSSContext) {
        MessageProp messageProp = new MessageProp(0, true);
        this.pgInput = new VisibleBufferedInputStream(new GSSInputStream(this.pgInput.getWrapped(), gSSContext, messageProp), 8192);
        this.pgOutput = new GSSOutputStream(this.pgOutput, gSSContext, messageProp, 16384);
        this.gssEncrypted = true;
    }

    public PGStream(SocketFactory socketFactory, HostSpec hostSpec, int n) {
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        Socket socket = this.createSocket(n);
        this.changeSocket(socket);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
        this.int2Buf = new byte[2];
        this.int4Buf = new byte[4];
    }

    public PGStream(PGStream pGStream, int n) {
        int n2 = 1024;
        int n3 = 1024;
        int n4 = 0;
        boolean bl = false;
        try {
            n2 = pGStream.getSocket().getSendBufferSize();
            n3 = pGStream.getSocket().getReceiveBufferSize();
            n4 = pGStream.getSocket().getSoTimeout();
            bl = pGStream.getSocket().getKeepAlive();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        pGStream.close();
        this.socketFactory = pGStream.socketFactory;
        this.hostSpec = pGStream.hostSpec;
        Socket socket = this.createSocket(n);
        this.changeSocket(socket);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
        socket.setReceiveBufferSize(n3);
        socket.setSendBufferSize(n2);
        this.setNetworkTimeout(n4);
        socket.setKeepAlive(bl);
        this.int2Buf = new byte[2];
        this.int4Buf = new byte[4];
    }

    @Deprecated
    public PGStream(SocketFactory socketFactory, HostSpec hostSpec) {
        this(socketFactory, hostSpec, 0);
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagePending() {
        boolean bl = false;
        if (this.pgInput.available() > 0) {
            return true;
        }
        long l = System.nanoTime() / 1000000L;
        if (l < this.nextStreamAvailableCheckTime && this.minStreamAvailableCheckDelay != 0) {
            return false;
        }
        int n = this.getNetworkTimeout();
        this.connection.setSoTimeout(1);
        try {
            if (!this.pgInput.ensureBytes(1, false)) {
                boolean bl2 = false;
                return bl2;
            }
            bl = this.pgInput.peek() != -1;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.connection.setSoTimeout(n);
        }
        if (!bl) {
            this.nextStreamAvailableCheckTime = l + (long)this.minStreamAvailableCheckDelay;
        }
        return bl;
    }

    public void setMinStreamAvailableCheckDelay(int n) {
        this.minStreamAvailableCheckDelay = n;
    }

    private Socket createSocket(int n) {
        Socket socket = this.socketFactory.createSocket();
        String string = this.hostSpec.getLocalSocketAddress();
        if (string != null) {
            socket.bind(new InetSocketAddress(InetAddress.getByName(string), 0));
        }
        if (!socket.isConnected()) {
            InetSocketAddress inetSocketAddress = this.hostSpec.shouldResolve() != false ? new InetSocketAddress(this.hostSpec.getHost(), this.hostSpec.getPort()) : InetSocketAddress.createUnresolved(this.hostSpec.getHost(), this.hostSpec.getPort());
            socket.connect(inetSocketAddress, n);
        }
        return socket;
    }

    public void changeSocket(Socket socket) {
        assert (this.connection != socket) : "changeSocket is called with the current socket as argument. This is a no-op, however, it re-allocates buffered streams, so refrain from excessive changeSocket calls";
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.pgInput = new VisibleBufferedInputStream(this.connection.getInputStream(), 8192);
        this.pgOutput = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        if (this.encoding != null && this.encoding.name().equals(encoding.name())) {
            return;
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream filterOutputStream = new FilterOutputStream(this.pgOutput){

            @Override
            public void flush() {
            }

            @Override
            public void close() {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(filterOutputStream);
    }

    public Writer getEncodingWriter() {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void sendChar(int n) {
        this.pgOutput.write(n);
    }

    public void sendInteger4(int n) {
        this.int4Buf[0] = (byte)(n >>> 24);
        this.int4Buf[1] = (byte)(n >>> 16);
        this.int4Buf[2] = (byte)(n >>> 8);
        this.int4Buf[3] = (byte)n;
        this.pgOutput.write(this.int4Buf);
    }

    public void sendInteger2(int n) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + n);
        }
        this.int2Buf[0] = (byte)(n >>> 8);
        this.int2Buf[1] = (byte)n;
        this.pgOutput.write(this.int2Buf);
    }

    public void send(byte[] byArray) {
        this.pgOutput.write(byArray);
    }

    public void send(byte[] byArray, int n) {
        this.send(byArray, 0, n);
    }

    public void send(byte[] byArray, int n, int n2) {
        int n3 = byArray.length - n;
        this.pgOutput.write(byArray, n, n3 < n2 ? n3 : n2);
        for (int i = n3; i < n2; ++i) {
            this.pgOutput.write(0);
        }
    }

    public void send(ByteStreamWriter byteStreamWriter) {
        final FixedLengthOutputStream fixedLengthOutputStream = new FixedLengthOutputStream(byteStreamWriter.getLength(), this.pgOutput);
        try {
            byteStreamWriter.writeTo(new ByteStreamWriter.ByteStreamTarget(){

                @Override
                public OutputStream getOutputStream() {
                    return fixedLengthOutputStream;
                }
            });
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Error writing bytes to stream", exception);
        }
        for (int i = fixedLengthOutputStream.remaining(); i > 0; --i) {
            this.pgOutput.write(0);
        }
    }

    public int peekChar() {
        int n = this.pgInput.peek();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int receiveChar() {
        int n = this.pgInput.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int receiveInteger4() {
        if (this.pgInput.read(this.int4Buf) != 4) {
            throw new EOFException();
        }
        return (this.int4Buf[0] & 0xFF) << 24 | (this.int4Buf[1] & 0xFF) << 16 | (this.int4Buf[2] & 0xFF) << 8 | this.int4Buf[3] & 0xFF;
    }

    public int receiveInteger2() {
        if (this.pgInput.read(this.int2Buf) != 2) {
            throw new EOFException();
        }
        return (this.int2Buf[0] & 0xFF) << 8 | this.int2Buf[1] & 0xFF;
    }

    public String receiveString(int n) {
        if (!this.pgInput.ensureBytes(n)) {
            throw new EOFException();
        }
        String string = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), n);
        this.pgInput.skip(n);
        return string;
    }

    public EncodingPredictor.DecodeResult receiveErrorString(int n) {
        EncodingPredictor.DecodeResult decodeResult;
        block3: {
            if (!this.pgInput.ensureBytes(n)) {
                throw new EOFException();
            }
            try {
                String string = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), n);
                decodeResult = new EncodingPredictor.DecodeResult(string, null);
            }
            catch (IOException iOException) {
                decodeResult = EncodingPredictor.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), n);
                if (decodeResult != null) break block3;
                Encoding encoding = Encoding.defaultEncoding();
                String string = encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), n);
                decodeResult = new EncodingPredictor.DecodeResult(string, encoding.name());
            }
        }
        this.pgInput.skip(n);
        return decodeResult;
    }

    public String receiveString() {
        int n = this.pgInput.scanCStringLength();
        String string = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), n - 1);
        this.pgInput.skip(n);
        return string;
    }

    public String receiveCanonicalString() {
        int n = this.pgInput.scanCStringLength();
        String string = this.encoding.decodeCanonicalized(this.pgInput.getBuffer(), this.pgInput.getIndex(), n - 1);
        this.pgInput.skip(n);
        return string;
    }

    public String receiveCanonicalStringIfPresent() {
        int n = this.pgInput.scanCStringLength();
        String string = this.encoding.decodeCanonicalizedIfPresent(this.pgInput.getBuffer(), this.pgInput.getIndex(), n - 1);
        this.pgInput.skip(n);
        return string;
    }

    public Tuple receiveTupleV3() {
        int n = this.receiveInteger4();
        int n2 = this.receiveInteger2();
        int n3 = n - 4 - 2 - 4 * n2;
        this.setMaxRowSizeBytes(n3);
        byte[][] byArrayArray = new byte[n2][];
        this.increaseByteCounter(n3);
        OutOfMemoryError outOfMemoryError = null;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.receiveInteger4();
            if (n4 == -1) continue;
            try {
                byArrayArray[i] = new byte[n4];
                this.receive(byArrayArray[i], 0, n4);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                outOfMemoryError = outOfMemoryError2;
                this.skip(n4);
            }
        }
        if (outOfMemoryError != null) {
            throw outOfMemoryError;
        }
        return new Tuple(byArrayArray);
    }

    public byte[] receive(int n) {
        byte[] byArray = new byte[n];
        this.receive(byArray, 0, n);
        return byArray;
    }

    public void receive(byte[] byArray, int n, int n2) {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.pgInput.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public void skip(int n) {
        for (long i = 0L; i < (long)n; i += this.pgInput.skip((long)n - i)) {
        }
    }

    public void sendStream(InputStream inputStream, int n) {
        int n2 = n;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (n > 0) {
            int n3;
            int n4 = n > this.streamBuffer.length ? this.streamBuffer.length : n;
            try {
                n3 = inputStream.read(this.streamBuffer, 0, n4);
                if (n3 < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", n2, n2 - n));
                }
            }
            catch (IOException iOException) {
                while (n > 0) {
                    this.send(this.streamBuffer, n4);
                    n4 = (n -= n4) > this.streamBuffer.length ? this.streamBuffer.length : n;
                }
                throw new PGBindException(iOException);
            }
            this.send(this.streamBuffer, n3);
            n -= n3;
        }
    }

    @Override
    public void flush() {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pgOutput.flush();
    }

    public void receiveEOF() {
        int n = this.pgInput.read();
        if (n < 0) {
            return;
        }
        throw new PSQLException(GT.tr("Expected an EOF from server, got: {0}", n), PSQLState.COMMUNICATION_ERROR);
    }

    @Override
    public void close() {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pgOutput.close();
        this.pgInput.close();
        this.connection.close();
    }

    public void setNetworkTimeout(int n) {
        this.connection.setSoTimeout(n);
        this.pgInput.setTimeoutRequested(n != 0);
    }

    public int getNetworkTimeout() {
        return this.connection.getSoTimeout();
    }

    public void setMaxResultBuffer(@Nullable String string) {
        this.maxResultBuffer = PGPropertyMaxResultBufferParser.parseProperty(string);
    }

    public long getMaxResultBuffer() {
        return this.maxResultBuffer;
    }

    public void setMaxRowSizeBytes(int n) {
        if (n > this.maxRowSizeBytes) {
            this.maxRowSizeBytes = n;
        }
    }

    public int getMaxRowSizeBytes() {
        return this.maxRowSizeBytes;
    }

    public void clearMaxRowSizeBytes() {
        this.maxRowSizeBytes = -1;
    }

    public void clearResultBufferCount() {
        this.resultBufferByteCount = 0L;
    }

    private void increaseByteCounter(long l) {
        if (this.maxResultBuffer != -1L) {
            this.resultBufferByteCount += l;
            if (this.resultBufferByteCount > this.maxResultBuffer) {
                throw new PSQLException(GT.tr("Result set exceeded maxResultBuffer limit. Received:  {0}; Current limit: {1}", String.valueOf(this.resultBufferByteCount), String.valueOf(this.maxResultBuffer)), PSQLState.COMMUNICATION_ERROR);
            }
        }
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }
}

