/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.ResultCursor;
import com.hm.postgresql.core.ResultHandler;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResultHandlerBase
implements ResultHandler {
    private @Nullable SQLException firstException;
    private @Nullable SQLException lastException;
    private @Nullable SQLWarning firstWarning;
    private @Nullable SQLWarning lastWarning;

    @Override
    public void handleResultRows(Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
    }

    @Override
    public void handleCommandStatus(String string, long l, long l2) {
    }

    @Override
    public void secureProgress() {
    }

    @Override
    public void handleWarning(SQLWarning sQLWarning) {
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning = sQLWarning;
            return;
        }
        SQLWarning sQLWarning2 = Nullness.castNonNull(this.lastWarning);
        sQLWarning2.setNextException(sQLWarning);
        this.lastWarning = sQLWarning;
    }

    @Override
    public void handleError(SQLException sQLException) {
        if (this.firstException == null) {
            this.firstException = this.lastException = sQLException;
            return;
        }
        Nullness.castNonNull(this.lastException).setNextException(sQLException);
        this.lastException = sQLException;
    }

    @Override
    public void handleCompletion() {
        SQLException sQLException = this.firstException;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    @Override
    public @Nullable SQLException getException() {
        return this.firstException;
    }

    @Override
    public @Nullable SQLWarning getWarning() {
        return this.firstWarning;
    }
}

