/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Version;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ServerVersion implements Version
{
    INVALID("0.0.0"),
    v8_2("8.2.0"),
    v8_3("8.3.0"),
    v8_4("8.4.0"),
    v9_0("9.0.0"),
    v9_1("9.1.0"),
    v9_2("9.2.0"),
    v9_3("9.3.0"),
    v9_4("9.4.0"),
    v9_5("9.5.0"),
    v9_6("9.6.0"),
    v10("10"),
    v11("11"),
    v12("12"),
    v13("13"),
    v14("14"),
    v15("15"),
    v16("16");

    private final int version;

    private ServerVersion(String string2) {
        this.version = ServerVersion.parseServerVersionStr(string2);
    }

    @Override
    public int getVersionNum() {
        return this.version;
    }

    public static Version from(@Nullable String string) {
        final int n = ServerVersion.parseServerVersionStr(string);
        return new Version(){

            @Override
            public int getVersionNum() {
                return n;
            }

            public boolean equals(@Nullable Object object) {
                if (object instanceof Version) {
                    return this.getVersionNum() == ((Version)object).getVersionNum();
                }
                return false;
            }

            public int hashCode() {
                return this.getVersionNum();
            }

            public String toString() {
                return Integer.toString(n);
            }
        };
    }

    static int parseServerVersionStr(@Nullable String string) {
        Number number;
        int n;
        if (string == null) {
            return 0;
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        ParsePosition parsePosition = new ParsePosition(0);
        int[] nArray = new int[3];
        for (n = 0; n < 3 && (number = (Number)numberFormat.parseObject(string, parsePosition)) != null; ++n) {
            nArray[n] = number.intValue();
            if (parsePosition.getIndex() == string.length() || string.charAt(parsePosition.getIndex()) != '.') break;
            parsePosition.setIndex(parsePosition.getIndex() + 1);
        }
        ++n;
        if (nArray[0] >= 10000) {
            if (parsePosition.getIndex() == string.length() && n == 1) {
                return nArray[0];
            }
            throw new NumberFormatException("First major-version part equal to or greater than 10000 in invalid version string: " + string);
        }
        if (n >= 3) {
            if (nArray[1] > 99) {
                throw new NumberFormatException("Unsupported second part of major version > 99 in invalid version string: " + string);
            }
            if (nArray[2] > 99) {
                throw new NumberFormatException("Unsupported second part of minor version > 99 in invalid version string: " + string);
            }
            return (nArray[0] * 100 + nArray[1]) * 100 + nArray[2];
        }
        if (n == 2) {
            if (nArray[0] >= 10) {
                return nArray[0] * 100 * 100 + nArray[1];
            }
            if (nArray[1] > 99) {
                throw new NumberFormatException("Unsupported second part of major version > 99 in invalid version string: " + string);
            }
            return (nArray[0] * 100 + nArray[1]) * 100;
        }
        if (n == 1 && nArray[0] >= 10) {
            return nArray[0] * 100 * 100;
        }
        return 0;
    }
}

