/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.ssl.LibPQFactory;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.ObjectFactory;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties properties) {
        String string = PGProperty.SOCKET_FACTORY.get(properties);
        if (string == null) {
            return SocketFactory.getDefault();
        }
        try {
            return (SocketFactory)ObjectFactory.instantiate(string, properties, true, PGProperty.SOCKET_FACTORY_ARG.get(properties));
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties properties) {
        String string = PGProperty.SSL_FACTORY.get(properties);
        if (string == null || "com.hm.postgresql.ssl.jdbc4.LibPQFactory".equals(string) || "com.hm.postgresql.ssl.LibPQFactory".equals(string)) {
            return new LibPQFactory(properties);
        }
        try {
            return (SSLSocketFactory)ObjectFactory.instantiate(string, properties, true, PGProperty.SSL_FACTORY_ARG.get(properties));
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
        }
    }
}

