/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class Tuple {
    private final boolean forUpdate;
    final byte[] @Nullable [] data;

    public Tuple(int n) {
        this(new byte[n][], true);
    }

    public Tuple(byte[] @Nullable [] byArray) {
        this(byArray, false);
    }

    private Tuple(byte[] @Nullable [] byArray, boolean bl) {
        this.data = byArray;
        this.forUpdate = bl;
    }

    public @NonNegative int fieldCount() {
        return this.data.length;
    }

    public @NonNegative int length() {
        int n = 0;
        for (byte[] byArray : this.data) {
            if (byArray == null) continue;
            n += byArray.length;
        }
        return n;
    }

    @Pure
    public byte @Nullable [] get(@NonNegative int n) {
        return this.data[n];
    }

    public Tuple updateableCopy() {
        return this.copy(true);
    }

    public Tuple readOnlyCopy() {
        return this.copy(false);
    }

    private Tuple copy(boolean bl) {
        byte[][] byArrayArray = new byte[this.data.length][];
        System.arraycopy(this.data, 0, byArrayArray, 0, this.data.length);
        return new Tuple(byArrayArray, bl);
    }

    public void set(@NonNegative int n, byte @Nullable [] byArray) {
        if (!this.forUpdate) {
            throw new IllegalArgumentException("Attempted to write to readonly tuple");
        }
        this.data[n] = byArray;
    }
}

