/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Utils {
    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString(by >> 4 & 0xF));
            stringBuilder.append(Integer.toHexString(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static StringBuilder escapeLiteral(@Nullable StringBuilder stringBuilder, String string, boolean bl) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder((string.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedLiteral(stringBuilder, string, bl);
        return stringBuilder;
    }

    private static void doAppendEscapedLiteral(Appendable appendable, String string, boolean bl) {
        try {
            if (bl) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\u0000') {
                        throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (c == '\'') {
                        appendable.append('\'');
                    }
                    appendable.append(c);
                }
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\u0000') {
                        throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (c == '\\' || c == '\'') {
                        appendable.append(c);
                    }
                    appendable.append(c);
                }
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    public static StringBuilder escapeIdentifier(@Nullable StringBuilder stringBuilder, String string) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(2 + (string.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedIdentifier(stringBuilder, string);
        return stringBuilder;
    }

    private static void doAppendEscapedIdentifier(Appendable appendable, String string) {
        try {
            appendable.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in identifiers.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (c == '\"') {
                    appendable.append(c);
                }
                appendable.append(c);
            }
            appendable.append('\"');
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    @Deprecated
    public static int parseServerVersionStr(@Nullable String string) {
        return ServerVersion.parseServerVersionStr(string);
    }
}

