/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import java.io.EOFException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class VisibleBufferedInputStream
extends InputStream {
    private static final int MINIMUM_READ = 1024;
    private static final int STRING_SCAN_SPAN = 1024;
    private final InputStream wrapped;
    private byte[] buffer;
    private int index;
    private int endIndex;
    private boolean timeoutRequested = false;

    public VisibleBufferedInputStream(InputStream inputStream, int n) {
        this.wrapped = inputStream;
        this.buffer = new byte[n < 1024 ? 1024 : n];
    }

    @Override
    public int read() {
        if (this.ensureBytes(1)) {
            return this.buffer[this.index++] & 0xFF;
        }
        return -1;
    }

    public int peek() {
        if (this.ensureBytes(1)) {
            return this.buffer[this.index] & 0xFF;
        }
        return -1;
    }

    public byte readRaw() {
        return this.buffer[this.index++];
    }

    public boolean ensureBytes(int n) {
        return this.ensureBytes(n, true);
    }

    public boolean ensureBytes(int n, boolean bl) {
        int n2 = n - this.endIndex + this.index;
        while (n2 > 0) {
            if (!this.readMore(n2, bl)) {
                return false;
            }
            n2 = n - this.endIndex + this.index;
        }
        return true;
    }

    private boolean readMore(int n, boolean bl) {
        int n2;
        block9: {
            int n3;
            if (this.endIndex == this.index) {
                this.index = 0;
                this.endIndex = 0;
            }
            if ((n3 = this.buffer.length - this.endIndex) < n) {
                if (this.index + n3 > n + 1024) {
                    this.compact();
                } else {
                    this.doubleBuffer();
                }
                n3 = this.buffer.length - this.endIndex;
            }
            n2 = 0;
            try {
                n2 = this.wrapped.read(this.buffer, this.endIndex, n3);
                if (!bl && n2 == 0) {
                    return false;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (!bl) {
                    return false;
                }
                if (!this.timeoutRequested) break block9;
                throw socketTimeoutException;
            }
        }
        if (n2 < 0) {
            return false;
        }
        this.endIndex += n2;
        return true;
    }

    private void doubleBuffer() {
        byte[] byArray = new byte[this.buffer.length * 2];
        this.moveBufferTo(byArray);
        this.buffer = byArray;
    }

    private void compact() {
        this.moveBufferTo(this.buffer);
    }

    private void moveBufferTo(byte[] byArray) {
        int n = this.endIndex - this.index;
        System.arraycopy(this.buffer, this.index, byArray, 0, n);
        this.index = 0;
        this.endIndex = n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.endIndex - this.index;
        if (n2 - n4 < 1024) {
            this.ensureBytes(n2);
            n4 = this.endIndex - this.index;
        }
        if (n4 > 0) {
            if (n2 <= n4) {
                System.arraycopy(this.buffer, this.index, byArray, n, n2);
                this.index += n2;
                return n2;
            }
            System.arraycopy(this.buffer, this.index, byArray, n, n4);
            n2 -= n4;
            n += n4;
        }
        int n5 = n4;
        this.index = 0;
        this.endIndex = 0;
        do {
            try {
                n3 = this.wrapped.read(byArray, n, n2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n5 == 0 && this.timeoutRequested) {
                    throw socketTimeoutException;
                }
                return n5;
            }
            if (n3 <= 0) {
                return n5 == 0 ? n3 : n5;
            }
            n5 += n3;
            n += n3;
        } while ((n2 -= n3) > 0);
        return n5;
    }

    @Override
    public long skip(long l) {
        int n = this.endIndex - this.index;
        if ((long)n >= l) {
            this.index = (int)((long)this.index + l);
            return l;
        }
        this.index = 0;
        this.endIndex = 0;
        return (long)n + this.wrapped.skip(l -= (long)n);
    }

    @Override
    public int available() {
        int n = this.endIndex - this.index;
        return n > 0 ? n : this.wrapped.available();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getIndex() {
        return this.index;
    }

    public int scanCStringLength() {
        int n = this.index;
        while (true) {
            if (n < this.endIndex) {
                if (this.buffer[n++] != 0) continue;
                return n - this.index;
            }
            if (!this.readMore(1024, true)) {
                throw new EOFException();
            }
            n = this.index;
        }
    }

    public void setTimeoutRequested(boolean bl) {
        this.timeoutRequested = bl;
    }

    public InputStream getWrapped() {
        return this.wrapped;
    }
}

