/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.v3.SimpleParameterList;
import com.hm.postgresql.core.v3.V3ParameterList;
import com.hm.postgresql.util.ByteStreamWriter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.InputStream;
import java.sql.SQLException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;

class CompositeParameterList
implements V3ParameterList {
    private final @Positive int total;
    private final SimpleParameterList[] subparams;
    private final int[] offsets;

    CompositeParameterList(SimpleParameterList[] simpleParameterListArray, int[] nArray) {
        this.subparams = simpleParameterListArray;
        this.offsets = nArray;
        this.total = nArray[nArray.length - 1] + simpleParameterListArray[nArray.length - 1].getInParameterCount();
    }

    private int findSubParam(@Positive int n) {
        if (n < 1 || n > this.total) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", n, this.total), PSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i = this.offsets.length - 1; i >= 0; --i) {
            if (this.offsets[i] >= n) continue;
            return i;
        }
        throw new IllegalArgumentException("I am confused; can't find a subparam for index " + n);
    }

    @Override
    public void registerOutParameter(@Positive int n, int n2) {
    }

    public int getDirection(int n) {
        return 0;
    }

    @Override
    public @NonNegative int getParameterCount() {
        return this.total;
    }

    @Override
    public @NonNegative int getInParameterCount() {
        return this.total;
    }

    @Override
    public @NonNegative int getOutParameterCount() {
        return 0;
    }

    @Override
    public int[] getTypeOIDs() {
        int[] nArray = new int[this.total];
        for (int i = 0; i < this.offsets.length; ++i) {
            int[] nArray2 = this.subparams[i].getTypeOIDs();
            System.arraycopy(nArray2, 0, nArray, this.offsets[i], nArray2.length);
        }
        return nArray;
    }

    @Override
    public void setIntParameter(@Positive int n, int n2) {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setIntParameter(n - this.offsets[n3], n2);
    }

    @Override
    public void setLiteralParameter(@Positive int n, String string, int n2) {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setStringParameter(n - this.offsets[n3], string, n2);
    }

    @Override
    public void setStringParameter(@Positive int n, String string, int n2) {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setStringParameter(n - this.offsets[n3], string, n2);
    }

    @Override
    public void setBinaryParameter(@Positive int n, byte[] byArray, int n2) {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setBinaryParameter(n - this.offsets[n3], byArray, n2);
    }

    @Override
    public void setBytea(@Positive int n, byte[] byArray, int n2, @NonNegative int n3) {
        int n4 = this.findSubParam(n);
        this.subparams[n4].setBytea(n - this.offsets[n4], byArray, n2, n3);
    }

    @Override
    public void setBytea(@Positive int n, InputStream inputStream, @NonNegative int n2) {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setBytea(n - this.offsets[n3], inputStream, n2);
    }

    @Override
    public void setBytea(@Positive int n, InputStream inputStream) {
        int n2 = this.findSubParam(n);
        this.subparams[n2].setBytea(n - this.offsets[n2], inputStream);
    }

    @Override
    public void setBytea(@Positive int n, ByteStreamWriter byteStreamWriter) {
        int n2 = this.findSubParam(n);
        this.subparams[n2].setBytea(n - this.offsets[n2], byteStreamWriter);
    }

    @Override
    public void setText(@Positive int n, InputStream inputStream) {
        int n2 = this.findSubParam(n);
        this.subparams[n2].setText(n - this.offsets[n2], inputStream);
    }

    @Override
    public void setNull(@Positive int n, int n2) {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setNull(n - this.offsets[n3], n2);
    }

    @Override
    public String toString(@Positive int n, boolean bl) {
        try {
            int n2 = this.findSubParam(n);
            return this.subparams[n2].toString(n - this.offsets[n2], bl);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException.getMessage());
        }
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList[] simpleParameterListArray = new SimpleParameterList[this.subparams.length];
        for (int i = 0; i < this.subparams.length; ++i) {
            simpleParameterListArray[i] = (SimpleParameterList)this.subparams[i].copy();
        }
        return new CompositeParameterList(simpleParameterListArray, this.offsets);
    }

    @Override
    public void clear() {
        for (SimpleParameterList simpleParameterList : this.subparams) {
            simpleParameterList.clear();
        }
    }

    @Override
    public SimpleParameterList @Nullable [] getSubparams() {
        return this.subparams;
    }

    @Override
    public void checkAllParametersSet() {
        for (SimpleParameterList simpleParameterList : this.subparams) {
            simpleParameterList.checkAllParametersSet();
        }
    }

    @Override
    public byte @Nullable [][] getEncoding() {
        return null;
    }

    @Override
    public byte @Nullable [] getFlags() {
        return null;
    }

    @Override
    public int @Nullable [] getParamTypes() {
        return null;
    }

    @Override
    public @Nullable Object @Nullable [] getValues() {
        return null;
    }

    @Override
    public void appendAll(ParameterList parameterList) {
    }

    @Override
    public void convertFunctionOutParameters() {
        for (SimpleParameterList simpleParameterList : this.subparams) {
            simpleParameterList.convertFunctionOutParameters();
        }
    }
}

