/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.SqlCommand;
import com.hm.postgresql.core.v3.CompositeParameterList;
import com.hm.postgresql.core.v3.SimpleParameterList;
import com.hm.postgresql.core.v3.SimpleQuery;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

class CompositeQuery
implements Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] simpleQueryArray, int[] nArray) {
        this.subqueries = simpleQueryArray;
        this.offsets = nArray;
    }

    @Override
    public ParameterList createParameterList() {
        SimpleParameterList[] simpleParameterListArray = new SimpleParameterList[this.subqueries.length];
        for (int i = 0; i < this.subqueries.length; ++i) {
            simpleParameterListArray[i] = (SimpleParameterList)this.subqueries[i].createParameterList();
        }
        return new CompositeParameterList(simpleParameterListArray, this.offsets);
    }

    @Override
    public String toString(@Nullable ParameterList parameterList) {
        StringBuilder stringBuilder = new StringBuilder(this.subqueries[0].toString());
        for (int i = 1; i < this.subqueries.length; ++i) {
            stringBuilder.append(';');
            stringBuilder.append(this.subqueries[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getNativeSql() {
        StringBuilder stringBuilder = new StringBuilder(this.subqueries[0].getNativeSql());
        for (int i = 1; i < this.subqueries.length; ++i) {
            stringBuilder.append(';');
            stringBuilder.append(this.subqueries[i].getNativeSql());
        }
        return stringBuilder.toString();
    }

    @Override
    public @Nullable SqlCommand getSqlCommand() {
        return null;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        for (SimpleQuery simpleQuery : this.subqueries) {
            simpleQuery.close();
        }
    }

    @Override
    public Query[] getSubqueries() {
        return this.subqueries;
    }

    @Override
    public boolean isStatementDescribed() {
        for (SimpleQuery simpleQuery : this.subqueries) {
            if (simpleQuery.isStatementDescribed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (SimpleQuery simpleQuery : this.subqueries) {
            if (simpleQuery.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBatchSize() {
        return 0;
    }

    @Override
    public @Nullable Map<String, Integer> getResultSetColumnNameIndexMap() {
        return null;
    }
}

