/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.copy.CopyOperation;
import com.hm.postgresql.core.v3.QueryExecutorImpl;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CopyOperationImpl
implements CopyOperation {
    @Nullable QueryExecutorImpl queryExecutor;
    int rowFormat;
    int @Nullable [] fieldFormats;
    long handledRowCount = -1L;

    void init(QueryExecutorImpl queryExecutorImpl, int n, int[] nArray) {
        this.queryExecutor = queryExecutorImpl;
        this.rowFormat = n;
        this.fieldFormats = nArray;
    }

    protected QueryExecutorImpl getQueryExecutor() {
        return Nullness.castNonNull(this.queryExecutor);
    }

    @Override
    public void cancelCopy() {
        Nullness.castNonNull(this.queryExecutor).cancelCopy(this);
    }

    @Override
    public int getFieldCount() {
        return Nullness.castNonNull(this.fieldFormats).length;
    }

    @Override
    public int getFieldFormat(int n) {
        return Nullness.castNonNull(this.fieldFormats)[n];
    }

    @Override
    public int getFormat() {
        return this.rowFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        QueryExecutorImpl queryExecutorImpl = Nullness.castNonNull(this.queryExecutor);
        synchronized (queryExecutorImpl) {
            return this.queryExecutor.hasLock(this);
        }
    }

    public void handleCommandStatus(String string) {
        if (!string.startsWith("COPY")) {
            throw new PSQLException(GT.tr("CommandComplete expected COPY but got: " + string, new Object[0]), PSQLState.COMMUNICATION_ERROR);
        }
        int n = string.lastIndexOf(32);
        this.handledRowCount = n > 3 ? Long.parseLong(string.substring(n + 1)) : -1L;
    }

    protected abstract void handleCopydata(byte[] var1);

    @Override
    public long getHandledRowCount() {
        return this.handledRowCount;
    }
}

