/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.copy.CopyIn;
import com.hm.postgresql.copy.CopyOperation;
import com.hm.postgresql.copy.CopyOut;
import com.hm.postgresql.core.CommandCompleteParser;
import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.core.EncodingPredictor;
import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.NativeQuery;
import com.hm.postgresql.core.Notification;
import com.hm.postgresql.core.Oid;
import com.hm.postgresql.core.PGBindException;
import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Parser;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.QueryExecutorBase;
import com.hm.postgresql.core.ReplicationProtocol;
import com.hm.postgresql.core.ResultCursor;
import com.hm.postgresql.core.ResultHandler;
import com.hm.postgresql.core.ResultHandlerBase;
import com.hm.postgresql.core.ResultHandlerDelegate;
import com.hm.postgresql.core.SqlCommand;
import com.hm.postgresql.core.SqlCommandType;
import com.hm.postgresql.core.TransactionState;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.core.v3.BatchedQuery;
import com.hm.postgresql.core.v3.CompositeQuery;
import com.hm.postgresql.core.v3.CopyDualImpl;
import com.hm.postgresql.core.v3.CopyInImpl;
import com.hm.postgresql.core.v3.CopyOperationImpl;
import com.hm.postgresql.core.v3.CopyOutImpl;
import com.hm.postgresql.core.v3.DescribeRequest;
import com.hm.postgresql.core.v3.ExecuteRequest;
import com.hm.postgresql.core.v3.Portal;
import com.hm.postgresql.core.v3.SimpleParameterList;
import com.hm.postgresql.core.v3.SimpleQuery;
import com.hm.postgresql.core.v3.V3ParameterList;
import com.hm.postgresql.core.v3.adaptivefetch.AdaptiveFetchCache;
import com.hm.postgresql.core.v3.replication.V3ReplicationProtocol;
import com.hm.postgresql.jdbc.AutoSave;
import com.hm.postgresql.jdbc.BatchResultHandler;
import com.hm.postgresql.jdbc.TimestampUtils;
import com.hm.postgresql.util.ByteStreamWriter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.PSQLWarning;
import com.hm.postgresql.util.ServerErrorMessage;
import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class QueryExecutorImpl
extends QueryExecutorBase {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutorImpl.class.getName());
    private static final Field[] NO_FIELDS = new Field[0];
    private @Nullable TimeZone timeZone;
    private @Nullable String applicationName;
    private boolean integerDateTimes;
    private final Set<Integer> useBinaryReceiveForOids = new HashSet<Integer>();
    private final Set<Integer> useBinarySendForOids = new HashSet<Integer>();
    private final SimpleQuery sync;
    private short deallocateEpoch;
    private @Nullable String lastSetSearchPathQuery;
    private @Nullable SQLException transactionFailCause;
    private final ReplicationProtocol replicationProtocol;
    private final CommandCompleteParser commandCompleteParser;
    private final AdaptiveFetchCache adaptiveFetchCache;
    private @Nullable Object lockedFor;
    private static final int MAX_BUFFERED_RECV_BYTES = 64000;
    private static final int NODATA_QUERY_RESPONSE_SIZE_BYTES = 250;
    AtomicBoolean processingCopyResults;
    private final HashMap<PhantomReference<SimpleQuery>, String> parsedQueryMap;
    private final ReferenceQueue<SimpleQuery> parsedQueryCleanupQueue;
    private final HashMap<PhantomReference<Portal>, String> openPortalMap;
    private final ReferenceQueue<Portal> openPortalCleanupQueue;
    private static final Portal UNNAMED_PORTAL;
    private final Deque<SimpleQuery> pendingParseQueue;
    private final Deque<Portal> pendingBindQueue;
    private final Deque<ExecuteRequest> pendingExecuteQueue;
    private final Deque<DescribeRequest> pendingDescribeStatementQueue;
    private final Deque<SimpleQuery> pendingDescribePortalQueue;
    private long nextUniqueID;
    private final boolean allowEncodingChanges;
    private final boolean cleanupSavePoints;
    private int estimatedReceiveBufferBytes;
    private final SimpleQuery beginTransactionQuery;
    private final SimpleQuery beginReadOnlyTransactionQuery;
    private final SimpleQuery emptyQuery;
    private final SimpleQuery autoSaveQuery;
    private final SimpleQuery releaseAutoSave;
    private final SimpleQuery restoreToAutoSave;

    public QueryExecutorImpl(PGStream pGStream, String string, String string2, int n, Properties properties) {
        super(pGStream, string, string2, n, properties);
        this.sync = (SimpleQuery)this.createQuery((String)"SYNC", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.commandCompleteParser = new CommandCompleteParser();
        this.processingCopyResults = new AtomicBoolean(false);
        this.parsedQueryMap = new HashMap();
        this.parsedQueryCleanupQueue = new ReferenceQueue();
        this.openPortalMap = new HashMap();
        this.openPortalCleanupQueue = new ReferenceQueue();
        this.pendingParseQueue = new ArrayDeque<SimpleQuery>();
        this.pendingBindQueue = new ArrayDeque<Portal>();
        this.pendingExecuteQueue = new ArrayDeque<ExecuteRequest>();
        this.pendingDescribeStatementQueue = new ArrayDeque<DescribeRequest>();
        this.pendingDescribePortalQueue = new ArrayDeque<SimpleQuery>();
        this.nextUniqueID = 1L;
        this.estimatedReceiveBufferBytes = 0;
        this.beginTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN", new int[0], false, SqlCommand.BLANK), null, false);
        this.beginReadOnlyTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN READ ONLY", new int[0], false, SqlCommand.BLANK), null, false);
        this.emptyQuery = new SimpleQuery(new NativeQuery("", new int[0], false, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)), null, false);
        this.autoSaveQuery = new SimpleQuery(new NativeQuery("SAVEPOINT PGJDBC_AUTOSAVE", new int[0], false, SqlCommand.BLANK), null, false);
        this.releaseAutoSave = new SimpleQuery(new NativeQuery("RELEASE SAVEPOINT PGJDBC_AUTOSAVE", new int[0], false, SqlCommand.BLANK), null, false);
        this.restoreToAutoSave = new SimpleQuery(new NativeQuery("ROLLBACK TO SAVEPOINT PGJDBC_AUTOSAVE", new int[0], false, SqlCommand.BLANK), null, false);
        long l = pGStream.getMaxResultBuffer();
        this.adaptiveFetchCache = new AdaptiveFetchCache(l, properties);
        this.allowEncodingChanges = PGProperty.ALLOW_ENCODING_CHANGES.getBoolean(properties);
        this.cleanupSavePoints = PGProperty.CLEANUP_SAVEPOINTS.getBoolean(properties);
        this.replicationProtocol = new V3ReplicationProtocol(this, pGStream);
        this.readStartupMessages();
    }

    @Override
    public int getProtocolVersion() {
        return 3;
    }

    private void lock(Object object) {
        if (this.lockedFor == object) {
            throw new PSQLException(GT.tr("Tried to obtain lock while already holding it", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.waitOnLock();
        this.lockedFor = object;
    }

    private void unlock(Object object) {
        if (this.lockedFor != object) {
            throw new PSQLException(GT.tr("Tried to break lock on database connection", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.lockedFor = null;
        this.notify();
    }

    private void waitOnLock() {
        while (this.lockedFor != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new PSQLException(GT.tr("Interrupted while waiting to obtain lock on database connection", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE, (Throwable)interruptedException);
            }
        }
    }

    boolean hasLock(@Nullable Object object) {
        return this.lockedFor == object;
    }

    @Override
    public Query createSimpleQuery(String string) {
        List<NativeQuery> list = Parser.parseJdbcSql(string, this.getStandardConformingStrings(), false, true, this.isReWriteBatchedInsertsEnabled(), this.getQuoteReturningIdentifiers(), new String[0]);
        return this.wrap(list);
    }

    @Override
    public Query wrap(List<NativeQuery> list) {
        if (list.isEmpty()) {
            return this.emptyQuery;
        }
        if (list.size() == 1) {
            NativeQuery nativeQuery = list.get(0);
            if (this.isReWriteBatchedInsertsEnabled() && nativeQuery.getCommand().isBatchedReWriteCompatible()) {
                int n = nativeQuery.getCommand().getBatchRewriteValuesBraceOpenPosition();
                int n2 = nativeQuery.getCommand().getBatchRewriteValuesBraceClosePosition();
                return new BatchedQuery(nativeQuery, this, n, n2, this.isColumnSanitiserDisabled());
            }
            return new SimpleQuery(nativeQuery, this, this.isColumnSanitiserDisabled());
        }
        SimpleQuery[] simpleQueryArray = new SimpleQuery[list.size()];
        int[] nArray = new int[simpleQueryArray.length];
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            NativeQuery nativeQuery = list.get(i);
            nArray[i] = n;
            simpleQueryArray[i] = new SimpleQuery(nativeQuery, this, this.isColumnSanitiserDisabled());
            n += nativeQuery.bindPositions.length;
        }
        return new CompositeQuery(simpleQueryArray, nArray);
    }

    private int updateQueryMode(int n) {
        switch (this.getPreferQueryMode()) {
            case SIMPLE: {
                return n | 0x400;
            }
            case EXTENDED: {
                return n & 0xFFFFFBFF;
            }
        }
        return n;
    }

    @Override
    public synchronized void execute(Query query, @Nullable ParameterList parameterList, ResultHandler resultHandler, int n, int n2, int n3) {
        this.execute(query, parameterList, resultHandler, n, n2, n3, false);
    }

    @Override
    public synchronized void execute(Query query, @Nullable ParameterList parameterList, ResultHandler resultHandler, int n, int n2, int n3, boolean bl) {
        this.waitOnLock();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "  simple execute, handler={0}, maxRows={1}, fetchSize={2}, flags={3}", new Object[]{resultHandler, n, n2, n3});
        }
        if (parameterList == null) {
            parameterList = SimpleQuery.NO_PARAMETERS;
        }
        boolean bl2 = (0x20 & (n3 = this.updateQueryMode(n3))) != 0;
        ((V3ParameterList)parameterList).convertFunctionOutParameters();
        if (!bl2) {
            ((V3ParameterList)parameterList).checkAllParametersSet();
        }
        boolean bl3 = false;
        try {
            try {
                resultHandler = this.sendQueryPreamble(resultHandler, n3);
                bl3 = this.sendAutomaticSavepoint(query, n3);
                this.sendQuery(query, (V3ParameterList)parameterList, n, n2, n3, resultHandler, null, bl);
                if ((n3 & 0x400) == 0) {
                    this.sendSync();
                }
                this.processResults(resultHandler, n3, bl);
                this.estimatedReceiveBufferBytes = 0;
            }
            catch (PGBindException pGBindException) {
                this.sendSync();
                this.processResults(resultHandler, n3, bl);
                this.estimatedReceiveBufferBytes = 0;
                resultHandler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)pGBindException.getIOException()));
            }
        }
        catch (IOException iOException) {
            this.abort();
            resultHandler.handleError(new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
        }
        try {
            resultHandler.handleCompletion();
            if (this.cleanupSavePoints) {
                this.releaseSavePoint(bl3, n3);
            }
        }
        catch (SQLException sQLException) {
            this.rollbackIfRequired(bl3, sQLException);
        }
    }

    private boolean sendAutomaticSavepoint(Query query, int n) {
        if (!((n & 0x10) != 0 && this.getTransactionState() != TransactionState.OPEN || query == this.restoreToAutoSave || query.getNativeSql().equalsIgnoreCase("COMMIT") || this.getAutoSave() == AutoSave.NEVER || this.getAutoSave() != AutoSave.ALWAYS && query instanceof SimpleQuery && ((SimpleQuery)query).getFields() == null)) {
            this.sendOneQuery(this.autoSaveQuery, SimpleQuery.NO_PARAMETERS, 1, 0, 1030);
            return true;
        }
        return false;
    }

    private void releaseSavePoint(boolean bl, int n) {
        if (bl && this.getAutoSave() == AutoSave.ALWAYS && this.getTransactionState() == TransactionState.OPEN) {
            try {
                this.sendOneQuery(this.releaseAutoSave, SimpleQuery.NO_PARAMETERS, 1, 0, 1030);
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("Error releasing savepoint", new Object[0]), PSQLState.IO_ERROR);
            }
        }
    }

    private void rollbackIfRequired(boolean bl, SQLException sQLException) {
        if (bl && this.getTransactionState() == TransactionState.FAILED && (this.getAutoSave() == AutoSave.ALWAYS || this.willHealOnRetry(sQLException))) {
            try {
                this.execute(this.restoreToAutoSave, SimpleQuery.NO_PARAMETERS, new ResultHandlerDelegate(null), 1, 0, 1030);
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
        }
        throw sQLException;
    }

    @Override
    public synchronized void execute(Query[] queryArray, @Nullable ParameterList[] parameterListArray, BatchResultHandler batchResultHandler, int n, int n2, int n3) {
        this.execute(queryArray, parameterListArray, batchResultHandler, n, n2, n3, false);
    }

    @Override
    public synchronized void execute(Query[] queryArray, @Nullable ParameterList[] parameterListArray, BatchResultHandler batchResultHandler, int n, int n2, int n3, boolean bl) {
        Object object;
        int n4;
        boolean bl2;
        this.waitOnLock();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "  batch execute {0} queries, handler={1}, maxRows={2}, fetchSize={3}, flags={4}", new Object[]{queryArray.length, batchResultHandler, n, n2, n3});
        }
        boolean bl3 = bl2 = (0x20 & (n3 = this.updateQueryMode(n3))) != 0;
        if (!bl2) {
            ParameterList[] parameterListArray2 = parameterListArray;
            int n5 = parameterListArray2.length;
            for (n4 = 0; n4 < n5; ++n4) {
                object = parameterListArray2[n4];
                if (object == null) continue;
                ((V3ParameterList)object).checkAllParametersSet();
            }
        }
        boolean bl4 = false;
        ResultHandler resultHandler = batchResultHandler;
        try {
            resultHandler = this.sendQueryPreamble(batchResultHandler, n3);
            bl4 = this.sendAutomaticSavepoint(queryArray[0], n3);
            this.estimatedReceiveBufferBytes = 0;
            for (n4 = 0; n4 < queryArray.length; ++n4) {
                object = queryArray[n4];
                V3ParameterList v3ParameterList = (V3ParameterList)parameterListArray[n4];
                if (v3ParameterList == null) {
                    v3ParameterList = SimpleQuery.NO_PARAMETERS;
                }
                this.sendQuery((Query)object, v3ParameterList, n, n2, n3, resultHandler, batchResultHandler, bl);
                if (resultHandler.getException() != null) break;
            }
            if (resultHandler.getException() == null) {
                if ((n3 & 0x400) == 0) {
                    this.sendSync();
                }
                this.processResults(resultHandler, n3, bl);
                this.estimatedReceiveBufferBytes = 0;
            }
        }
        catch (IOException iOException) {
            this.abort();
            resultHandler.handleError(new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
        }
        try {
            resultHandler.handleCompletion();
            if (this.cleanupSavePoints) {
                this.releaseSavePoint(bl4, n3);
            }
        }
        catch (SQLException sQLException) {
            this.rollbackIfRequired(bl4, sQLException);
        }
    }

    private ResultHandler sendQueryPreamble(ResultHandler resultHandler, int n) {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((n & 0x10) != 0 || this.getTransactionState() != TransactionState.IDLE) {
            return resultHandler;
        }
        int n2 = 2;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        n2 |= 0x400;
        n2 = this.updateQueryMode(n2);
        SimpleQuery simpleQuery = (n & 0x800) == 0 ? this.beginTransactionQuery : this.beginReadOnlyTransactionQuery;
        this.sendOneQuery(simpleQuery, SimpleQuery.NO_PARAMETERS, 0, 0, n2);
        return new ResultHandlerDelegate(resultHandler){
            private boolean sawBegin;
            {
                this.sawBegin = false;
            }

            @Override
            public void handleResultRows(Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
                if (this.sawBegin) {
                    super.handleResultRows(query, fieldArray, list, resultCursor);
                }
            }

            @Override
            public void handleCommandStatus(String string, long l, long l2) {
                if (!this.sawBegin) {
                    this.sawBegin = true;
                    if (!string.equals("BEGIN")) {
                        this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                    }
                } else {
                    super.handleCommandStatus(string, l, l2);
                }
            }
        };
    }

    @Override
    public synchronized byte @Nullable [] fastpathCall(int n, ParameterList parameterList, boolean bl) {
        this.waitOnLock();
        if (!bl) {
            this.doSubprotocolBegin();
        }
        try {
            this.sendFastpathCall(n, (SimpleParameterList)parameterList);
            return this.receiveFastpathResult();
        }
        catch (IOException iOException) {
            this.abort();
            throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    public void doSubprotocolBegin() {
        if (this.getTransactionState() == TransactionState.IDLE) {
            LOGGER.log(Level.FINEST, "Issuing BEGIN before fastpath or copy call.");
            ResultHandlerBase resultHandlerBase = new ResultHandlerBase(){
                private boolean sawBegin = false;

                @Override
                public void handleCommandStatus(String string, long l, long l2) {
                    if (!this.sawBegin) {
                        if (!string.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                @Override
                public void handleWarning(SQLWarning sQLWarning) {
                    this.handleError(sQLWarning);
                }
            };
            try {
                int n = 1027;
                n = this.updateQueryMode(n);
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, n);
                this.sendSync();
                this.processResults(resultHandlerBase, 0);
                this.estimatedReceiveBufferBytes = 0;
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
            }
        }
    }

    @Override
    public ParameterList createFastpathParameters(int n) {
        return new SimpleParameterList(n, this);
    }

    private void sendFastpathCall(int n, SimpleParameterList simpleParameterList) {
        int n2;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " FE=> FunctionCall({0}, {1} params)", new Object[]{n, simpleParameterList.getParameterCount()});
        }
        int n3 = simpleParameterList.getParameterCount();
        int n4 = 0;
        for (n2 = 1; n2 <= n3; ++n2) {
            if (simpleParameterList.isNull(n2)) {
                n4 += 4;
                continue;
            }
            n4 += 4 + simpleParameterList.getV3Length(n2);
        }
        this.pgStream.sendChar(70);
        this.pgStream.sendInteger4(10 + 2 * n3 + 2 + n4 + 2);
        this.pgStream.sendInteger4(n);
        this.pgStream.sendInteger2(n3);
        for (n2 = 1; n2 <= n3; ++n2) {
            this.pgStream.sendInteger2(simpleParameterList.isBinary(n2) ? 1 : 0);
        }
        this.pgStream.sendInteger2(n3);
        for (n2 = 1; n2 <= n3; ++n2) {
            if (simpleParameterList.isNull(n2)) {
                this.pgStream.sendInteger4(-1);
                continue;
            }
            this.pgStream.sendInteger4(simpleParameterList.getV3Length(n2));
            simpleParameterList.writeV3Value(n2, this.pgStream);
        }
        this.pgStream.sendInteger2(1);
        this.pgStream.flush();
    }

    @Override
    public synchronized void processNotifies() {
        this.processNotifies(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void processNotifies(int n) {
        this.waitOnLock();
        if (this.getTransactionState() != TransactionState.IDLE) {
            return;
        }
        if (this.hasNotifications()) {
            n = -1;
        }
        boolean bl = n > 0;
        long l = 0L;
        int n2 = 0;
        if (bl) {
            l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            try {
                n2 = this.pgStream.getSocket().getSoTimeout();
            }
            catch (SocketException socketException) {
                throw new PSQLException(GT.tr("An error occurred while trying to get the socket timeout.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)socketException);
            }
        }
        try {
            block14: while (true) {
                if (n < 0) {
                    if (!this.pgStream.hasMessagePending()) return;
                }
                if (bl && n >= 0) {
                    this.setSocketTimeout(n);
                }
                int n3 = this.pgStream.receiveChar();
                if (bl && n >= 0) {
                    this.setSocketTimeout(0);
                }
                switch (n3) {
                    case 65: {
                        this.receiveAsyncNotify();
                        n = -1;
                        continue block14;
                    }
                    case 69: {
                        throw this.receiveErrorResponse();
                    }
                    case 78: {
                        SQLWarning sQLWarning = this.receiveNoticeResponse();
                        this.addWarning(sQLWarning);
                        if (!bl) continue block14;
                        long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                        n = (int)((long)n + (l - l2));
                        l = l2;
                        if (n != 0) continue block14;
                        n = -1;
                        continue block14;
                    }
                }
                throw new PSQLException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)n3)), PSQLState.CONNECTION_FAILURE);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return;
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
        finally {
            if (bl) {
                this.setSocketTimeout(n2);
            }
        }
    }

    private void setSocketTimeout(int n) {
        try {
            Socket socket = this.pgStream.getSocket();
            if (!socket.isClosed()) {
                this.pgStream.setNetworkTimeout(n);
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("An error occurred while trying to reset the socket timeout.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    private byte @Nullable [] receiveFastpathResult() {
        boolean bl = false;
        SQLException sQLException = null;
        byte[] byArray = null;
        block10: while (!bl) {
            int n = this.pgStream.receiveChar();
            switch (n) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block10;
                }
                case 69: {
                    SQLException sQLException2 = this.receiveErrorResponse();
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue block10;
                    }
                    sQLException.setNextException(sQLException2);
                    continue block10;
                }
                case 78: {
                    SQLWarning sQLWarning = this.receiveNoticeResponse();
                    this.addWarning(sQLWarning);
                    continue block10;
                }
                case 90: {
                    this.receiveRFQ();
                    bl = true;
                    continue block10;
                }
                case 86: {
                    int n2 = this.pgStream.receiveInteger4();
                    int n3 = this.pgStream.receiveInteger4();
                    LOGGER.log(Level.FINEST, " <=BE FunctionCallResponse({0} bytes)", n3);
                    if (n3 == -1) continue block10;
                    byte[] byArray2 = new byte[n3];
                    this.pgStream.receive(byArray2, 0, n3);
                    byArray = byArray2;
                    continue block10;
                }
                case 83: {
                    try {
                        this.receiveParameterStatus();
                    }
                    catch (SQLException sQLException3) {
                        if (sQLException == null) {
                            sQLException = sQLException3;
                        } else {
                            sQLException.setNextException(sQLException3);
                        }
                        bl = true;
                    }
                    continue block10;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)n)), PSQLState.CONNECTION_FAILURE);
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return byArray;
    }

    @Override
    public synchronized CopyOperation startCopy(String string, boolean bl) {
        this.waitOnLock();
        if (!bl) {
            this.doSubprotocolBegin();
        }
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        try {
            LOGGER.log(Level.FINEST, " FE=> Query(CopyStart)");
            this.pgStream.sendChar(81);
            this.pgStream.sendInteger4(byArray.length + 4 + 1);
            this.pgStream.send(byArray);
            this.pgStream.sendChar(0);
            this.pgStream.flush();
            return Nullness.castNonNull(this.processCopyResults(null, true));
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Database connection failed when starting copy", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    private synchronized void initCopy(CopyOperationImpl copyOperationImpl) {
        this.pgStream.receiveInteger4();
        int n = this.pgStream.receiveChar();
        int n2 = this.pgStream.receiveInteger2();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.pgStream.receiveInteger2();
        }
        this.lock(copyOperationImpl);
        copyOperationImpl.init(this, n, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCopy(CopyOperationImpl copyOperationImpl) {
        int n;
        SQLException sQLException;
        block26: {
            if (!this.hasLock(copyOperationImpl)) {
                throw new PSQLException(GT.tr("Tried to cancel an inactive copy operation", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            sQLException = null;
            n = 0;
            try {
                if (copyOperationImpl instanceof CopyIn) {
                    QueryExecutorImpl queryExecutorImpl = this;
                    synchronized (queryExecutorImpl) {
                        LOGGER.log(Level.FINEST, "FE => CopyFail");
                        byte[] byArray = "Copy cancel requested".getBytes(StandardCharsets.US_ASCII);
                        this.pgStream.sendChar(102);
                        this.pgStream.sendInteger4(5 + byArray.length);
                        this.pgStream.send(byArray);
                        this.pgStream.sendChar(0);
                        this.pgStream.flush();
                        do {
                            try {
                                this.processCopyResults(copyOperationImpl, true);
                            }
                            catch (SQLException sQLException2) {
                                ++n;
                                if (sQLException != null) {
                                    SQLException sQLException3;
                                    SQLException sQLException4 = sQLException2;
                                    while ((sQLException3 = sQLException4.getNextException()) != null) {
                                        sQLException4 = sQLException3;
                                    }
                                    sQLException4.setNextException(sQLException);
                                }
                                sQLException = sQLException2;
                            }
                        } while (this.hasLock(copyOperationImpl));
                        break block26;
                    }
                }
                if (copyOperationImpl instanceof CopyOut) {
                    this.sendQueryCancel();
                }
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("Database connection failed when canceling copy operation", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
            }
            finally {
                QueryExecutorImpl queryExecutorImpl = this;
                synchronized (queryExecutorImpl) {
                    if (this.hasLock(copyOperationImpl)) {
                        this.unlock(copyOperationImpl);
                    }
                }
            }
        }
        if (copyOperationImpl instanceof CopyIn) {
            if (n < 1) {
                throw new PSQLException(GT.tr("Missing expected error response to copy cancel request", new Object[0]), PSQLState.COMMUNICATION_ERROR);
            }
            if (n > 1) {
                throw new PSQLException(GT.tr("Got {0} error responses to single copy cancel request", String.valueOf(n)), PSQLState.COMMUNICATION_ERROR, sQLException);
            }
        }
    }

    public synchronized long endCopy(CopyOperationImpl copyOperationImpl) {
        if (!this.hasLock(copyOperationImpl)) {
            throw new PSQLException(GT.tr("Tried to end inactive copy", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            LOGGER.log(Level.FINEST, " FE=> CopyDone");
            this.pgStream.sendChar(99);
            this.pgStream.sendInteger4(4);
            this.pgStream.flush();
            do {
                this.processCopyResults(copyOperationImpl, true);
            } while (this.hasLock(copyOperationImpl));
            return copyOperationImpl.getHandledRowCount();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Database connection failed when ending copy", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    public synchronized void writeToCopy(CopyOperationImpl copyOperationImpl, byte[] byArray, int n, int n2) {
        if (!this.hasLock(copyOperationImpl)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        LOGGER.log(Level.FINEST, " FE=> CopyData({0})", n2);
        try {
            this.pgStream.sendChar(100);
            this.pgStream.sendInteger4(n2 + 4);
            this.pgStream.send(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    public synchronized void writeToCopy(CopyOperationImpl copyOperationImpl, ByteStreamWriter byteStreamWriter) {
        if (!this.hasLock(copyOperationImpl)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        int n = byteStreamWriter.getLength();
        LOGGER.log(Level.FINEST, " FE=> CopyData({0})", n);
        try {
            this.pgStream.sendChar(100);
            this.pgStream.sendInteger4(n + 4);
            this.pgStream.send(byteStreamWriter);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    public synchronized void flushCopy(CopyOperationImpl copyOperationImpl) {
        if (!this.hasLock(copyOperationImpl)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            this.pgStream.flush();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    synchronized void readFromCopy(CopyOperationImpl copyOperationImpl, boolean bl) {
        if (!this.hasLock(copyOperationImpl)) {
            throw new PSQLException(GT.tr("Tried to read from inactive copy", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            this.processCopyResults(copyOperationImpl, bl);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Database connection failed when reading from copy", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable CopyOperationImpl processCopyResults(@Nullable CopyOperationImpl copyOperationImpl, boolean bl) {
        if (this.pgStream.isClosed()) {
            throw new PSQLException(GT.tr("PGStream is closed", new Object[0]), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
        if (!this.processingCopyResults.compareAndSet(false, true)) {
            LOGGER.log(Level.INFO, "Ignoring request to process copy results, already processing");
            return null;
        }
        try {
            boolean bl2 = false;
            SQLException sQLException = null;
            SQLException sQLException2 = null;
            while (!bl2 && (bl || this.pgStream.hasMessagePending())) {
                int n;
                if (!bl && (n = this.pgStream.peekChar()) == 67) {
                    LOGGER.log(Level.FINEST, " <=BE CommandStatus, Ignored until CopyDone");
                    break;
                }
                n = this.pgStream.receiveChar();
                switch (n) {
                    case 65: {
                        LOGGER.log(Level.FINEST, " <=BE Asynchronous Notification while copying");
                        this.receiveAsyncNotify();
                        break;
                    }
                    case 78: {
                        LOGGER.log(Level.FINEST, " <=BE Notification while copying");
                        this.addWarning(this.receiveNoticeResponse());
                        break;
                    }
                    case 67: {
                        String string = this.receiveCommandStatus();
                        try {
                            if (copyOperationImpl == null) {
                                throw new PSQLException(GT.tr("Received CommandComplete ''{0}'' without an active copy operation", string), PSQLState.OBJECT_NOT_IN_STATE);
                            }
                            copyOperationImpl.handleCommandStatus(string);
                        }
                        catch (SQLException sQLException3) {
                            sQLException = sQLException3;
                        }
                        bl = true;
                        break;
                    }
                    case 69: {
                        sQLException = this.receiveErrorResponse();
                        bl = true;
                        break;
                    }
                    case 71: {
                        LOGGER.log(Level.FINEST, " <=BE CopyInResponse");
                        if (copyOperationImpl != null) {
                            sQLException = new PSQLException(GT.tr("Got CopyInResponse from server during an active {0}", copyOperationImpl.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                        }
                        copyOperationImpl = new CopyInImpl();
                        this.initCopy(copyOperationImpl);
                        bl2 = true;
                        break;
                    }
                    case 72: {
                        LOGGER.log(Level.FINEST, " <=BE CopyOutResponse");
                        if (copyOperationImpl != null) {
                            sQLException = new PSQLException(GT.tr("Got CopyOutResponse from server during an active {0}", copyOperationImpl.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                        }
                        copyOperationImpl = new CopyOutImpl();
                        this.initCopy(copyOperationImpl);
                        bl2 = true;
                        break;
                    }
                    case 87: {
                        LOGGER.log(Level.FINEST, " <=BE CopyBothResponse");
                        if (copyOperationImpl != null) {
                            sQLException = new PSQLException(GT.tr("Got CopyBothResponse from server during an active {0}", copyOperationImpl.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                        }
                        copyOperationImpl = new CopyDualImpl();
                        this.initCopy(copyOperationImpl);
                        bl2 = true;
                        break;
                    }
                    case 100: {
                        LOGGER.log(Level.FINEST, " <=BE CopyData");
                        int n2 = this.pgStream.receiveInteger4() - 4;
                        assert (n2 > 0) : "Copy Data length must be greater than 4";
                        byte[] byArray = this.pgStream.receive(n2);
                        if (copyOperationImpl == null) {
                            sQLException = new PSQLException(GT.tr("Got CopyData without an active copy operation", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
                        } else if (!(copyOperationImpl instanceof CopyOut)) {
                            sQLException = new PSQLException(GT.tr("Unexpected copydata from server for {0}", copyOperationImpl.getClass().getName()), PSQLState.COMMUNICATION_ERROR);
                        } else {
                            copyOperationImpl.handleCopydata(byArray);
                        }
                        bl2 = true;
                        break;
                    }
                    case 99: {
                        LOGGER.log(Level.FINEST, " <=BE CopyDone");
                        int n2 = this.pgStream.receiveInteger4() - 4;
                        if (n2 > 0) {
                            this.pgStream.receive(n2);
                        }
                        if (!(copyOperationImpl instanceof CopyOut)) {
                            sQLException = new PSQLException("Got CopyDone while not copying from server", PSQLState.OBJECT_NOT_IN_STATE);
                        }
                        bl = true;
                        break;
                    }
                    case 83: {
                        try {
                            this.receiveParameterStatus();
                        }
                        catch (SQLException sQLException4) {
                            sQLException = sQLException4;
                            bl2 = true;
                        }
                        break;
                    }
                    case 90: {
                        this.receiveRFQ();
                        if (copyOperationImpl != null && this.hasLock(copyOperationImpl)) {
                            this.unlock(copyOperationImpl);
                        }
                        copyOperationImpl = null;
                        bl2 = true;
                        break;
                    }
                    case 84: {
                        LOGGER.log(Level.FINEST, " <=BE RowDescription (during copy ignored)");
                        this.skipMessage();
                        break;
                    }
                    case 68: {
                        LOGGER.log(Level.FINEST, " <=BE DataRow (during copy ignored)");
                        this.skipMessage();
                        break;
                    }
                    default: {
                        throw new IOException(GT.tr("Unexpected packet type during copy: {0}", Integer.toString(n)));
                    }
                }
                if (sQLException == null) continue;
                if (sQLException2 != null) {
                    sQLException.setNextException(sQLException2);
                }
                sQLException2 = sQLException;
                sQLException = null;
            }
            if (sQLException2 != null) {
                throw sQLException2;
            }
            CopyOperationImpl copyOperationImpl2 = copyOperationImpl;
            return copyOperationImpl2;
        }
        finally {
            this.processingCopyResults.set(false);
        }
    }

    private void flushIfDeadlockRisk(Query query, boolean bl, ResultHandler resultHandler, @Nullable BatchResultHandler batchResultHandler, int n) {
        this.estimatedReceiveBufferBytes += 250;
        SimpleQuery simpleQuery = (SimpleQuery)query;
        if (simpleQuery.isStatementDescribed()) {
            int n2 = simpleQuery.getMaxResultRowSize();
            if (n2 >= 0) {
                this.estimatedReceiveBufferBytes += n2;
            } else {
                LOGGER.log(Level.FINEST, "Couldn't estimate result size or result size unbounded, disabling batching for this query.");
                bl = true;
            }
        }
        if (bl || this.estimatedReceiveBufferBytes >= 64000) {
            LOGGER.log(Level.FINEST, "Forcing Sync, receive buffer full or batching disallowed");
            this.sendSync();
            this.processResults(resultHandler, n);
            this.estimatedReceiveBufferBytes = 0;
            if (batchResultHandler != null) {
                batchResultHandler.secureProgress();
            }
        }
    }

    private void sendQuery(Query query, V3ParameterList v3ParameterList, int n, int n2, int n3, ResultHandler resultHandler, @Nullable BatchResultHandler batchResultHandler, boolean bl) {
        boolean bl2;
        Query[] queryArray = query.getSubqueries();
        SimpleParameterList[] simpleParameterListArray = v3ParameterList.getSubparams();
        boolean bl3 = bl2 = (n3 & 0x80) != 0;
        if (queryArray == null) {
            this.flushIfDeadlockRisk(query, bl2, resultHandler, batchResultHandler, n3);
            if (resultHandler.getException() == null) {
                if (n2 != 0) {
                    this.adaptiveFetchCache.addNewQuery(bl, query);
                }
                this.sendOneQuery((SimpleQuery)query, (SimpleParameterList)v3ParameterList, n, n2, n3);
            }
        } else {
            for (int i = 0; i < queryArray.length; ++i) {
                Query query2 = queryArray[i];
                this.flushIfDeadlockRisk(query2, bl2, resultHandler, batchResultHandler, n3);
                if (resultHandler.getException() != null) break;
                SimpleParameterList simpleParameterList = SimpleQuery.NO_PARAMETERS;
                if (simpleParameterListArray != null) {
                    simpleParameterList = simpleParameterListArray[i];
                }
                if (n2 != 0) {
                    this.adaptiveFetchCache.addNewQuery(bl, query2);
                }
                this.sendOneQuery((SimpleQuery)query2, simpleParameterList, n, n2, n3);
            }
        }
    }

    private void sendSync() {
        LOGGER.log(Level.FINEST, " FE=> Sync");
        this.pgStream.sendChar(83);
        this.pgStream.sendInteger4(4);
        this.pgStream.flush();
        this.pendingExecuteQueue.add(new ExecuteRequest(this.sync, null, true));
        this.pendingDescribePortalQueue.add(this.sync);
    }

    private void sendParse(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, boolean bl) {
        int n;
        Object object;
        int[] nArray = simpleParameterList.getTypeOIDs();
        if (simpleQuery.isPreparedFor(nArray, this.deallocateEpoch)) {
            return;
        }
        simpleQuery.unprepare();
        this.processDeadParsedQueries();
        simpleQuery.setFields(null);
        String string = null;
        if (!bl) {
            string = "S_" + this.nextUniqueID++;
            simpleQuery.setStatementName(string, this.deallocateEpoch);
            simpleQuery.setPrepareTypes(nArray);
            this.registerParsedQuery(simpleQuery, string);
        }
        byte[] byArray = simpleQuery.getEncodedStatementName();
        String string2 = simpleQuery.getNativeSql();
        if (LOGGER.isLoggable(Level.FINEST)) {
            object = new StringBuilder(" FE=> Parse(stmt=" + string + ",query=\"");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("\",oids={");
            for (n = 1; n <= simpleParameterList.getParameterCount(); ++n) {
                if (n != 1) {
                    ((StringBuilder)object).append(",");
                }
                ((StringBuilder)object).append(simpleParameterList.getTypeOID(n));
            }
            ((StringBuilder)object).append("})");
            LOGGER.log(Level.FINEST, ((StringBuilder)object).toString());
        }
        object = string2.getBytes(StandardCharsets.UTF_8);
        n = 4 + (byArray == null ? 0 : byArray.length) + 1 + ((byte[])object).length + 1 + 2 + 4 * simpleParameterList.getParameterCount();
        this.pgStream.sendChar(80);
        this.pgStream.sendInteger4(n);
        if (byArray != null) {
            this.pgStream.send(byArray);
        }
        this.pgStream.sendChar(0);
        this.pgStream.send((byte[])object);
        this.pgStream.sendChar(0);
        this.pgStream.sendInteger2(simpleParameterList.getParameterCount());
        for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
            this.pgStream.sendInteger4(simpleParameterList.getTypeOID(i));
        }
        this.pendingParseQueue.add(simpleQuery);
    }

    private void sendBind(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, @Nullable Portal portal, boolean bl) {
        Field field;
        int n;
        int n2;
        Field[] fieldArray;
        byte[] byArray;
        String string = simpleQuery.getStatementName();
        byte[] byArray2 = simpleQuery.getEncodedStatementName();
        byte[] byArray3 = byArray = portal == null ? null : portal.getEncodedPortalName();
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(" FE=> Bind(stmt=" + string + ",portal=" + portal);
            for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
                stringBuilder.append(",$").append(i).append("=<").append(simpleParameterList.toString(i, true)).append(">,type=").append(Oid.toString(simpleParameterList.getTypeOID(i)));
            }
            stringBuilder.append(")");
            LOGGER.log(Level.FINEST, stringBuilder.toString());
        }
        long l = 0L;
        for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
            if (simpleParameterList.isNull(i)) {
                l += 4L;
                continue;
            }
            l += 4L + (long)simpleParameterList.getV3Length(i);
        }
        Field[] fieldArray2 = simpleQuery.getFields();
        if (!bl && simpleQuery.needUpdateFieldFormats() && fieldArray2 != null) {
            fieldArray = fieldArray2;
            n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                field = fieldArray[n];
                if (!this.useBinary(field)) continue;
                field.setFormat(1);
                simpleQuery.setHasBinaryFields(true);
            }
        }
        if (bl && simpleQuery.hasBinaryFields() && fieldArray2 != null) {
            fieldArray = fieldArray2;
            n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                field = fieldArray[n];
                if (field.getFormat() == 0) continue;
                field.setFormat(0);
            }
            simpleQuery.resetNeedUpdateFieldFormats();
            simpleQuery.setHasBinaryFields(false);
        }
        int n3 = !bl && simpleQuery.hasBinaryFields() && fieldArray2 != null ? fieldArray2.length : 0;
        l = (long)(4 + (byArray == null ? 0 : byArray.length) + 1 + (byArray2 == null ? 0 : byArray2.length) + 1 + 2 + simpleParameterList.getParameterCount() * 2 + 2) + l + 2L + (long)(n3 * 2);
        if (l > 0x3FFFFFFFL) {
            throw new PGBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", l)));
        }
        this.pgStream.sendChar(66);
        this.pgStream.sendInteger4((int)l);
        if (byArray != null) {
            this.pgStream.send(byArray);
        }
        this.pgStream.sendChar(0);
        if (byArray2 != null) {
            this.pgStream.send(byArray2);
        }
        this.pgStream.sendChar(0);
        this.pgStream.sendInteger2(simpleParameterList.getParameterCount());
        for (n2 = 1; n2 <= simpleParameterList.getParameterCount(); ++n2) {
            this.pgStream.sendInteger2(simpleParameterList.isBinary(n2) ? 1 : 0);
        }
        this.pgStream.sendInteger2(simpleParameterList.getParameterCount());
        PGBindException pGBindException = null;
        for (n = 1; n <= simpleParameterList.getParameterCount(); ++n) {
            if (simpleParameterList.isNull(n)) {
                this.pgStream.sendInteger4(-1);
                continue;
            }
            this.pgStream.sendInteger4(simpleParameterList.getV3Length(n));
            try {
                simpleParameterList.writeV3Value(n, this.pgStream);
                continue;
            }
            catch (PGBindException pGBindException2) {
                pGBindException = pGBindException2;
            }
        }
        this.pgStream.sendInteger2(n3);
        for (n = 0; fieldArray2 != null && n < n3; ++n) {
            this.pgStream.sendInteger2(fieldArray2[n].getFormat());
        }
        this.pendingBindQueue.add(portal == null ? UNNAMED_PORTAL : portal);
        if (pGBindException != null) {
            throw pGBindException;
        }
    }

    private boolean useBinary(Field field) {
        int n = field.getOID();
        return this.useBinaryForReceive(n);
    }

    private void sendDescribePortal(SimpleQuery simpleQuery, @Nullable Portal portal) {
        LOGGER.log(Level.FINEST, " FE=> Describe(portal={0})", portal);
        byte[] byArray = portal == null ? null : portal.getEncodedPortalName();
        int n = 5 + (byArray == null ? 0 : byArray.length) + 1;
        this.pgStream.sendChar(68);
        this.pgStream.sendInteger4(n);
        this.pgStream.sendChar(80);
        if (byArray != null) {
            this.pgStream.send(byArray);
        }
        this.pgStream.sendChar(0);
        this.pendingDescribePortalQueue.add(simpleQuery);
        simpleQuery.setPortalDescribed(true);
    }

    private void sendDescribeStatement(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, boolean bl) {
        LOGGER.log(Level.FINEST, " FE=> Describe(statement={0})", simpleQuery.getStatementName());
        byte[] byArray = simpleQuery.getEncodedStatementName();
        int n = 5 + (byArray == null ? 0 : byArray.length) + 1;
        this.pgStream.sendChar(68);
        this.pgStream.sendInteger4(n);
        this.pgStream.sendChar(83);
        if (byArray != null) {
            this.pgStream.send(byArray);
        }
        this.pgStream.sendChar(0);
        this.pendingDescribeStatementQueue.add(new DescribeRequest(simpleQuery, simpleParameterList, bl, simpleQuery.getStatementName()));
        this.pendingDescribePortalQueue.add(simpleQuery);
        simpleQuery.setStatementDescribed(true);
        simpleQuery.setPortalDescribed(true);
    }

    private void sendExecute(SimpleQuery simpleQuery, @Nullable Portal portal, int n) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " FE=> Execute(portal={0},limit={1})", new Object[]{portal, n});
        }
        byte[] byArray = portal == null ? null : portal.getEncodedPortalName();
        int n2 = byArray == null ? 0 : byArray.length;
        this.pgStream.sendChar(69);
        this.pgStream.sendInteger4(5 + n2 + 4);
        if (byArray != null) {
            this.pgStream.send(byArray);
        }
        this.pgStream.sendChar(0);
        this.pgStream.sendInteger4(n);
        this.pendingExecuteQueue.add(new ExecuteRequest(simpleQuery, portal, false));
    }

    private void sendClosePortal(String string) {
        LOGGER.log(Level.FINEST, " FE=> ClosePortal({0})", string);
        byte[] byArray = string == null ? null : string.getBytes(StandardCharsets.UTF_8);
        int n = byArray == null ? 0 : byArray.length;
        this.pgStream.sendChar(67);
        this.pgStream.sendInteger4(6 + n);
        this.pgStream.sendChar(80);
        if (byArray != null) {
            this.pgStream.send(byArray);
        }
        this.pgStream.sendChar(0);
    }

    private void sendCloseStatement(String string) {
        LOGGER.log(Level.FINEST, " FE=> CloseStatement({0})", string);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        this.pgStream.sendChar(67);
        this.pgStream.sendInteger4(5 + byArray.length + 1);
        this.pgStream.sendChar(83);
        this.pgStream.send(byArray);
        this.pgStream.sendChar(0);
    }

    private void sendOneQuery(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, int n, int n2, int n3) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = (n3 & 0x400) != 0;
        if (bl3) {
            assert ((n3 & 0x20) == 0) : "Simple mode does not support describe requests. sql = " + simpleQuery.getNativeSql() + ", flags = " + n3;
            this.sendSimpleQuery(simpleQuery, simpleParameterList);
            return;
        }
        assert (!simpleQuery.getNativeQuery().multiStatement) : "Queries that might contain ; must be executed with QueryExecutor.QUERY_EXECUTE_AS_SIMPLE mode. Given query is " + simpleQuery.getNativeSql();
        boolean bl5 = (n3 & 4) != 0;
        boolean bl6 = (n3 & 2) != 0;
        boolean bl7 = (n3 & 0x20) != 0;
        boolean bl8 = (n3 & 8) != 0 && !bl5 && !bl6 && n2 > 0 && !bl7;
        boolean bl9 = (n3 & 1) != 0;
        boolean bl10 = (n3 & 0x100) != 0;
        boolean bl11 = bl2 = (n3 & 0x200) != 0;
        int n4 = bl5 ? 1 : (!bl8 ? n : (n != 0 && n2 > n ? n : n2));
        this.sendParse(simpleQuery, simpleParameterList, bl9);
        boolean bl12 = simpleQuery.hasUnresolvedTypes();
        boolean bl13 = simpleParameterList.hasUnresolvedTypes();
        boolean bl14 = bl = bl7 || !bl9 && bl13 && bl12 && !simpleQuery.isStatementDescribed();
        if (!bl && bl13 && !bl12) {
            object2 = Nullness.castNonNull(simpleQuery.getPrepareTypes());
            object = simpleParameterList.getTypeOIDs();
            for (int i = 0; i < ((int[])object).length; ++i) {
                if (object[i] != 0) continue;
                simpleParameterList.setResolvedType(i + 1, object2[i]);
            }
        }
        if (bl) {
            this.sendDescribeStatement(simpleQuery, simpleParameterList, bl7);
            if (bl7) {
                return;
            }
        }
        object2 = null;
        if (bl8) {
            object = "C_" + this.nextUniqueID++;
            object2 = new Portal(simpleQuery, (String)object);
        }
        this.sendBind(simpleQuery, simpleParameterList, (Portal)object2, bl10);
        if (!(bl6 || bl || simpleQuery.isPortalDescribed() && !bl2)) {
            this.sendDescribePortal(simpleQuery, (Portal)object2);
        }
        this.sendExecute(simpleQuery, (Portal)object2, n4);
    }

    private void sendSimpleQuery(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList) {
        String string = simpleQuery.toString(simpleParameterList);
        LOGGER.log(Level.FINEST, " FE=> SimpleQuery(query=\"{0}\")", string);
        Encoding encoding = this.pgStream.getEncoding();
        byte[] byArray = encoding.encode(string);
        this.pgStream.sendChar(81);
        this.pgStream.sendInteger4(byArray.length + 4 + 1);
        this.pgStream.send(byArray);
        this.pgStream.sendChar(0);
        this.pgStream.flush();
        this.pendingExecuteQueue.add(new ExecuteRequest(simpleQuery, null, true));
        this.pendingDescribePortalQueue.add(simpleQuery);
    }

    private void registerParsedQuery(SimpleQuery simpleQuery, String string) {
        if (string == null) {
            return;
        }
        PhantomReference<SimpleQuery> phantomReference = new PhantomReference<SimpleQuery>(simpleQuery, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(phantomReference, string);
        simpleQuery.setCleanupRef(phantomReference);
    }

    private void processDeadParsedQueries() {
        Reference<SimpleQuery> reference;
        while ((reference = this.parsedQueryCleanupQueue.poll()) != null) {
            String string = Nullness.castNonNull(this.parsedQueryMap.remove(reference));
            this.sendCloseStatement(string);
            reference.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == UNNAMED_PORTAL) {
            return;
        }
        String string = portal.getPortalName();
        PhantomReference<Portal> phantomReference = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(phantomReference, string);
        portal.setCleanupRef(phantomReference);
    }

    private void processDeadPortals() {
        Reference<Portal> reference;
        while ((reference = this.openPortalCleanupQueue.poll()) != null) {
            String string = Nullness.castNonNull(this.openPortalMap.remove(reference));
            this.sendClosePortal(string);
            reference.clear();
        }
    }

    protected void processResults(ResultHandler resultHandler, int n) {
        this.processResults(resultHandler, n, false);
    }

    protected void processResults(ResultHandler resultHandler, int n, boolean bl) {
        boolean bl2 = (n & 4) != 0;
        boolean bl3 = (n & 0x40) != 0;
        ArrayList<Tuple> arrayList = null;
        boolean bl4 = false;
        boolean bl5 = false;
        block26: while (!bl4) {
            int n2 = this.pgStream.receiveChar();
            switch (n2) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block26;
                }
                case 49: {
                    this.pgStream.receiveInteger4();
                    SimpleQuery simpleQuery = this.pendingParseQueue.removeFirst();
                    String string = simpleQuery.getStatementName();
                    LOGGER.log(Level.FINEST, " <=BE ParseComplete [{0}]", string);
                    continue block26;
                }
                case 116: {
                    this.pgStream.receiveInteger4();
                    LOGGER.log(Level.FINEST, " <=BE ParameterDescription");
                    Object object = this.pendingDescribeStatementQueue.getFirst();
                    Object object2 = ((DescribeRequest)object).query;
                    SimpleParameterList simpleParameterList = ((DescribeRequest)object).parameterList;
                    boolean bl6 = ((DescribeRequest)object).describeOnly;
                    Object object3 = ((DescribeRequest)object).statementName;
                    int n3 = this.pgStream.receiveInteger2();
                    for (int i = 1; i <= n3; ++i) {
                        int n4 = this.pgStream.receiveInteger4();
                        simpleParameterList.setResolvedType(i, n4);
                    }
                    if (object3 == null && ((SimpleQuery)object2).getStatementName() == null || object3 != null && object3.equals(((SimpleQuery)object2).getStatementName())) {
                        ((SimpleQuery)object2).setPrepareTypes(simpleParameterList.getTypeOIDs());
                    }
                    if (bl6) {
                        bl5 = true;
                        continue block26;
                    }
                    this.pendingDescribeStatementQueue.removeFirst();
                    continue block26;
                }
                case 50: {
                    this.pgStream.receiveInteger4();
                    Object object = this.pendingBindQueue.removeFirst();
                    LOGGER.log(Level.FINEST, " <=BE BindComplete [{0}]", object);
                    this.registerOpenPortal((Portal)object);
                    continue block26;
                }
                case 51: {
                    this.pgStream.receiveInteger4();
                    LOGGER.log(Level.FINEST, " <=BE CloseComplete");
                    continue block26;
                }
                case 110: {
                    this.pgStream.receiveInteger4();
                    LOGGER.log(Level.FINEST, " <=BE NoData");
                    this.pendingDescribePortalQueue.removeFirst();
                    if (!bl5) continue block26;
                    Object object2 = this.pendingDescribeStatementQueue.removeFirst();
                    SimpleQuery simpleQuery = ((DescribeRequest)object2).query;
                    Field[] fieldArray = simpleQuery.getFields();
                    if (fieldArray == null) continue block26;
                    arrayList = new ArrayList();
                    resultHandler.handleResultRows(simpleQuery, fieldArray, arrayList, null);
                    arrayList = null;
                    continue block26;
                }
                case 115: {
                    this.pgStream.receiveInteger4();
                    LOGGER.log(Level.FINEST, " <=BE PortalSuspended");
                    Object object2 = this.pendingExecuteQueue.removeFirst();
                    SimpleQuery simpleQuery = ((ExecuteRequest)object2).query;
                    Portal portal = ((ExecuteRequest)object2).portal;
                    if (portal != null) {
                        this.adaptiveFetchCache.updateQueryFetchSize(bl, simpleQuery, this.pgStream.getMaxRowSizeBytes());
                    }
                    this.pgStream.clearMaxRowSizeBytes();
                    Object object3 = simpleQuery.getFields();
                    if (object3 != null && arrayList == null) {
                        ArrayList<Tuple> arrayList2 = arrayList = bl2 ? Collections.emptyList() : new ArrayList<Tuple>();
                    }
                    if (object3 != null && arrayList != null) {
                        resultHandler.handleResultRows(simpleQuery, (Field[])object3, (List<Tuple>)arrayList, portal);
                    }
                    arrayList = null;
                    continue block26;
                }
                case 67: {
                    String string;
                    Object object2 = this.receiveCommandStatus();
                    if (this.isFlushCacheOnDeallocate() && (((String)object2).startsWith("DEALLOCATE ALL") || ((String)object2).startsWith("DISCARD ALL"))) {
                        this.deallocateEpoch = (short)(this.deallocateEpoch + 1);
                    }
                    bl5 = false;
                    ExecuteRequest executeRequest = Nullness.castNonNull(this.pendingExecuteQueue.peekFirst());
                    SimpleQuery simpleQuery = executeRequest.query;
                    Object object3 = executeRequest.portal;
                    if (object3 != null) {
                        this.adaptiveFetchCache.removeQuery(bl, simpleQuery);
                        this.adaptiveFetchCache.updateQueryFetchSize(bl, simpleQuery, this.pgStream.getMaxRowSizeBytes());
                    }
                    this.pgStream.clearMaxRowSizeBytes();
                    if (((String)object2).startsWith("SET") && (string = simpleQuery.getNativeQuery().nativeSql).lastIndexOf("search_path", 1024) != -1 && !string.equals(this.lastSetSearchPathQuery)) {
                        this.lastSetSearchPathQuery = string;
                        this.deallocateEpoch = (short)(this.deallocateEpoch + 1);
                    }
                    if (!executeRequest.asSimple) {
                        this.pendingExecuteQueue.removeFirst();
                    }
                    if (simpleQuery == this.autoSaveQuery || simpleQuery == this.releaseAutoSave) continue block26;
                    Field[] fieldArray = simpleQuery.getFields();
                    if (fieldArray != null && arrayList == null) {
                        ArrayList<Tuple> arrayList3 = arrayList = bl2 ? Collections.emptyList() : new ArrayList<Tuple>();
                    }
                    if (fieldArray == null && arrayList != null) {
                        throw new IllegalStateException("Received resultset tuples, but no field structure for them");
                    }
                    if (fieldArray != null && arrayList != null) {
                        resultHandler.handleResultRows(simpleQuery, fieldArray, arrayList, null);
                        arrayList = null;
                        if (bl3) {
                            this.interpretCommandStatus((String)object2, resultHandler);
                        }
                    } else {
                        this.interpretCommandStatus((String)object2, resultHandler);
                    }
                    if (executeRequest.asSimple) {
                        simpleQuery.setFields(null);
                    }
                    if (object3 == null) continue block26;
                    object3.close();
                    continue block26;
                }
                case 68: {
                    Object object2 = null;
                    try {
                        object2 = this.pgStream.receiveTupleV3();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        if (!bl2) {
                            resultHandler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results.", new Object[0]), PSQLState.OUT_OF_MEMORY, (Throwable)outOfMemoryError));
                        }
                    }
                    catch (SQLException sQLException) {
                        resultHandler.handleError(sQLException);
                    }
                    if (!bl2) {
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        if (object2 != null) {
                            arrayList.add((Tuple)object2);
                        }
                    }
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block26;
                    int n5 = object2 == null ? -1 : ((Tuple)object2).length();
                    LOGGER.log(Level.FINEST, " <=BE DataRow(len={0})", n5);
                    continue block26;
                }
                case 69: {
                    SQLException sQLException = this.receiveErrorResponse();
                    resultHandler.handleError(sQLException);
                    if (!this.willHealViaReparse(sQLException)) continue block26;
                    this.deallocateEpoch = (short)(this.deallocateEpoch + 1);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block26;
                    LOGGER.log(Level.FINEST, " FE: received {0}, will invalidate statements. deallocateEpoch is now {1}", new Object[]{sQLException.getSQLState(), this.deallocateEpoch});
                    continue block26;
                }
                case 73: {
                    this.pgStream.receiveInteger4();
                    LOGGER.log(Level.FINEST, " <=BE EmptyQuery");
                    ExecuteRequest executeRequest = this.pendingExecuteQueue.removeFirst();
                    Object object3 = executeRequest.portal;
                    resultHandler.handleCommandStatus("EMPTY", 0L, 0L);
                    if (object3 == null) continue block26;
                    object3.close();
                    continue block26;
                }
                case 78: {
                    SQLWarning sQLWarning = this.receiveNoticeResponse();
                    resultHandler.handleWarning(sQLWarning);
                    continue block26;
                }
                case 83: {
                    try {
                        this.receiveParameterStatus();
                    }
                    catch (SQLException sQLException) {
                        resultHandler.handleError(sQLException);
                        bl4 = true;
                    }
                    continue block26;
                }
                case 84: {
                    Object object3 = this.receiveFields();
                    arrayList = new ArrayList<Tuple>();
                    SimpleQuery simpleQuery = Nullness.castNonNull(this.pendingDescribePortalQueue.peekFirst());
                    if (!this.pendingExecuteQueue.isEmpty() && !Nullness.castNonNull(this.pendingExecuteQueue.peekFirst()).asSimple) {
                        this.pendingDescribePortalQueue.removeFirst();
                    }
                    simpleQuery.setFields((Field[])object3);
                    if (!bl5) continue block26;
                    DescribeRequest describeRequest = this.pendingDescribeStatementQueue.removeFirst();
                    SimpleQuery simpleQuery2 = describeRequest.query;
                    simpleQuery2.setFields((Field[])object3);
                    resultHandler.handleResultRows(simpleQuery2, (Field[])object3, (List<Tuple>)arrayList, null);
                    arrayList = null;
                    continue block26;
                }
                case 90: {
                    this.receiveRFQ();
                    if (!this.pendingExecuteQueue.isEmpty() && Nullness.castNonNull(this.pendingExecuteQueue.peekFirst()).asSimple) {
                        arrayList = null;
                        this.pgStream.clearResultBufferCount();
                        ExecuteRequest executeRequest = this.pendingExecuteQueue.removeFirst();
                        executeRequest.query.setFields(null);
                        this.pendingDescribePortalQueue.removeFirst();
                        if (!this.pendingExecuteQueue.isEmpty()) {
                            if (this.getTransactionState() != TransactionState.IDLE) continue block26;
                            resultHandler.secureProgress();
                            continue block26;
                        }
                    }
                    bl4 = true;
                    while (!this.pendingParseQueue.isEmpty()) {
                        SimpleQuery simpleQuery = this.pendingParseQueue.removeFirst();
                        simpleQuery.unprepare();
                    }
                    this.pendingParseQueue.clear();
                    while (!this.pendingDescribeStatementQueue.isEmpty()) {
                        DescribeRequest describeRequest = this.pendingDescribeStatementQueue.removeFirst();
                        LOGGER.log(Level.FINEST, " FE marking setStatementDescribed(false) for query {0}", describeRequest.query);
                        describeRequest.query.setStatementDescribed(false);
                    }
                    while (!this.pendingDescribePortalQueue.isEmpty()) {
                        SimpleQuery simpleQuery = this.pendingDescribePortalQueue.removeFirst();
                        LOGGER.log(Level.FINEST, " FE marking setPortalDescribed(false) for query {0}", simpleQuery);
                        simpleQuery.setPortalDescribed(false);
                    }
                    this.pendingBindQueue.clear();
                    this.pendingExecuteQueue.clear();
                    continue block26;
                }
                case 71: {
                    LOGGER.log(Level.FINEST, " <=BE CopyInResponse");
                    LOGGER.log(Level.FINEST, " FE=> CopyFail");
                    byte[] byArray = "COPY commands are only supported using the CopyManager API.".getBytes(StandardCharsets.US_ASCII);
                    this.pgStream.sendChar(102);
                    this.pgStream.sendInteger4(byArray.length + 4 + 1);
                    this.pgStream.send(byArray);
                    this.pgStream.sendChar(0);
                    this.pgStream.flush();
                    this.sendSync();
                    this.skipMessage();
                    continue block26;
                }
                case 72: {
                    LOGGER.log(Level.FINEST, " <=BE CopyOutResponse");
                    this.skipMessage();
                    resultHandler.handleError(new PSQLException(GT.tr("COPY commands are only supported using the CopyManager API.", new Object[0]), PSQLState.NOT_IMPLEMENTED));
                    continue block26;
                }
                case 99: {
                    this.skipMessage();
                    LOGGER.log(Level.FINEST, " <=BE CopyDone");
                    continue block26;
                }
                case 100: {
                    this.skipMessage();
                    LOGGER.log(Level.FINEST, " <=BE CopyData");
                    continue block26;
                }
            }
            throw new IOException("Unexpected packet type: " + n2);
        }
    }

    private void skipMessage() {
        int n = this.pgStream.receiveInteger4();
        assert (n >= 4) : "Length from skip message must be at least 4 ";
        this.pgStream.skip(n - 4);
    }

    @Override
    public synchronized void fetch(ResultCursor resultCursor, ResultHandler resultHandler, int n, boolean bl) {
        this.waitOnLock();
        Portal portal = (Portal)resultCursor;
        ResultHandler resultHandler2 = resultHandler;
        final SimpleQuery simpleQuery = Nullness.castNonNull(portal.getQuery());
        resultHandler = new ResultHandlerDelegate(resultHandler2){

            @Override
            public void handleCommandStatus(String string, long l, long l2) {
                this.handleResultRows(simpleQuery, NO_FIELDS, new ArrayList<Tuple>(), null);
            }
        };
        try {
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(simpleQuery, portal, n);
            this.sendSync();
            this.processResults(resultHandler, 0, bl);
            this.estimatedReceiveBufferBytes = 0;
        }
        catch (IOException iOException) {
            this.abort();
            resultHandler.handleError(new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
        }
        resultHandler.handleCompletion();
    }

    @Override
    public int getAdaptiveFetchSize(boolean bl, ResultCursor resultCursor) {
        SimpleQuery simpleQuery;
        if (resultCursor instanceof Portal && Objects.nonNull(simpleQuery = ((Portal)resultCursor).getQuery())) {
            return this.adaptiveFetchCache.getFetchSizeForQuery(bl, simpleQuery);
        }
        return -1;
    }

    @Override
    public void setAdaptiveFetch(boolean bl) {
        this.adaptiveFetchCache.setAdaptiveFetch(bl);
    }

    @Override
    public boolean getAdaptiveFetch() {
        return this.adaptiveFetchCache.getAdaptiveFetch();
    }

    @Override
    public void addQueryToAdaptiveFetchCache(boolean bl, @NonNull ResultCursor resultCursor) {
        SimpleQuery simpleQuery;
        if (resultCursor instanceof Portal && Objects.nonNull(simpleQuery = ((Portal)resultCursor).getQuery())) {
            this.adaptiveFetchCache.addNewQuery(bl, simpleQuery);
        }
    }

    @Override
    public void removeQueryFromAdaptiveFetchCache(boolean bl, @NonNull ResultCursor resultCursor) {
        SimpleQuery simpleQuery;
        if (resultCursor instanceof Portal && Objects.nonNull(simpleQuery = ((Portal)resultCursor).getQuery())) {
            this.adaptiveFetchCache.removeQuery(bl, simpleQuery);
        }
    }

    private Field[] receiveFields() {
        this.pgStream.receiveInteger4();
        int n = this.pgStream.receiveInteger2();
        Field[] fieldArray = new Field[n];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE RowDescription({0})", n);
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = this.pgStream.receiveCanonicalString();
            int n2 = this.pgStream.receiveInteger4();
            short s = (short)this.pgStream.receiveInteger2();
            int n3 = this.pgStream.receiveInteger4();
            int n4 = this.pgStream.receiveInteger2();
            int n5 = this.pgStream.receiveInteger4();
            int n6 = this.pgStream.receiveInteger2();
            fieldArray[i] = new Field(string, n3, n4, n5, n2, s);
            fieldArray[i].setFormat(n6);
            LOGGER.log(Level.FINEST, "        {0}", fieldArray[i]);
        }
        return fieldArray;
    }

    private void receiveAsyncNotify() {
        int n = this.pgStream.receiveInteger4();
        assert (n > 4) : "Length for AsyncNotify must be at least 4";
        int n2 = this.pgStream.receiveInteger4();
        String string = this.pgStream.receiveCanonicalString();
        String string2 = this.pgStream.receiveString();
        this.addNotification(new Notification(string, n2, string2));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE AsyncNotify({0},{1},{2})", new Object[]{n2, string, string2});
        }
    }

    private SQLException receiveErrorResponse() {
        int n = this.pgStream.receiveInteger4();
        assert (n > 4) : "Error response length must be greater than 4";
        EncodingPredictor.DecodeResult decodeResult = this.pgStream.receiveErrorString(n - 4);
        ServerErrorMessage serverErrorMessage = new ServerErrorMessage(decodeResult);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", serverErrorMessage.toString());
        }
        PSQLException pSQLException = new PSQLException(serverErrorMessage, this.logServerErrorDetail);
        if (this.transactionFailCause == null) {
            this.transactionFailCause = pSQLException;
        } else {
            pSQLException.initCause(this.transactionFailCause);
        }
        return pSQLException;
    }

    private SQLWarning receiveNoticeResponse() {
        int n = this.pgStream.receiveInteger4();
        assert (n > 4) : "Notice Response length must be greater than 4";
        ServerErrorMessage serverErrorMessage = new ServerErrorMessage(this.pgStream.receiveString(n - 4));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE NoticeResponse({0})", serverErrorMessage.toString());
        }
        return new PSQLWarning(serverErrorMessage);
    }

    private String receiveCommandStatus() {
        int n = this.pgStream.receiveInteger4();
        String string = this.pgStream.receiveString(n - 5);
        this.pgStream.receiveChar();
        LOGGER.log(Level.FINEST, " <=BE CommandStatus({0})", string);
        return string;
    }

    private void interpretCommandStatus(String string, ResultHandler resultHandler) {
        try {
            this.commandCompleteParser.parse(string);
        }
        catch (SQLException sQLException) {
            resultHandler.handleError(sQLException);
            return;
        }
        long l = this.commandCompleteParser.getOid();
        long l2 = this.commandCompleteParser.getRows();
        resultHandler.handleCommandStatus(string, l2, l);
    }

    private void receiveRFQ() {
        if (this.pgStream.receiveInteger4() != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char c = (char)this.pgStream.receiveChar();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE ReadyForQuery({0})", Character.valueOf(c));
        }
        switch (c) {
            case 'I': {
                this.transactionFailCause = null;
                this.setTransactionState(TransactionState.IDLE);
                break;
            }
            case 'T': {
                this.transactionFailCause = null;
                this.setTransactionState(TransactionState.OPEN);
                break;
            }
            case 'E': {
                this.setTransactionState(TransactionState.FAILED);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + c);
            }
        }
    }

    @Override
    protected void sendCloseMessage() {
        this.pgStream.sendChar(88);
        this.pgStream.sendInteger4(4);
    }

    public void readStartupMessages() {
        block7: for (int i = 0; i < 1000; ++i) {
            int n = this.pgStream.receiveChar();
            switch (n) {
                case 90: {
                    this.receiveRFQ();
                    return;
                }
                case 75: {
                    int n2 = this.pgStream.receiveInteger4();
                    if (n2 != 12) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                    }
                    int n3 = this.pgStream.receiveInteger4();
                    int n4 = this.pgStream.receiveInteger4();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, " <=BE BackendKeyData(pid={0},ckey={1})", new Object[]{n3, n4});
                    }
                    this.setBackendKeyData(n3, n4);
                    continue block7;
                }
                case 69: {
                    throw this.receiveErrorResponse();
                }
                case 78: {
                    this.addWarning(this.receiveNoticeResponse());
                    continue block7;
                }
                case 83: {
                    this.receiveParameterStatus();
                    continue block7;
                }
                default: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "  invalid message type={0}", Character.valueOf((char)n));
                    }
                    throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                }
            }
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    public void receiveParameterStatus() {
        this.pgStream.receiveInteger4();
        String string = this.pgStream.receiveCanonicalStringIfPresent();
        String string2 = this.pgStream.receiveCanonicalStringIfPresent();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE ParameterStatus({0} = {1})", new Object[]{string, string2});
        }
        if (string.isEmpty()) {
            return;
        }
        this.onParameterStatus(string, string2);
        if (string.equals("client_encoding")) {
            if (this.allowEncodingChanges) {
                if (!string2.equalsIgnoreCase("UTF8") && !string2.equalsIgnoreCase("UTF-8")) {
                    LOGGER.log(Level.FINE, "pgjdbc expects client_encoding to be UTF8 for proper operation. Actual encoding is {0}", string2);
                }
                this.pgStream.setEncoding(Encoding.getDatabaseEncoding(string2));
            } else if (!string2.equalsIgnoreCase("UTF8") && !string2.equalsIgnoreCase("UTF-8")) {
                this.close();
                throw new PSQLException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UTF8 for correct operation.", string2), PSQLState.CONNECTION_FAILURE);
            }
        }
        if (string.equals("DateStyle") && !string2.startsWith("ISO") && !string2.toUpperCase().startsWith("ISO")) {
            this.close();
            throw new PSQLException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", string2), PSQLState.CONNECTION_FAILURE);
        }
        if (string.equals("standard_conforming_strings")) {
            if (string2.equals("on")) {
                this.setStandardConformingStrings(true);
            } else if (string2.equals("off")) {
                this.setStandardConformingStrings(false);
            } else {
                this.close();
                throw new PSQLException(GT.tr("The server''s standard_conforming_strings parameter was reported as {0}. The JDBC driver expected on or off.", string2), PSQLState.CONNECTION_FAILURE);
            }
            return;
        }
        if ("TimeZone".equals(string)) {
            this.setTimeZone(TimestampUtils.parseBackendTimeZone(string2));
        } else if ("application_name".equals(string)) {
            this.setApplicationName(string2);
        } else if ("server_version_num".equals(string)) {
            this.setServerVersionNum(Integer.parseInt(string2));
        } else if ("server_version".equals(string)) {
            this.setServerVersion(string2);
        } else if ("integer_datetimes".equals(string)) {
            if ("on".equals(string2)) {
                this.setIntegerDateTimes(true);
            } else if ("off".equals(string2)) {
                this.setIntegerDateTimes(false);
            } else {
                throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
            }
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public @Nullable TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    @Override
    public String getApplicationName() {
        if (this.applicationName == null) {
            return "";
        }
        return this.applicationName;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return this.replicationProtocol;
    }

    @Override
    public boolean useBinaryForReceive(int n) {
        return this.useBinaryReceiveForOids.contains(n);
    }

    @Override
    public void setBinaryReceiveOids(Set<Integer> set) {
        this.useBinaryReceiveForOids.clear();
        this.useBinaryReceiveForOids.addAll(set);
    }

    @Override
    public boolean useBinaryForSend(int n) {
        return this.useBinarySendForOids.contains(n);
    }

    @Override
    public void setBinarySendOids(Set<Integer> set) {
        this.useBinarySendForOids.clear();
        this.useBinarySendForOids.addAll(set);
    }

    private void setIntegerDateTimes(boolean bl) {
        this.integerDateTimes = bl;
    }

    @Override
    public boolean getIntegerDateTimes() {
        return this.integerDateTimes;
    }

    static {
        Encoding.canonicalize("application_name");
        Encoding.canonicalize("client_encoding");
        Encoding.canonicalize("DateStyle");
        Encoding.canonicalize("integer_datetimes");
        Encoding.canonicalize("off");
        Encoding.canonicalize("on");
        Encoding.canonicalize("server_encoding");
        Encoding.canonicalize("server_version");
        Encoding.canonicalize("server_version_num");
        Encoding.canonicalize("standard_conforming_strings");
        Encoding.canonicalize("TimeZone");
        Encoding.canonicalize("UTF8");
        Encoding.canonicalize("UTF-8");
        UNNAMED_PORTAL = new Portal(null, "unnamed");
    }
}

