/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Utils;
import com.hm.postgresql.core.v3.TypeTransferModeRegistry;
import com.hm.postgresql.core.v3.V3ParameterList;
import com.hm.postgresql.geometric.PGbox;
import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.jdbc.UUIDArrayAssistant;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.ByteStreamWriter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.StreamWrapper;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleParameterList
implements V3ParameterList {
    private static final byte IN = 1;
    private static final byte OUT = 2;
    private static final byte INOUT = 3;
    private static final byte TEXT = 0;
    private static final byte BINARY = 4;
    private final @Nullable Object[] paramValues;
    private final int[] paramTypes;
    private final byte[] flags;
    private final byte[] @Nullable [] encoded;
    private final @Nullable TypeTransferModeRegistry transferModeRegistry;
    private static final Object NULL_OBJECT = new Object();
    private int pos = 0;

    SimpleParameterList(int n, @Nullable TypeTransferModeRegistry typeTransferModeRegistry) {
        this.paramValues = new Object[n];
        this.paramTypes = new int[n];
        this.encoded = new byte[n][];
        this.flags = new byte[n];
        this.transferModeRegistry = typeTransferModeRegistry;
    }

    @Override
    public void registerOutParameter(int n, int n2) {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", n, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n3 = n - 1;
        this.flags[n3] = (byte)(this.flags[n3] | 2);
    }

    private void bind(int n, Object object, int n2, byte by) {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", n, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--n] = null;
        this.paramValues[n] = object;
        this.flags[n] = (byte)(this.direction(n) | 1 | by);
        if (n2 == 0 && this.paramTypes[n] != 0 && object == NULL_OBJECT) {
            return;
        }
        this.paramTypes[n] = n2;
        this.pos = n + 1;
    }

    @Override
    public @NonNegative int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public @NonNegative int getOutParameterCount() {
        int n = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if ((this.direction(i) & 2) != 2) continue;
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    @Override
    public @NonNegative int getInParameterCount() {
        int n = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void setIntParameter(@Positive int n, int n2) {
        byte[] byArray = new byte[4];
        ByteConverter.int4(byArray, 0, n2);
        this.bind(n, byArray, 23, (byte)4);
    }

    @Override
    public void setLiteralParameter(@Positive int n, String string, int n2) {
        this.bind(n, string, n2, (byte)0);
    }

    @Override
    public void setStringParameter(@Positive int n, String string, int n2) {
        this.bind(n, string, n2, (byte)0);
    }

    @Override
    public void setBinaryParameter(@Positive int n, byte[] byArray, int n2) {
        this.bind(n, byArray, n2, (byte)4);
    }

    @Override
    public void setBytea(@Positive int n, byte[] byArray, int n2, @NonNegative int n3) {
        this.bind(n, new StreamWrapper(byArray, n2, n3), 17, (byte)4);
    }

    @Override
    public void setBytea(@Positive int n, InputStream inputStream, @NonNegative int n2) {
        this.bind(n, new StreamWrapper(inputStream, n2), 17, (byte)4);
    }

    @Override
    public void setBytea(@Positive int n, InputStream inputStream) {
        this.bind(n, new StreamWrapper(inputStream), 17, (byte)4);
    }

    @Override
    public void setBytea(@Positive int n, ByteStreamWriter byteStreamWriter) {
        this.bind(n, byteStreamWriter, 17, (byte)4);
    }

    @Override
    public void setText(@Positive int n, InputStream inputStream) {
        this.bind(n, new StreamWrapper(inputStream), 25, (byte)0);
    }

    @Override
    public void setNull(@Positive int n, int n2) {
        int n3 = 0;
        if (this.transferModeRegistry != null && this.transferModeRegistry.useBinaryForReceive(n2)) {
            n3 = 4;
        }
        this.bind(n, NULL_OBJECT, n2, (byte)n3);
    }

    @Override
    public String toString(@Positive int n, boolean bl) {
        Object object;
        if ((object = this.paramValues[--n]) == null) {
            return "?";
        }
        if (object == NULL_OBJECT) {
            return "NULL";
        }
        if ((this.flags[n] & 4) == 4) {
            switch (this.paramTypes[n]) {
                case 21: {
                    short s = ByteConverter.int2((byte[])object, 0);
                    return Short.toString(s);
                }
                case 23: {
                    int n2 = ByteConverter.int4((byte[])object, 0);
                    return Integer.toString(n2);
                }
                case 20: {
                    long l = ByteConverter.int8((byte[])object, 0);
                    return Long.toString(l);
                }
                case 700: {
                    float f = ByteConverter.float4((byte[])object, 0);
                    if (Float.isNaN(f)) {
                        return "'NaN'::real";
                    }
                    return Float.toString(f);
                }
                case 701: {
                    double d = ByteConverter.float8((byte[])object, 0);
                    if (Double.isNaN(d)) {
                        return "'NaN'::double precision";
                    }
                    return Double.toString(d);
                }
                case 1700: {
                    Number number = ByteConverter.numeric((byte[])object);
                    if (number instanceof Double) {
                        assert (((Double)number).isNaN());
                        return "'NaN'::numeric";
                    }
                    return number.toString();
                }
                case 2950: {
                    String string = new UUIDArrayAssistant().buildElement((byte[])object, 0, 16).toString();
                    return "'" + string + "'::uuid";
                }
                case 600: {
                    PGpoint pGpoint = new PGpoint();
                    pGpoint.setByteValue((byte[])object, 0);
                    return "'" + pGpoint.toString() + "'::point";
                }
                case 603: {
                    PGbox pGbox = new PGbox();
                    pGbox.setByteValue((byte[])object, 0);
                    return "'" + pGbox.toString() + "'::box";
                }
            }
            return "?";
        }
        String string = object.toString();
        StringBuilder stringBuilder = new StringBuilder(3 + (string.length() + 10) / 10 * 11);
        stringBuilder.append('\'');
        try {
            stringBuilder = Utils.escapeLiteral(stringBuilder, string, bl);
        }
        catch (SQLException sQLException) {
            stringBuilder.append(string);
        }
        stringBuilder.append('\'');
        int n3 = this.paramTypes[n];
        if (n3 == 1114) {
            stringBuilder.append("::timestamp");
        } else if (n3 == 1184) {
            stringBuilder.append("::timestamp with time zone");
        } else if (n3 == 1083) {
            stringBuilder.append("::time");
        } else if (n3 == 1266) {
            stringBuilder.append("::time with time zone");
        } else if (n3 == 1082) {
            stringBuilder.append("::date");
        } else if (n3 == 1186) {
            stringBuilder.append("::interval");
        } else if (n3 == 1700) {
            stringBuilder.append("::numeric");
        }
        return stringBuilder.toString();
    }

    @Override
    public void checkAllParametersSet() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2 || this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", i + 1), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void convertFunctionOutParameters() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) != 2) continue;
            this.paramTypes[i] = 2278;
            this.paramValues[i] = NULL_OBJECT;
        }
    }

    private static void streamBytea(PGStream pGStream, StreamWrapper streamWrapper) {
        byte[] byArray = streamWrapper.getBytes();
        if (byArray != null) {
            pGStream.send(byArray, streamWrapper.getOffset(), streamWrapper.getLength());
            return;
        }
        pGStream.sendStream(streamWrapper.getStream(), streamWrapper.getLength());
    }

    private static void streamBytea(PGStream pGStream, ByteStreamWriter byteStreamWriter) {
        pGStream.send(byteStreamWriter);
    }

    @Override
    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(@Positive int n) {
        return this.paramTypes[n - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int n : this.paramTypes) {
            if (n != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(@Positive int n, int n2) {
        if (this.paramTypes[n - 1] == 0) {
            this.paramTypes[n - 1] = n2;
        } else if (this.paramTypes[n - 1] != n2) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + n + " from " + this.paramTypes[n - 1] + " to " + n2);
        }
    }

    boolean isNull(@Positive int n) {
        return this.paramValues[n - 1] == NULL_OBJECT;
    }

    boolean isBinary(@Positive int n) {
        return (this.flags[n - 1] & 4) != 0;
    }

    private byte direction(@Positive int n) {
        return (byte)(this.flags[n] & 3);
    }

    int getV3Length(@Positive int n) {
        Object object;
        if ((object = this.paramValues[--n]) == null || object == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof StreamWrapper) {
            return ((StreamWrapper)object).getLength();
        }
        if (object instanceof ByteStreamWriter) {
            return ((ByteStreamWriter)object).getLength();
        }
        byte[] byArray = this.encoded[n];
        if (byArray == null) {
            byArray = object.toString().getBytes(StandardCharsets.UTF_8);
            this.encoded[n] = byArray;
        }
        return byArray.length;
    }

    void writeV3Value(@Positive int n, PGStream pGStream) {
        Object object;
        if ((object = this.paramValues[--n]) == null || object == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (object instanceof byte[]) {
            pGStream.send((byte[])object);
            return;
        }
        if (object instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pGStream, (StreamWrapper)object);
            return;
        }
        if (object instanceof ByteStreamWriter) {
            SimpleParameterList.streamBytea(pGStream, (ByteStreamWriter)object);
            return;
        }
        if (this.encoded[n] == null) {
            this.encoded[n] = ((String)object).getBytes(StandardCharsets.UTF_8);
        }
        pGStream.send(this.encoded[n]);
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList simpleParameterList = new SimpleParameterList(this.paramValues.length, this.transferModeRegistry);
        System.arraycopy(this.paramValues, 0, simpleParameterList.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, simpleParameterList.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.flags, 0, simpleParameterList.flags, 0, this.flags.length);
        simpleParameterList.pos = this.pos;
        return simpleParameterList;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.flags, (byte)0);
        this.pos = 0;
    }

    @Override
    public SimpleParameterList @Nullable [] getSubparams() {
        return null;
    }

    @Override
    public @Nullable Object[] getValues() {
        return this.paramValues;
    }

    @Override
    public int[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getFlags() {
        return this.flags;
    }

    @Override
    public byte[] @Nullable [] getEncoding() {
        return this.encoded;
    }

    @Override
    public void appendAll(ParameterList parameterList) {
        if (parameterList instanceof SimpleParameterList) {
            SimpleParameterList simpleParameterList = (SimpleParameterList)parameterList;
            int n = simpleParameterList.getInParameterCount();
            if (this.pos + n > this.paramValues.length) {
                throw new PSQLException(GT.tr("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + n, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            System.arraycopy(simpleParameterList.getValues(), 0, this.paramValues, this.pos, n);
            System.arraycopy(simpleParameterList.getParamTypes(), 0, this.paramTypes, this.pos, n);
            System.arraycopy(simpleParameterList.getFlags(), 0, this.flags, this.pos, n);
            System.arraycopy(simpleParameterList.getEncoding(), 0, this.encoded, this.pos, n);
            this.pos += n;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<[");
        if (this.paramValues.length > 0) {
            stringBuilder.append(this.toString(1, true));
            for (int i = 2; i <= this.paramValues.length; ++i) {
                stringBuilder.append(" ,").append(this.toString(i, true));
            }
        }
        stringBuilder.append("]>");
        return stringBuilder.toString();
    }
}

