/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3.adaptivefetch;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.v3.adaptivefetch.AdaptiveFetchCacheEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AdaptiveFetchCache {
    private final Map<String, AdaptiveFetchCacheEntry> adaptiveFetchInfoMap = new HashMap<String, AdaptiveFetchCacheEntry>();
    private boolean adaptiveFetch = false;
    private int minimumAdaptiveFetchSize = 0;
    private int maximumAdaptiveFetchSize = -1;
    private long maximumResultBufferSize = -1L;

    public AdaptiveFetchCache(long l, Properties properties) {
        this.adaptiveFetch = PGProperty.ADAPTIVE_FETCH.getBoolean(properties);
        this.minimumAdaptiveFetchSize = PGProperty.ADAPTIVE_FETCH_MINIMUM.getInt(properties);
        this.maximumAdaptiveFetchSize = PGProperty.ADAPTIVE_FETCH_MAXIMUM.getInt(properties);
        this.maximumResultBufferSize = l;
    }

    public void addNewQuery(boolean bl, @NonNull Query query) {
        if (bl && this.maximumResultBufferSize != -1L) {
            String string = query.getNativeSql().trim();
            AdaptiveFetchCacheEntry adaptiveFetchCacheEntry = this.adaptiveFetchInfoMap.get(string);
            if (adaptiveFetchCacheEntry == null) {
                adaptiveFetchCacheEntry = new AdaptiveFetchCacheEntry();
            }
            adaptiveFetchCacheEntry.incrementCounter();
            this.adaptiveFetchInfoMap.put(string, adaptiveFetchCacheEntry);
        }
    }

    public void updateQueryFetchSize(boolean bl, @NonNull Query query, int n) {
        int n2;
        String string;
        AdaptiveFetchCacheEntry adaptiveFetchCacheEntry;
        if (bl && this.maximumResultBufferSize != -1L && (adaptiveFetchCacheEntry = this.adaptiveFetchInfoMap.get(string = query.getNativeSql().trim())) != null && (n2 = adaptiveFetchCacheEntry.getMaximumRowSizeBytes()) < n && n > 0) {
            int n3 = (int)(this.maximumResultBufferSize / (long)n);
            n3 = this.adjustFetchSize(n3);
            adaptiveFetchCacheEntry.setMaximumRowSizeBytes(n);
            adaptiveFetchCacheEntry.setSize(n3);
            this.adaptiveFetchInfoMap.put(string, adaptiveFetchCacheEntry);
        }
    }

    public int getFetchSizeForQuery(boolean bl, @NonNull Query query) {
        String string;
        AdaptiveFetchCacheEntry adaptiveFetchCacheEntry;
        if (bl && this.maximumResultBufferSize != -1L && (adaptiveFetchCacheEntry = this.adaptiveFetchInfoMap.get(string = query.getNativeSql().trim())) != null) {
            return adaptiveFetchCacheEntry.getSize();
        }
        return -1;
    }

    public void removeQuery(boolean bl, @NonNull Query query) {
        String string;
        AdaptiveFetchCacheEntry adaptiveFetchCacheEntry;
        if (bl && this.maximumResultBufferSize != -1L && (adaptiveFetchCacheEntry = this.adaptiveFetchInfoMap.get(string = query.getNativeSql().trim())) != null) {
            adaptiveFetchCacheEntry.decrementCounter();
            if (adaptiveFetchCacheEntry.getCounter() < 1) {
                this.adaptiveFetchInfoMap.remove(string);
            } else {
                this.adaptiveFetchInfoMap.put(string, adaptiveFetchCacheEntry);
            }
        }
    }

    private int adjustFetchSize(int n) {
        int n2 = this.adjustMaximumFetchSize(n);
        n2 = this.adjustMinimumFetchSize(n2);
        return n2;
    }

    private int adjustMinimumFetchSize(int n) {
        if (this.minimumAdaptiveFetchSize == 0) {
            return n;
        }
        if (this.minimumAdaptiveFetchSize > n) {
            return this.minimumAdaptiveFetchSize;
        }
        return n;
    }

    private int adjustMaximumFetchSize(int n) {
        if (this.maximumAdaptiveFetchSize == -1) {
            return n;
        }
        if (this.maximumAdaptiveFetchSize < n) {
            return this.maximumAdaptiveFetchSize;
        }
        return n;
    }

    public boolean getAdaptiveFetch() {
        return this.adaptiveFetch;
    }

    public void setAdaptiveFetch(boolean bl) {
        this.adaptiveFetch = bl;
    }
}

