/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3.replication;

import com.hm.postgresql.copy.CopyDual;
import com.hm.postgresql.replication.LogSequenceNumber;
import com.hm.postgresql.replication.PGReplicationStream;
import com.hm.postgresql.replication.ReplicationType;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class V3PGReplicationStream
implements PGReplicationStream {
    private static final Logger LOGGER = Logger.getLogger(V3PGReplicationStream.class.getName());
    public static final long POSTGRES_EPOCH_2000_01_01 = 946684800000L;
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private final CopyDual copyDual;
    private final long updateInterval;
    private final ReplicationType replicationType;
    private long lastStatusUpdate;
    private boolean closeFlag = false;
    private LogSequenceNumber lastServerLSN = LogSequenceNumber.INVALID_LSN;
    private volatile LogSequenceNumber lastReceiveLSN = LogSequenceNumber.INVALID_LSN;
    private volatile LogSequenceNumber lastAppliedLSN = LogSequenceNumber.INVALID_LSN;
    private volatile LogSequenceNumber lastFlushedLSN = LogSequenceNumber.INVALID_LSN;

    public V3PGReplicationStream(CopyDual copyDual, LogSequenceNumber logSequenceNumber, long l, ReplicationType replicationType) {
        this.copyDual = copyDual;
        this.updateInterval = l * 1000000L;
        this.lastStatusUpdate = System.nanoTime() - l * 1000000L;
        this.lastReceiveLSN = logSequenceNumber;
        this.replicationType = replicationType;
    }

    @Override
    public @Nullable ByteBuffer read() {
        this.checkClose();
        ByteBuffer byteBuffer = null;
        while (byteBuffer == null && this.copyDual.isActive()) {
            byteBuffer = this.readInternal(true);
        }
        return byteBuffer;
    }

    @Override
    public @Nullable ByteBuffer readPending() {
        this.checkClose();
        return this.readInternal(false);
    }

    @Override
    public LogSequenceNumber getLastReceiveLSN() {
        return this.lastReceiveLSN;
    }

    @Override
    public LogSequenceNumber getLastFlushedLSN() {
        return this.lastFlushedLSN;
    }

    @Override
    public LogSequenceNumber getLastAppliedLSN() {
        return this.lastAppliedLSN;
    }

    @Override
    public void setFlushedLSN(LogSequenceNumber logSequenceNumber) {
        this.lastFlushedLSN = logSequenceNumber;
    }

    @Override
    public void setAppliedLSN(LogSequenceNumber logSequenceNumber) {
        this.lastAppliedLSN = logSequenceNumber;
    }

    @Override
    public void forceUpdateStatus() {
        this.checkClose();
        this.updateStatusInternal(this.lastReceiveLSN, this.lastFlushedLSN, this.lastAppliedLSN, true);
    }

    @Override
    public boolean isClosed() {
        return this.closeFlag || !this.copyDual.isActive();
    }

    private @Nullable ByteBuffer readInternal(boolean bl) {
        boolean bl2 = false;
        block4: while (this.copyDual.isActive()) {
            ByteBuffer byteBuffer = this.receiveNextData(bl);
            if (bl2 || this.isTimeUpdate()) {
                this.timeUpdateStatus();
            }
            if (byteBuffer == null) {
                return null;
            }
            byte by = byteBuffer.get();
            switch (by) {
                case 107: {
                    bl2 = this.processKeepAliveMessage(byteBuffer);
                    bl2 |= this.updateInterval == 0L;
                    continue block4;
                }
                case 119: {
                    return this.processXLogData(byteBuffer);
                }
            }
            throw new PSQLException(GT.tr("Unexpected packet type during replication: {0}", Integer.toString(by)), PSQLState.PROTOCOL_VIOLATION);
        }
        return null;
    }

    private @Nullable ByteBuffer receiveNextData(boolean bl) {
        try {
            byte[] byArray = this.copyDual.readFromCopy(bl);
            if (byArray != null) {
                return ByteBuffer.wrap(byArray);
            }
            return null;
        }
        catch (PSQLException pSQLException) {
            if (pSQLException.getCause() instanceof SocketTimeoutException) {
                return null;
            }
            throw pSQLException;
        }
    }

    private boolean isTimeUpdate() {
        if (this.updateInterval == 0L) {
            return false;
        }
        long l = System.nanoTime() - this.lastStatusUpdate;
        return l >= this.updateInterval;
    }

    private void timeUpdateStatus() {
        this.updateStatusInternal(this.lastReceiveLSN, this.lastFlushedLSN, this.lastAppliedLSN, false);
    }

    private void updateStatusInternal(LogSequenceNumber logSequenceNumber, LogSequenceNumber logSequenceNumber2, LogSequenceNumber logSequenceNumber3, boolean bl) {
        byte[] byArray = this.prepareUpdateStatus(logSequenceNumber, logSequenceNumber2, logSequenceNumber3, bl);
        this.copyDual.writeToCopy(byArray, 0, byArray.length);
        this.copyDual.flushCopy();
        this.lastStatusUpdate = System.nanoTime();
    }

    private byte[] prepareUpdateStatus(LogSequenceNumber logSequenceNumber, LogSequenceNumber logSequenceNumber2, LogSequenceNumber logSequenceNumber3, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(34);
        long l = System.nanoTime() / 1000000L;
        long l2 = TimeUnit.MICROSECONDS.convert(l - 946684800000L, TimeUnit.MICROSECONDS);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " FE=> StandbyStatusUpdate(received: {0}, flushed: {1}, applied: {2}, clock: {3})", new Object[]{logSequenceNumber.asString(), logSequenceNumber2.asString(), logSequenceNumber3.asString(), new Date(l)});
        }
        byteBuffer.put((byte)114);
        byteBuffer.putLong(logSequenceNumber.asLong());
        byteBuffer.putLong(logSequenceNumber2.asLong());
        byteBuffer.putLong(logSequenceNumber3.asLong());
        byteBuffer.putLong(l2);
        if (bl) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put(logSequenceNumber == LogSequenceNumber.INVALID_LSN ? (byte)1 : 0);
        }
        this.lastStatusUpdate = l;
        return byteBuffer.array();
    }

    private boolean processKeepAliveMessage(ByteBuffer byteBuffer) {
        boolean bl;
        this.lastServerLSN = LogSequenceNumber.valueOf(byteBuffer.getLong());
        if (this.lastServerLSN.asLong() > this.lastReceiveLSN.asLong()) {
            this.lastReceiveLSN = this.lastServerLSN;
        }
        long l = byteBuffer.getLong();
        boolean bl2 = bl = byteBuffer.get() != 0;
        if (LOGGER.isLoggable(Level.FINEST)) {
            Date date = new Date(TimeUnit.MILLISECONDS.convert(l, TimeUnit.MICROSECONDS) + 946684800000L);
            LOGGER.log(Level.FINEST, "  <=BE Keepalive(lastServerWal: {0}, clock: {1} needReply: {2})", new Object[]{this.lastServerLSN.asString(), date, bl});
        }
        return bl;
    }

    private ByteBuffer processXLogData(ByteBuffer byteBuffer) {
        long l = byteBuffer.getLong();
        this.lastServerLSN = LogSequenceNumber.valueOf(byteBuffer.getLong());
        long l2 = byteBuffer.getLong();
        switch (this.replicationType) {
            case LOGICAL: {
                this.lastReceiveLSN = LogSequenceNumber.valueOf(l);
                break;
            }
            case PHYSICAL: {
                int n = byteBuffer.limit() - byteBuffer.position();
                this.lastReceiveLSN = LogSequenceNumber.valueOf(l + (long)n);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "  <=BE XLogData(currWal: {0}, lastServerWal: {1}, clock: {2})", new Object[]{this.lastReceiveLSN.asString(), this.lastServerLSN.asString(), l2});
        }
        return byteBuffer.slice();
    }

    private void checkClose() {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This replication stream has been closed.", new Object[0]), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        LOGGER.log(Level.FINEST, " FE=> StopReplication");
        this.copyDual.endCopy();
        this.closeFlag = true;
    }
}

