/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.fastpath;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.fastpath.FastpathArg;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public class Fastpath {
    private static final long NUM_OIDS = 0x100000000L;
    private final Map<String, Integer> func = new HashMap<String, Integer>();
    private final QueryExecutor executor;
    private final BaseConnection connection;

    public Fastpath(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.executor = baseConnection.getQueryExecutor();
    }

    @Deprecated
    public @Nullable Object fastpath(int n, boolean bl, FastpathArg[] fastpathArgArray) {
        byte[] byArray = this.fastpath(n, fastpathArgArray);
        if (!bl || byArray == null) {
            return byArray;
        }
        if (byArray.length == 4) {
            return ByteConverter.int4(byArray, 0);
        }
        if (byArray.length == 8) {
            return ByteConverter.int8(byArray, 0);
        }
        throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected a numeric.", n), PSQLState.NO_DATA);
    }

    public byte @Nullable [] fastpath(int n, FastpathArg[] fastpathArgArray) {
        ParameterList parameterList = this.executor.createFastpathParameters(fastpathArgArray.length);
        for (int i = 0; i < fastpathArgArray.length; ++i) {
            fastpathArgArray[i].populateParameter(parameterList, i + 1);
        }
        return this.executor.fastpathCall(n, parameterList, this.connection.getAutoCommit());
    }

    @Deprecated
    public @Nullable Object fastpath(String string, boolean bl, FastpathArg[] fastpathArgArray) {
        this.connection.getLogger().log(Level.FINEST, "Fastpath: calling {0}", string);
        return this.fastpath(this.getID(string), bl, fastpathArgArray);
    }

    public byte @Nullable [] fastpath(String string, FastpathArg[] fastpathArgArray) {
        this.connection.getLogger().log(Level.FINEST, "Fastpath: calling {0}", string);
        return this.fastpath(this.getID(string), fastpathArgArray);
    }

    public int getInteger(String string, FastpathArg[] fastpathArgArray) {
        byte[] byArray = this.fastpath(string, fastpathArgArray);
        if (byArray == null) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", string), PSQLState.NO_DATA);
        }
        if (byArray.length == 4) {
            return ByteConverter.int4(byArray, 0);
        }
        throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned or wrong size while expecting an integer.", string), PSQLState.NO_DATA);
    }

    public long getLong(String string, FastpathArg[] fastpathArgArray) {
        byte[] byArray = this.fastpath(string, fastpathArgArray);
        if (byArray == null) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected a long.", string), PSQLState.NO_DATA);
        }
        if (byArray.length == 8) {
            return ByteConverter.int8(byArray, 0);
        }
        throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned or wrong size while expecting a long.", string), PSQLState.NO_DATA);
    }

    public long getOID(String string, FastpathArg[] fastpathArgArray) {
        long l = this.getInteger(string, fastpathArgArray);
        if (l < 0L) {
            l += 0x100000000L;
        }
        return l;
    }

    public byte @Nullable [] getData(String string, FastpathArg[] fastpathArgArray) {
        return this.fastpath(string, fastpathArgArray);
    }

    public void addFunction(String string, int n) {
        this.func.put(string, n);
    }

    public void addFunctions(ResultSet resultSet) {
        while (resultSet.next()) {
            this.func.put(Nullness.castNonNull(resultSet.getString(1)), resultSet.getInt(2));
        }
    }

    public int getID(String string) {
        Integer n = this.func.get(string);
        if (n == null) {
            throw new PSQLException(GT.tr("The fastpath function {0} is unknown.", string), PSQLState.UNEXPECTED_ERROR);
        }
        return n;
    }

    public static FastpathArg createOIDArg(long l) {
        if (l > Integer.MAX_VALUE) {
            l -= 0x100000000L;
        }
        return new FastpathArg((int)l);
    }
}

