/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.geometric;

import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGBinaryObject;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGbox
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public PGpoint @Nullable [] point;

    public PGbox(double d, double d2, double d3, double d4) {
        this(new PGpoint(d, d2), new PGpoint(d3, d4));
    }

    public PGbox(PGpoint pGpoint, PGpoint pGpoint2) {
        this();
        this.point = new PGpoint[]{pGpoint, pGpoint2};
    }

    public PGbox(String string) {
        this();
        this.setValue(string);
    }

    public PGbox() {
        this.type = "box";
    }

    @Override
    public void setValue(@Nullable String string) {
        if (string == null) {
            this.point = null;
            return;
        }
        PGtokenizer pGtokenizer = new PGtokenizer(string, ',');
        if (pGtokenizer.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, string), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGpoint[] pGpointArray = this.point;
        if (pGpointArray == null) {
            this.point = pGpointArray = new PGpoint[2];
        }
        pGpointArray[0] = new PGpoint(pGtokenizer.getToken(0));
        pGpointArray[1] = new PGpoint(pGtokenizer.getToken(1));
    }

    @Override
    public void setByteValue(byte[] byArray, int n) {
        PGpoint[] pGpointArray = this.point;
        if (pGpointArray == null) {
            this.point = pGpointArray = new PGpoint[2];
        }
        pGpointArray[0] = new PGpoint();
        pGpointArray[0].setByteValue(byArray, n);
        pGpointArray[1] = new PGpoint();
        pGpointArray[1].setByteValue(byArray, n + pGpointArray[0].lengthInBytes());
        this.point = pGpointArray;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof PGbox) {
            PGbox pGbox = (PGbox)object;
            PGpoint[] pGpointArray = this.point;
            PGpoint[] pGpointArray2 = pGbox.point;
            if (pGpointArray == null) {
                return pGpointArray2 == null;
            }
            if (pGpointArray2 == null) {
                return false;
            }
            if (pGpointArray2[0].equals(pGpointArray[0]) && pGpointArray2[1].equals(pGpointArray[1])) {
                return true;
            }
            if (pGpointArray2[0].equals(pGpointArray[1]) && pGpointArray2[1].equals(pGpointArray[0])) {
                return true;
            }
            if (pGpointArray2[0].x == pGpointArray[0].x && pGpointArray2[0].y == pGpointArray[1].y && pGpointArray2[1].x == pGpointArray[1].x && pGpointArray2[1].y == pGpointArray[0].y) {
                return true;
            }
            if (pGpointArray2[0].x == pGpointArray[1].x && pGpointArray2[0].y == pGpointArray[0].y && pGpointArray2[1].x == pGpointArray[0].x && pGpointArray2[1].y == pGpointArray[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        PGpoint[] pGpointArray = this.point;
        return pGpointArray == null ? 0 : pGpointArray[0].hashCode() ^ pGpointArray[1].hashCode();
    }

    @Override
    public Object clone() {
        PGbox pGbox = (PGbox)super.clone();
        if (pGbox.point != null) {
            pGbox.point = (PGpoint[])pGbox.point.clone();
            for (int i = 0; i < pGbox.point.length; ++i) {
                if (pGbox.point[i] == null) continue;
                pGbox.point[i] = (PGpoint)pGbox.point[i].clone();
            }
        }
        return pGbox;
    }

    @Override
    public @Nullable String getValue() {
        PGpoint[] pGpointArray = this.point;
        return pGpointArray == null ? null : pGpointArray[0].toString() + "," + pGpointArray[1].toString();
    }

    @Override
    public int lengthInBytes() {
        PGpoint[] pGpointArray = this.point;
        if (pGpointArray == null) {
            return 0;
        }
        return pGpointArray[0].lengthInBytes() + pGpointArray[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] byArray, int n) {
        PGpoint[] pGpointArray = Nullness.castNonNull(this.point);
        pGpointArray[0].toBytes(byArray, n);
        pGpointArray[1].toBytes(byArray, n + pGpointArray[0].lengthInBytes());
    }
}

