/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.geometric;

import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public @Nullable PGpoint center;
    public double radius;

    public PGcircle(double d, double d2, double d3) {
        this(new PGpoint(d, d2), d3);
    }

    public PGcircle(PGpoint pGpoint, double d) {
        this();
        this.center = pGpoint;
        this.radius = d;
    }

    public PGcircle(String string) {
        this();
        this.setValue(string);
    }

    public PGcircle() {
        this.type = "circle";
    }

    @Override
    public void setValue(@Nullable String string) {
        if (string == null) {
            this.center = null;
            return;
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removeAngle(string), ',');
        if (pGtokenizer.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, string), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new PGpoint(pGtokenizer.getToken(0));
            this.radius = Double.parseDouble(pGtokenizer.getToken(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, string), PSQLState.DATA_TYPE_MISMATCH, (Throwable)numberFormatException);
        }
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof PGcircle) {
            PGcircle pGcircle = (PGcircle)object;
            PGpoint pGpoint = this.center;
            PGpoint pGpoint2 = pGcircle.center;
            if (pGpoint == null) {
                return pGpoint2 == null;
            }
            if (pGpoint2 == null) {
                return false;
            }
            return pGcircle.radius == this.radius && PGcircle.equals(pGpoint2, pGpoint);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.center == null) {
            return 0;
        }
        long l = Double.doubleToLongBits(this.radius);
        int n = (int)(l ^ l >>> 32);
        n = n * 31 + this.center.hashCode();
        return n;
    }

    @Override
    public Object clone() {
        PGcircle pGcircle = (PGcircle)super.clone();
        if (pGcircle.center != null) {
            pGcircle.center = (PGpoint)pGcircle.center.clone();
        }
        return pGcircle;
    }

    @Override
    public @Nullable String getValue() {
        return this.center == null ? null : "<" + this.center + "," + this.radius + ">";
    }
}

