/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.geometric;

import com.hm.postgresql.geometric.PGlseg;
import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGline
extends PGobject
implements Serializable,
Cloneable {
    public double a;
    public double b;
    public double c;
    private boolean isNull;

    public PGline(double d, double d2, double d3) {
        this();
        this.a = d;
        this.b = d2;
        this.c = d3;
    }

    public PGline(double d, double d2, double d3, double d4) {
        this();
        this.setValue(d, d2, d3, d4);
    }

    public PGline(@Nullable PGpoint pGpoint, @Nullable PGpoint pGpoint2) {
        this();
        this.setValue(pGpoint, pGpoint2);
    }

    public PGline(@Nullable PGlseg pGlseg) {
        this();
        if (pGlseg == null) {
            this.isNull = true;
            return;
        }
        PGpoint[] pGpointArray = pGlseg.point;
        if (pGpointArray == null) {
            this.isNull = true;
            return;
        }
        this.setValue(pGpointArray[0], pGpointArray[1]);
    }

    private void setValue(@Nullable PGpoint pGpoint, @Nullable PGpoint pGpoint2) {
        if (pGpoint == null || pGpoint2 == null) {
            this.isNull = true;
        } else {
            this.setValue(pGpoint.x, pGpoint.y, pGpoint2.x, pGpoint2.y);
        }
    }

    private void setValue(double d, double d2, double d3, double d4) {
        if (d == d3) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (d4 - d2) / (d3 - d);
            this.b = -1.0;
        }
        this.c = d2 - this.a * d;
    }

    public PGline(String string) {
        this();
        this.setValue(string);
    }

    public PGline() {
        this.type = "line";
    }

    @Override
    public void setValue(@Nullable String string) {
        boolean bl = this.isNull = string == null;
        if (string == null) {
            return;
        }
        if (string.trim().startsWith("{")) {
            PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removeCurlyBrace(string), ',');
            if (pGtokenizer.getSize() != 3) {
                throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, string), PSQLState.DATA_TYPE_MISMATCH);
            }
            this.a = Double.parseDouble(pGtokenizer.getToken(0));
            this.b = Double.parseDouble(pGtokenizer.getToken(1));
            this.c = Double.parseDouble(pGtokenizer.getToken(2));
        } else if (string.trim().startsWith("[")) {
            PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removeBox(string), ',');
            if (pGtokenizer.getSize() != 2) {
                throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, string), PSQLState.DATA_TYPE_MISMATCH);
            }
            PGpoint pGpoint = new PGpoint(pGtokenizer.getToken(0));
            PGpoint pGpoint2 = new PGpoint(pGtokenizer.getToken(1));
            this.a = pGpoint2.x - pGpoint.x;
            this.b = pGpoint2.y - pGpoint.y;
            this.c = pGpoint.y;
        }
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PGline pGline = (PGline)object;
        if (this.isNull) {
            return pGline.isNull;
        }
        if (pGline.isNull) {
            return false;
        }
        return Double.compare(pGline.a, this.a) == 0 && Double.compare(pGline.b, this.b) == 0 && Double.compare(pGline.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        if (this.isNull) {
            return 0;
        }
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.a);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.b);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.c);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public @Nullable String getValue() {
        return this.isNull ? null : "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

