/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.geometric;

import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGBinaryObject;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.awt.Point;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGpoint
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public double x;
    public double y;
    public boolean isNull;

    public PGpoint(double d, double d2) {
        this();
        this.x = d;
        this.y = d2;
    }

    public PGpoint(String string) {
        this();
        this.setValue(string);
    }

    public PGpoint() {
        this.type = "point";
    }

    @Override
    public void setValue(@Nullable String string) {
        boolean bl = this.isNull = string == null;
        if (string == null) {
            return;
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara(string), ',');
        try {
            this.x = Double.parseDouble(pGtokenizer.getToken(0));
            this.y = Double.parseDouble(pGtokenizer.getToken(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, string), PSQLState.DATA_TYPE_MISMATCH, (Throwable)numberFormatException);
        }
    }

    @Override
    public void setByteValue(byte[] byArray, int n) {
        this.isNull = false;
        this.x = ByteConverter.float8(byArray, n);
        this.y = ByteConverter.float8(byArray, n + 8);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof PGpoint) {
            PGpoint pGpoint = (PGpoint)object;
            if (this.isNull) {
                return pGpoint.isNull;
            }
            if (pGpoint.isNull) {
                return false;
            }
            return this.x == pGpoint.x && this.y == pGpoint.y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isNull) {
            return 0;
        }
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l2 ^ l >>> 32 ^ l2 >>> 32);
    }

    @Override
    public @Nullable String getValue() {
        return this.isNull ? null : "(" + this.x + "," + this.y + ")";
    }

    @Override
    public int lengthInBytes() {
        return this.isNull ? 0 : 16;
    }

    @Override
    public void toBytes(byte[] byArray, int n) {
        if (this.isNull) {
            return;
        }
        ByteConverter.float8(byArray, n, this.x);
        ByteConverter.float8(byArray, n + 8, this.y);
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        this.isNull = false;
        this.x += d;
        this.y += d2;
    }

    public void move(int n, int n2) {
        this.setLocation(n, n2);
    }

    public void move(double d, double d2) {
        this.isNull = false;
        this.x = d;
        this.y = d2;
    }

    public void setLocation(int n, int n2) {
        this.move((double)n, (double)n2);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

