/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.gss;

import java.io.IOException;
import java.io.OutputStream;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class GSSOutputStream
extends OutputStream {
    private final GSSContext gssContext;
    private final MessageProp messageProp;
    private byte[] buffer;
    private byte[] int4Buf = new byte[4];
    private int index;
    private OutputStream wrapped;

    public GSSOutputStream(OutputStream outputStream, GSSContext gSSContext, MessageProp messageProp, int n) {
        this.wrapped = outputStream;
        this.gssContext = gSSContext;
        this.messageProp = messageProp;
        this.buffer = new byte[n];
    }

    @Override
    public void write(int n) {
        this.buffer[this.index++] = (byte)n;
        if (this.index >= this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = this.buffer.length - this.index;
            if (n2 < n3) {
                System.arraycopy(byArray, n, this.buffer, this.index, n2);
                this.index += n2;
                n2 -= n3;
            } else {
                System.arraycopy(byArray, n, this.buffer, this.index, n3);
                this.index += n3;
                n2 -= n3;
            }
            if (n3 != 0) continue;
            this.flush();
        }
    }

    @Override
    public void flush() {
        try {
            byte[] byArray = this.gssContext.wrap(this.buffer, 0, this.index, this.messageProp);
            this.sendInteger4Raw(byArray.length);
            this.wrapped.write(byArray, 0, byArray.length);
            this.index = 0;
        }
        catch (GSSException gSSException) {
            throw new IOException(gSSException);
        }
        this.wrapped.flush();
    }

    private void sendInteger4Raw(int n) {
        this.int4Buf[0] = (byte)(n >>> 24);
        this.int4Buf[1] = (byte)(n >>> 16);
        this.int4Buf[2] = (byte)(n >>> 8);
        this.int4Buf[3] = (byte)n;
        this.wrapped.write(this.int4Buf);
    }
}

